/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorization;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;

public abstract class AbstractClient {
    protected final ApiClient apiClient;
    protected final CheckoutConfiguration configuration;
    private final SdkAuthorizationType authorizationType;

    protected AbstractClient(ApiClient apiClient, CheckoutConfiguration configuration, SdkAuthorizationType authorizationType) {
        CheckoutUtils.validateParams("apiClient", apiClient, "configuration", configuration, "authorizationType", (Object)authorizationType);
        this.apiClient = apiClient;
        this.configuration = configuration;
        this.authorizationType = authorizationType;
    }

    protected SdkAuthorization sdkAuthorization(SdkAuthorizationType authorizationType) {
        return this.configuration.getSdkCredentials().getAuthorization(authorizationType);
    }

    protected SdkAuthorization sdkAuthorization() {
        return this.configuration.getSdkCredentials().getAuthorization(this.authorizationType);
    }

    protected static String buildPath(String ... pathParams) {
        return String.join((CharSequence)"/", pathParams);
    }

    protected boolean isSandbox() {
        return this.configuration.getEnvironment().isSandbox();
    }
}

