/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.CheckoutArgumentException;
import com.checkout.PlatformType;
import com.checkout.SdkCredentials;
import com.checkout.common.CheckoutUtils;

abstract class AbstractStaticKeysSdkCredentials
extends SdkCredentials {
    protected final String secretKey;
    protected final String publicKey;

    protected AbstractStaticKeysSdkCredentials(PlatformType platformType, String secretKeyPattern, String publicKeyPattern, String secretKey, String publicKey) {
        super(platformType);
        this.validateSecretKey(secretKey, secretKeyPattern);
        this.validatePublicKey(publicKey, publicKeyPattern);
        this.secretKey = secretKey;
        this.publicKey = publicKey;
    }

    protected void validateSecretKey(String secretKey, String secretKeyPattern) {
        CheckoutUtils.validateParams("secretKey", secretKey);
        if (this.validKey(secretKey, secretKeyPattern)) {
            return;
        }
        throw new CheckoutArgumentException("invalid secret key");
    }

    protected void validatePublicKey(String publicKey, String publicKeyPattern) {
        if (publicKey == null) {
            return;
        }
        if (this.validKey(publicKey, publicKeyPattern)) {
            return;
        }
        throw new CheckoutArgumentException("invalid public key");
    }

    private boolean validKey(String key, String pattern) {
        return key.matches(pattern);
    }

    String getSecretKey() {
        return this.secretKey;
    }

    String getPublicKey() {
        return this.publicKey;
    }
}

