/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.AbstractCheckoutApmApi;
import com.checkout.ApiClient;
import com.checkout.ApiClientImpl;
import com.checkout.CheckoutApi;
import com.checkout.CheckoutApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.UriStrategy;
import com.checkout.accounts.AccountsClient;
import com.checkout.accounts.AccountsClientImpl;
import com.checkout.balances.BalancesClient;
import com.checkout.balances.BalancesClientImpl;
import com.checkout.customers.CustomersClient;
import com.checkout.customers.CustomersClientImpl;
import com.checkout.disputes.DisputesClient;
import com.checkout.disputes.DisputesClientImpl;
import com.checkout.financial.FinancialClient;
import com.checkout.financial.FinancialClientImpl;
import com.checkout.forex.ForexClient;
import com.checkout.forex.ForexClientImpl;
import com.checkout.instruments.InstrumentsClient;
import com.checkout.instruments.InstrumentsClientImpl;
import com.checkout.issuing.IssuingClient;
import com.checkout.issuing.IssuingClientImpl;
import com.checkout.metadata.MetadataClient;
import com.checkout.metadata.MetadataClientImpl;
import com.checkout.payments.PaymentsClient;
import com.checkout.payments.PaymentsClientImpl;
import com.checkout.payments.contexts.PaymentContextsClient;
import com.checkout.payments.contexts.PaymentContextsClientImpl;
import com.checkout.payments.hosted.HostedPaymentsClient;
import com.checkout.payments.hosted.HostedPaymentsClientImpl;
import com.checkout.payments.links.PaymentLinksClient;
import com.checkout.payments.links.PaymentLinksClientImpl;
import com.checkout.payments.sessions.PaymentSessionsClient;
import com.checkout.payments.sessions.PaymentSessionsClientImpl;
import com.checkout.reports.ReportsClient;
import com.checkout.reports.ReportsClientImpl;
import com.checkout.risk.RiskClient;
import com.checkout.risk.RiskClientImpl;
import com.checkout.sessions.SessionsClient;
import com.checkout.sessions.SessionsClientImpl;
import com.checkout.tokens.TokensClient;
import com.checkout.tokens.TokensClientImpl;
import com.checkout.transfers.TransfersClient;
import com.checkout.transfers.TransfersClientImpl;
import com.checkout.workflows.WorkflowsClient;
import com.checkout.workflows.WorkflowsClientImpl;
import java.net.URI;

public class CheckoutApiImpl
extends AbstractCheckoutApmApi
implements CheckoutApi,
CheckoutApiClient {
    private final TokensClient tokensClient;
    private final PaymentsClient paymentsClient;
    private final CustomersClient customersClient;
    private final DisputesClient disputesClient;
    private final InstrumentsClient instrumentsClient;
    private final RiskClient riskClient;
    private final WorkflowsClient workflowsClient;
    private final AccountsClient accountsClient;
    private final SessionsClient sessionsClient;
    private final ForexClient forexClient;
    private final PaymentLinksClient paymentLinksClient;
    private final HostedPaymentsClient hostedPaymentsClient;
    private final TransfersClient transfersClient;
    private final BalancesClient balancesClient;
    private final ReportsClient reportsClient;
    private final MetadataClient metadataClient;
    private final FinancialClient financialClient;
    private final IssuingClient issuingClient;
    private final PaymentContextsClient paymentContextsClient;
    private final PaymentSessionsClient paymentSessionsClient;

    public CheckoutApiImpl(CheckoutConfiguration configuration) {
        super(configuration);
        this.tokensClient = new TokensClientImpl(this.apiClient, configuration);
        this.paymentsClient = new PaymentsClientImpl(this.apiClient, configuration);
        this.customersClient = new CustomersClientImpl(this.apiClient, configuration);
        this.disputesClient = new DisputesClientImpl(this.apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
        this.instrumentsClient = new InstrumentsClientImpl(this.apiClient, configuration);
        this.riskClient = new RiskClientImpl(this.apiClient, configuration);
        this.workflowsClient = new WorkflowsClientImpl(this.apiClient, configuration);
        this.sessionsClient = new SessionsClientImpl(this.apiClient, configuration);
        this.forexClient = new ForexClientImpl(this.apiClient, configuration);
        this.paymentLinksClient = new PaymentLinksClientImpl(this.apiClient, configuration);
        this.hostedPaymentsClient = new HostedPaymentsClientImpl(this.apiClient, configuration);
        this.transfersClient = new TransfersClientImpl(this.getTransfersClient(configuration), configuration);
        this.balancesClient = new BalancesClientImpl(this.getBalancesClient(configuration), configuration);
        this.reportsClient = new ReportsClientImpl(this.apiClient, configuration);
        this.metadataClient = new MetadataClientImpl(this.apiClient, configuration);
        this.financialClient = new FinancialClientImpl(this.apiClient, configuration);
        this.issuingClient = new IssuingClientImpl(this.apiClient, configuration);
        this.accountsClient = new AccountsClientImpl(this.apiClient, this.getFilesClient(configuration), configuration);
        this.paymentContextsClient = new PaymentContextsClientImpl(this.apiClient, configuration);
        this.paymentSessionsClient = new PaymentSessionsClientImpl(this.apiClient, configuration);
    }

    @Override
    public TokensClient tokensClient() {
        return this.tokensClient;
    }

    @Override
    public PaymentsClient paymentsClient() {
        return this.paymentsClient;
    }

    @Override
    public CustomersClient customersClient() {
        return this.customersClient;
    }

    @Override
    public DisputesClient disputesClient() {
        return this.disputesClient;
    }

    @Override
    public InstrumentsClient instrumentsClient() {
        return this.instrumentsClient;
    }

    @Override
    public RiskClient riskClient() {
        return this.riskClient;
    }

    @Override
    public WorkflowsClient workflowsClient() {
        return this.workflowsClient;
    }

    @Override
    public AccountsClient accountsClient() {
        return this.accountsClient;
    }

    @Override
    public SessionsClient sessionsClient() {
        return this.sessionsClient;
    }

    @Override
    public ForexClient forexClient() {
        return this.forexClient;
    }

    @Override
    public PaymentLinksClient paymentLinksClient() {
        return this.paymentLinksClient;
    }

    @Override
    public HostedPaymentsClient hostedPaymentsClient() {
        return this.hostedPaymentsClient;
    }

    @Override
    public BalancesClient balancesClient() {
        return this.balancesClient;
    }

    @Override
    public TransfersClient transfersClient() {
        return this.transfersClient;
    }

    @Override
    public ReportsClient reportsClient() {
        return this.reportsClient;
    }

    @Override
    public MetadataClient metadataClient() {
        return this.metadataClient;
    }

    @Override
    public FinancialClient financialClient() {
        return this.financialClient;
    }

    @Override
    public IssuingClient issuingClient() {
        return this.issuingClient;
    }

    @Override
    public PaymentContextsClient paymentContextsClient() {
        return this.paymentContextsClient;
    }

    @Override
    public PaymentSessionsClient paymentSessionsClient() {
        return this.paymentSessionsClient;
    }

    private ApiClient getFilesClient(CheckoutConfiguration configuration) {
        return new ApiClientImpl(configuration, new FilesApiUriStrategy(configuration));
    }

    private ApiClient getTransfersClient(CheckoutConfiguration configuration) {
        return new ApiClientImpl(configuration, new TransfersApiUriStrategy(configuration));
    }

    private ApiClient getBalancesClient(CheckoutConfiguration configuration) {
        return new ApiClientImpl(configuration, new BalancesApiUriStrategy(configuration));
    }

    private static class BalancesApiUriStrategy
    implements UriStrategy {
        private final CheckoutConfiguration configuration;

        private BalancesApiUriStrategy(CheckoutConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public URI getUri() {
            return this.configuration.getEnvironment().getBalancesApi();
        }
    }

    private static class TransfersApiUriStrategy
    implements UriStrategy {
        private final CheckoutConfiguration configuration;

        private TransfersApiUriStrategy(CheckoutConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public URI getUri() {
            return this.configuration.getEnvironment().getTransfersApi();
        }
    }

    private static class FilesApiUriStrategy
    implements UriStrategy {
        private final CheckoutConfiguration configuration;

        private FilesApiUriStrategy(CheckoutConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public URI getUri() {
            return this.configuration.getEnvironment().getFilesApi();
        }
    }
}

