/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.disputes;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.FileDetailsResponse;
import com.checkout.common.FileRequest;
import com.checkout.common.IdResponse;
import com.checkout.disputes.DisputeCompiledSubmittedEvidenceResponse;
import com.checkout.disputes.DisputeDetailsResponse;
import com.checkout.disputes.DisputeEvidenceRequest;
import com.checkout.disputes.DisputeEvidenceResponse;
import com.checkout.disputes.DisputesClient;
import com.checkout.disputes.DisputesQueryFilter;
import com.checkout.disputes.DisputesQueryResponse;
import com.checkout.disputes.SchemeFileResponse;
import java.util.concurrent.CompletableFuture;

public class DisputesClientImpl
extends AbstractClient
implements DisputesClient {
    private static final String DISPUTES_PATH = "disputes";
    private static final String FILES_PATH = "files";
    private static final String ACCEPT_PATH = "accept";
    private static final String EVIDENCE_PATH = "evidence";
    private static final String SUBMITTED_PATH = "submitted";
    private static final String SCHEME_FILES_PATH = "schemefiles";

    public DisputesClientImpl(ApiClient apiClient, CheckoutConfiguration configuration, SdkAuthorizationType sdkAuthorizationType) {
        super(apiClient, configuration, sdkAuthorizationType);
    }

    @Override
    public CompletableFuture<DisputesQueryResponse> query(DisputesQueryFilter queryFilter) {
        CheckoutUtils.validateParams("queryFilter", queryFilter);
        return this.apiClient.queryAsync(DISPUTES_PATH, this.sdkAuthorization(), queryFilter, DisputesQueryResponse.class);
    }

    @Override
    public CompletableFuture<DisputeDetailsResponse> getDisputeDetails(String disputeId) {
        CheckoutUtils.validateParams("disputeId", disputeId);
        return this.apiClient.getAsync(DisputesClientImpl.buildPath(DISPUTES_PATH, disputeId), this.sdkAuthorization(), DisputeDetailsResponse.class);
    }

    @Override
    public CompletableFuture<EmptyResponse> accept(String disputeId) {
        CheckoutUtils.validateParams("disputeId", disputeId);
        return this.apiClient.postAsync(DisputesClientImpl.buildPath(DISPUTES_PATH, disputeId, ACCEPT_PATH), this.sdkAuthorization(), EmptyResponse.class, null, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> putEvidence(String disputeId, DisputeEvidenceRequest disputeEvidence) {
        CheckoutUtils.validateParams("disputeId", disputeId, "disputeEvidence", disputeEvidence);
        return this.apiClient.putAsync(DisputesClientImpl.buildPath(DISPUTES_PATH, disputeId, EVIDENCE_PATH), this.sdkAuthorization(), EmptyResponse.class, disputeEvidence);
    }

    @Override
    public CompletableFuture<DisputeEvidenceResponse> getEvidence(String disputeId) {
        CheckoutUtils.validateParams("disputeId", disputeId);
        return this.apiClient.getAsync(DisputesClientImpl.buildPath(DISPUTES_PATH, disputeId, EVIDENCE_PATH), this.sdkAuthorization(), DisputeEvidenceResponse.class);
    }

    @Override
    public CompletableFuture<EmptyResponse> submitEvidence(String disputeId) {
        CheckoutUtils.validateParams("disputeId", disputeId);
        return this.apiClient.postAsync(DisputesClientImpl.buildPath(DISPUTES_PATH, disputeId, EVIDENCE_PATH), this.sdkAuthorization(), EmptyResponse.class, null, null);
    }

    @Override
    public CompletableFuture<IdResponse> uploadFile(FileRequest fileRequest) {
        CheckoutUtils.validateParams("fileRequest", fileRequest);
        return this.apiClient.submitFileAsync(FILES_PATH, this.sdkAuthorization(), fileRequest, IdResponse.class);
    }

    @Override
    public CompletableFuture<FileDetailsResponse> getFileDetails(String fileId) {
        CheckoutUtils.validateParams("fileId", fileId);
        return this.apiClient.getAsync(DisputesClientImpl.buildPath(FILES_PATH, fileId), this.sdkAuthorization(), FileDetailsResponse.class);
    }

    @Override
    public CompletableFuture<DisputeCompiledSubmittedEvidenceResponse> getCompiledSubmittedEvidence(String disputeId) {
        CheckoutUtils.validateParams("disputeId", disputeId);
        return this.apiClient.getAsync(DisputesClientImpl.buildPath(DISPUTES_PATH, disputeId, EVIDENCE_PATH, SUBMITTED_PATH), this.sdkAuthorization(), DisputeCompiledSubmittedEvidenceResponse.class);
    }

    @Override
    public CompletableFuture<SchemeFileResponse> getDisputeSchemeFiles(String disputeId) {
        CheckoutUtils.validateParams("disputeId", disputeId);
        return this.apiClient.getAsync(DisputesClientImpl.buildPath(DISPUTES_PATH, disputeId, SCHEME_FILES_PATH), this.sdkAuthorization(), SchemeFileResponse.class);
    }
}

