/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.payments;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.ItemsResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.payments.CaptureRequest;
import com.checkout.payments.CaptureResponse;
import com.checkout.payments.PaymentAction;
import com.checkout.payments.PaymentsClient;
import com.checkout.payments.PaymentsQueryFilter;
import com.checkout.payments.RefundRequest;
import com.checkout.payments.RefundResponse;
import com.checkout.payments.VoidRequest;
import com.checkout.payments.VoidResponse;
import com.checkout.payments.request.AuthorizationRequest;
import com.checkout.payments.request.PaymentRequest;
import com.checkout.payments.request.PayoutRequest;
import com.checkout.payments.response.AuthorizationResponse;
import com.checkout.payments.response.GetPaymentResponse;
import com.checkout.payments.response.PaymentResponse;
import com.checkout.payments.response.PaymentsQueryResponse;
import com.checkout.payments.response.PayoutResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public final class PaymentsClientImpl
extends AbstractClient
implements PaymentsClient {
    private static final String PAYMENTS_PATH = "payments";
    private static final String ACTIONS_PATH = "actions";
    private static final String CAPTURES_PATH = "captures";
    private static final String AUTHORIZATIONS_PATH = "authorizations";
    private static final String REFUNDS_PATH = "refunds";
    private static final String VOIDS_PATH = "voids";
    private static final Type PAYMENT_ACTIONS_TYPE = new TypeToken<ItemsResponse<PaymentAction>>(){}.getType();

    public PaymentsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<PaymentResponse> requestPayment(PaymentRequest paymentRequest) {
        CheckoutUtils.validateParams("paymentRequest", paymentRequest);
        return this.apiClient.postAsync(PAYMENTS_PATH, this.sdkAuthorization(), PaymentResponse.class, (Object)paymentRequest, null);
    }

    @Override
    public CompletableFuture<PaymentResponse> requestPayment(PaymentRequest paymentRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentRequest", paymentRequest, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PAYMENTS_PATH, this.sdkAuthorization(), PaymentResponse.class, (Object)paymentRequest, idempotencyKey);
    }

    @Override
    public CompletableFuture<PayoutResponse> requestPayout(PayoutRequest payoutRequest) {
        CheckoutUtils.validateParams("payoutRequest", payoutRequest);
        return this.apiClient.postAsync(PAYMENTS_PATH, this.sdkAuthorization(), PayoutResponse.class, (Object)payoutRequest, null);
    }

    @Override
    public CompletableFuture<PayoutResponse> requestPayout(PayoutRequest payoutRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("payoutRequest", payoutRequest, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PAYMENTS_PATH, this.sdkAuthorization(), PayoutResponse.class, (Object)payoutRequest, idempotencyKey);
    }

    @Override
    public CompletableFuture<PaymentsQueryResponse> getPaymentsList(PaymentsQueryFilter queryFilter) {
        CheckoutUtils.validateParams("queryFilter", queryFilter);
        return this.apiClient.queryAsync(PAYMENTS_PATH, this.sdkAuthorization(), queryFilter, PaymentsQueryResponse.class);
    }

    @Override
    public CompletableFuture<GetPaymentResponse> getPayment(String paymentId) {
        CheckoutUtils.validateParams("paymentId", paymentId);
        return this.apiClient.getAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId), this.sdkAuthorization(), GetPaymentResponse.class);
    }

    @Override
    public CompletableFuture<ItemsResponse<PaymentAction>> getPaymentActions(String paymentId) {
        CheckoutUtils.validateParams("paymentId", paymentId);
        return this.apiClient.getAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, ACTIONS_PATH), this.sdkAuthorization(), PAYMENT_ACTIONS_TYPE);
    }

    @Override
    public CompletableFuture<AuthorizationResponse> incrementPaymentAuthorization(String paymentId, AuthorizationRequest authorizationRequest) {
        CheckoutUtils.validateParams("paymentId", paymentId);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, AUTHORIZATIONS_PATH), this.sdkAuthorization(), AuthorizationResponse.class, (Object)authorizationRequest, null);
    }

    @Override
    public CompletableFuture<AuthorizationResponse> incrementPaymentAuthorization(String paymentId, AuthorizationRequest authorizationRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentId", paymentId, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, AUTHORIZATIONS_PATH), this.sdkAuthorization(), AuthorizationResponse.class, (Object)authorizationRequest, idempotencyKey);
    }

    @Override
    public CompletableFuture<CaptureResponse> capturePayment(String paymentId) {
        CheckoutUtils.validateParams("paymentId", paymentId);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, CAPTURES_PATH), this.sdkAuthorization(), CaptureResponse.class, null, null);
    }

    @Override
    public CompletableFuture<CaptureResponse> capturePayment(String paymentId, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentId", paymentId, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, CAPTURES_PATH), this.sdkAuthorization(), CaptureResponse.class, null, idempotencyKey);
    }

    @Override
    public CompletableFuture<CaptureResponse> capturePayment(String paymentId, CaptureRequest captureRequest) {
        CheckoutUtils.validateParams("paymentId", paymentId, "captureRequest", captureRequest);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, CAPTURES_PATH), this.sdkAuthorization(), CaptureResponse.class, (Object)captureRequest, null);
    }

    @Override
    public CompletableFuture<CaptureResponse> capturePayment(String paymentId, CaptureRequest captureRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentId", paymentId, "captureRequest", captureRequest, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, CAPTURES_PATH), this.sdkAuthorization(), CaptureResponse.class, (Object)captureRequest, idempotencyKey);
    }

    @Override
    public CompletableFuture<RefundResponse> refundPayment(String paymentId) {
        CheckoutUtils.validateParams("paymentId", paymentId);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, REFUNDS_PATH), this.sdkAuthorization(), RefundResponse.class, null, null);
    }

    @Override
    public CompletableFuture<RefundResponse> refundPayment(String paymentId, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentId", paymentId, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, REFUNDS_PATH), this.sdkAuthorization(), RefundResponse.class, null, idempotencyKey);
    }

    @Override
    public CompletableFuture<RefundResponse> refundPayment(String paymentId, RefundRequest refundRequest) {
        CheckoutUtils.validateParams("paymentId", paymentId, "refundRequest", refundRequest);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, REFUNDS_PATH), this.sdkAuthorization(), RefundResponse.class, (Object)refundRequest, null);
    }

    @Override
    public CompletableFuture<RefundResponse> refundPayment(String paymentId, RefundRequest refundRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentId", paymentId, "refundRequest", refundRequest, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, REFUNDS_PATH), this.sdkAuthorization(), RefundResponse.class, (Object)refundRequest, idempotencyKey);
    }

    @Override
    public CompletableFuture<VoidResponse> voidPayment(String paymentId) {
        CheckoutUtils.validateParams("paymentId", paymentId);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, VOIDS_PATH), this.sdkAuthorization(), VoidResponse.class, null, null);
    }

    @Override
    public CompletableFuture<VoidResponse> voidPayment(String paymentId, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentId", paymentId, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, VOIDS_PATH), this.sdkAuthorization(), VoidResponse.class, null, idempotencyKey);
    }

    @Override
    public CompletableFuture<VoidResponse> voidPayment(String paymentId, VoidRequest voidRequest) {
        CheckoutUtils.validateParams("paymentId", paymentId, "voidRequest", voidRequest);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, VOIDS_PATH), this.sdkAuthorization(), VoidResponse.class, (Object)voidRequest, null);
    }

    @Override
    public CompletableFuture<VoidResponse> voidPayment(String paymentId, VoidRequest voidRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("paymentId", paymentId, "voidRequest", voidRequest, "idempotencyKey", idempotencyKey);
        return this.apiClient.postAsync(PaymentsClientImpl.buildPath(PAYMENTS_PATH, paymentId, VOIDS_PATH), this.sdkAuthorization(), VoidResponse.class, (Object)voidRequest, idempotencyKey);
    }
}

