/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.CheckoutAuthorizationException;
import com.checkout.PlatformType;
import com.checkout.common.CheckoutUtils;
import java.util.Objects;

public final class SdkAuthorization {
    private static final String BEARER = "Bearer ";
    private final PlatformType platformType;
    private final String credential;

    public SdkAuthorization(PlatformType platformType, String credential) {
        CheckoutUtils.validateParams("platformType", (Object)platformType);
        this.platformType = platformType;
        this.credential = credential;
    }

    public String getAuthorizationHeader() {
        switch (this.platformType) {
            case PREVIOUS: 
            case CUSTOM: {
                return this.credential;
            }
            case DEFAULT: 
            case DEFAULT_OAUTH: {
                return BEARER + this.credential;
            }
        }
        throw new CheckoutAuthorizationException("Invalid platform type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkAuthorization that = (SdkAuthorization)o;
        return this.platformType == that.platformType && this.credential.equals(that.credential);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.platformType, this.credential});
    }
}

