/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.customers;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.IdResponse;
import com.checkout.customers.CustomerRequest;
import com.checkout.customers.CustomerResponse;
import com.checkout.customers.CustomersClient;
import java.util.concurrent.CompletableFuture;

public class CustomersClientImpl
extends AbstractClient
implements CustomersClient {
    private static final String CUSTOMERS_PATH = "customers";

    public CustomersClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<CustomerResponse> get(String customerId) {
        CheckoutUtils.validateParams("customerId", customerId);
        return this.apiClient.getAsync(this.getCustomersUrl(customerId), this.sdkAuthorization(), CustomerResponse.class);
    }

    @Override
    public CompletableFuture<IdResponse> create(CustomerRequest customerRequest) {
        CheckoutUtils.validateParams("customerRequest", customerRequest);
        return this.apiClient.postAsync(CUSTOMERS_PATH, this.sdkAuthorization(), IdResponse.class, (Object)customerRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> update(String customerId, CustomerRequest customerRequest) {
        CheckoutUtils.validateParams("customerId", customerId, "customerRequest", customerRequest);
        return this.apiClient.patchAsync(this.getCustomersUrl(customerId), this.sdkAuthorization(), EmptyResponse.class, (Object)customerRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> delete(String customerId) {
        CheckoutUtils.validateParams("customerId", customerId);
        return this.apiClient.deleteAsync(this.getCustomersUrl(customerId), this.sdkAuthorization());
    }

    private String getCustomersUrl(String customerId) {
        return CustomersClientImpl.buildPath(CUSTOMERS_PATH, customerId);
    }
}

