/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.events.previous;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.ItemsResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.events.previous.EventNotificationResponse;
import com.checkout.events.previous.EventResponse;
import com.checkout.events.previous.EventTypes;
import com.checkout.events.previous.EventsClient;
import com.checkout.events.previous.EventsPageResponse;
import com.checkout.events.previous.RetrieveEventsRequest;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public class EventsClientImpl
extends AbstractClient
implements EventsClient {
    private static final String EVENT_TYPES_PATH = "event-types";
    private static final String EVENTS_PATH = "events";
    private static final String NOTIFICATIONS_PATH = "notifications";
    private static final String WEBHOOKS_PATH = "webhooks";
    private static final String EVENT_ID = "eventId";
    private static final Type EVENT_TYPES_TYPE = new TypeToken<ItemsResponse<EventTypes>>(){}.getType();

    public EventsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<ItemsResponse<EventTypes>> retrieveAllEventTypes(String version) {
        StringBuilder path = new StringBuilder(EVENT_TYPES_PATH);
        if (version != null) {
            path.append("?version=").append(version);
        }
        return this.apiClient.getAsync(path.toString(), this.sdkAuthorization(), EVENT_TYPES_TYPE);
    }

    @Override
    public CompletableFuture<EventsPageResponse> retrieveEvents(RetrieveEventsRequest retrieveEventsRequest) {
        CheckoutUtils.validateParams("retrieveEventsRequest", retrieveEventsRequest);
        return this.apiClient.queryAsync(EVENTS_PATH, this.sdkAuthorization(), retrieveEventsRequest, EventsPageResponse.class);
    }

    @Override
    public CompletableFuture<EventResponse> retrieveEvent(String eventId) {
        CheckoutUtils.validateParams(EVENT_ID, eventId);
        return this.apiClient.getAsync(EventsClientImpl.buildPath(EVENTS_PATH, eventId), this.sdkAuthorization(), EventResponse.class);
    }

    @Override
    public CompletableFuture<EventNotificationResponse> retrieveEventNotification(String eventId, String notificationId) {
        CheckoutUtils.validateParams(EVENT_ID, eventId, "notificationId", notificationId);
        return this.apiClient.getAsync(EventsClientImpl.buildPath(EVENTS_PATH, eventId, NOTIFICATIONS_PATH, notificationId), this.sdkAuthorization(), EventNotificationResponse.class);
    }

    @Override
    public CompletableFuture<EmptyResponse> retryWebhook(String eventId, String webhookId) {
        CheckoutUtils.validateParams(EVENT_ID, eventId, "webhookId", webhookId);
        return this.apiClient.postAsync(EventsClientImpl.buildPath(EVENTS_PATH, eventId, WEBHOOKS_PATH, webhookId, "retry"), this.sdkAuthorization(), EmptyResponse.class, null, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> retryAllWebhooks(String eventId) {
        CheckoutUtils.validateParams(EVENT_ID, eventId);
        return this.apiClient.postAsync(EventsClientImpl.buildPath(EVENTS_PATH, eventId, WEBHOOKS_PATH, "retry"), this.sdkAuthorization(), EmptyResponse.class, null, null);
    }
}

