/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.CheckoutAuthorizationException;
import com.checkout.CheckoutException;
import com.checkout.GsonSerializer;
import com.checkout.OAuthAccessToken;
import com.checkout.OAuthScope;
import com.checkout.PlatformType;
import com.checkout.SdkAuthorization;
import com.checkout.SdkAuthorizationType;
import com.checkout.SdkCredentials;
import com.checkout.common.CheckoutUtils;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuthSdkCredentials
extends SdkCredentials {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthSdkCredentials.class);
    private final URI authorizationUri;
    private final String clientId;
    private final String clientSecret;
    private final Set<OAuthScope> scopes;
    private CloseableHttpClient client;
    private GsonSerializer serializer;
    private OAuthAccessToken accessToken;

    OAuthSdkCredentials(HttpClientBuilder httpClientBuilder, URI authorizationUri, String clientId, String clientSecret, Set<OAuthScope> scopes) {
        super(PlatformType.DEFAULT_OAUTH);
        CheckoutUtils.validateParams("httpClientBuilder", httpClientBuilder, "authorizationUri", authorizationUri, "clientId", clientId, "clientSecret", clientSecret, "scopes", scopes);
        this.client = httpClientBuilder.build();
        this.authorizationUri = authorizationUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = scopes;
        this.serializer = new GsonSerializer();
    }

    void initOAuthAccess() {
        this.getAccessToken();
    }

    @Override
    public SdkAuthorization getAuthorization(SdkAuthorizationType authorizationType) {
        switch (authorizationType) {
            case SECRET_KEY_OR_OAUTH: 
            case PUBLIC_KEY_OR_OAUTH: 
            case OAUTH: {
                return new SdkAuthorization(this.platformType, this.getAccessToken().getToken());
            }
        }
        throw CheckoutAuthorizationException.invalidAuthorization(authorizationType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized OAuthAccessToken getAccessToken() {
        if (this.accessToken != null && this.accessToken.isValid()) {
            return this.accessToken;
        }
        HttpPost httpPost = new HttpPost(this.authorizationUri);
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        try {
            List<NameValuePair> data = Arrays.asList(new BasicNameValuePair("client_id", this.clientId), new BasicNameValuePair("client_secret", this.clientSecret), new BasicNameValuePair("grant_type", "client_credentials"), new BasicNameValuePair("scope", this.scopes.stream().map(OAuthScope::getScope).collect(Collectors.joining(" "))));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(data));
        }
        catch (UnsupportedEncodingException ignore) {
            throw new CheckoutException("failed to encode oAuth URI");
        }
        log.debug("requesting OAuth token using client_credentials flow");
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);){
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charsets.UTF_8);
            OAuthServiceResponse oAuthServiceResponse = this.serializer.fromJson(json, OAuthServiceResponse.class);
            if (oAuthServiceResponse.error != null) {
                throw new CheckoutException(String.format("OAuth client_credentials authentication failed with error: %s", oAuthServiceResponse.error));
            }
            OAuthAccessToken oAuthAccessToken = this.accessToken = new OAuthAccessToken(oAuthServiceResponse.accessToken, LocalDateTime.now().plusSeconds(oAuthServiceResponse.expiresIn));
            return oAuthAccessToken;
        }
        catch (IOException e) {
            throw new CheckoutException("OAuth client_credentials authentication failed", e);
        }
    }

    void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    void setSerializer(GsonSerializer serializer) {
        this.serializer = serializer;
    }

    OAuthAccessToken getOAuthAccessToken() {
        return this.accessToken;
    }

    synchronized void setAccessToken(OAuthAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    private static class OAuthServiceResponse {
        @SerializedName(value="access_token")
        String accessToken;
        @SerializedName(value="expires_in")
        Long expiresIn;
        String error;

        private OAuthServiceResponse() {
        }
    }
}

