/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.apm.previous.klarna;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.apm.previous.klarna.CreditSession;
import com.checkout.apm.previous.klarna.CreditSessionRequest;
import com.checkout.apm.previous.klarna.CreditSessionResponse;
import com.checkout.apm.previous.klarna.KlarnaClient;
import com.checkout.apm.previous.klarna.OrderCaptureRequest;
import com.checkout.common.CheckoutUtils;
import com.checkout.payments.CaptureResponse;
import com.checkout.payments.VoidRequest;
import com.checkout.payments.VoidResponse;
import java.util.concurrent.CompletableFuture;

public class KlarnaClientImpl
extends AbstractClient
implements KlarnaClient {
    private static final String CREDIT_SESSIONS = "credit-sessions";
    private static final String ORDERS = "orders";
    private static final String CAPTURES = "captures";
    private static final String VOIDS = "voids";

    public KlarnaClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.PUBLIC_KEY);
    }

    @Override
    public CompletableFuture<CreditSessionResponse> createCreditSession(CreditSessionRequest creditSessionRequest) {
        CheckoutUtils.validateParams("creditSessionRequest", creditSessionRequest);
        return this.apiClient.postAsync(KlarnaClientImpl.buildPath(this.getBaseURL(), CREDIT_SESSIONS), this.sdkAuthorization(), CreditSessionResponse.class, (Object)creditSessionRequest, null);
    }

    @Override
    public CompletableFuture<CreditSession> getCreditSession(String sessionId) {
        CheckoutUtils.validateParams("sessionId", sessionId);
        return this.apiClient.getAsync(KlarnaClientImpl.buildPath(this.getBaseURL(), CREDIT_SESSIONS, sessionId), this.sdkAuthorization(), CreditSession.class);
    }

    @Override
    public CompletableFuture<CaptureResponse> capturePayment(String paymentId, OrderCaptureRequest captureRequest) {
        CheckoutUtils.validateParams("paymentId", paymentId, "captureRequest", captureRequest);
        return this.apiClient.postAsync(KlarnaClientImpl.buildPath(this.getBaseURL(), ORDERS, paymentId, CAPTURES), this.sdkAuthorization(), CaptureResponse.class, (Object)captureRequest, null);
    }

    @Override
    public CompletableFuture<VoidResponse> voidPayment(String paymentId, VoidRequest voidRequest) {
        CheckoutUtils.validateParams("paymentId", paymentId, "voidRequest", voidRequest);
        return this.apiClient.postAsync(KlarnaClientImpl.buildPath(this.getBaseURL(), ORDERS, paymentId, VOIDS), this.sdkAuthorization(), VoidResponse.class, (Object)voidRequest, null);
    }

    private String getBaseURL() {
        if (this.isSandbox()) {
            return "klarna-external";
        }
        return "klarna";
    }
}

