/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.payments.contexts;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.payments.contexts.PaymentContextDetailsResponse;
import com.checkout.payments.contexts.PaymentContextsClient;
import com.checkout.payments.contexts.PaymentContextsRequest;
import com.checkout.payments.contexts.PaymentContextsRequestResponse;
import java.util.concurrent.CompletableFuture;

public class PaymentContextsClientImpl
extends AbstractClient
implements PaymentContextsClient {
    private static final String PAYMENT_CONTEXTS_PATH = "payment-contexts";

    public PaymentContextsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<PaymentContextsRequestResponse> requestPaymentContexts(PaymentContextsRequest paymentContextsRequest) {
        CheckoutUtils.validateParams("paymentContextsRequest", paymentContextsRequest);
        return this.apiClient.postAsync(PAYMENT_CONTEXTS_PATH, this.sdkAuthorization(), PaymentContextsRequestResponse.class, (Object)paymentContextsRequest, null);
    }

    @Override
    public CompletableFuture<PaymentContextDetailsResponse> getPaymentContextDetails(String paymentContextId) {
        CheckoutUtils.validateParams("paymentContextId", paymentContextId);
        return this.apiClient.getAsync(PaymentContextsClientImpl.buildPath(PAYMENT_CONTEXTS_PATH, paymentContextId), this.sdkAuthorization(), PaymentContextDetailsResponse.class);
    }
}

