/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.risk;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.risk.RiskClient;
import com.checkout.risk.preauthentication.PreAuthenticationAssessmentRequest;
import com.checkout.risk.preauthentication.PreAuthenticationAssessmentResponse;
import com.checkout.risk.precapture.PreCaptureAssessmentRequest;
import com.checkout.risk.precapture.PreCaptureAssessmentResponse;
import java.util.concurrent.CompletableFuture;

public class RiskClientImpl
extends AbstractClient
implements RiskClient {
    private static final String PRE_AUTHENTICATION_PATH = "risk/assessments/pre-authentication";
    private static final String PRE_CAPTURE_PATH = "risk/assessments/pre-capture";

    public RiskClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<PreAuthenticationAssessmentResponse> requestPreAuthenticationRiskScan(PreAuthenticationAssessmentRequest preAuthenticationAssessmentRequest) {
        CheckoutUtils.validateParams("preAuthenticationAssessmentRequest", preAuthenticationAssessmentRequest);
        return this.apiClient.postAsync(PRE_AUTHENTICATION_PATH, this.sdkAuthorization(), PreAuthenticationAssessmentResponse.class, (Object)preAuthenticationAssessmentRequest, null);
    }

    @Override
    public CompletableFuture<PreCaptureAssessmentResponse> requestPreCaptureRiskScan(PreCaptureAssessmentRequest preCaptureAssessmentRequest) {
        CheckoutUtils.validateParams("preCaptureAssessmentRequest", preCaptureAssessmentRequest);
        return this.apiClient.postAsync(PRE_CAPTURE_PATH, this.sdkAuthorization(), PreCaptureAssessmentResponse.class, (Object)preCaptureAssessmentRequest, null);
    }
}

