/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.webhooks.previous;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.ItemsResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.webhooks.previous.WebhookRequest;
import com.checkout.webhooks.previous.WebhookResponse;
import com.checkout.webhooks.previous.WebhooksClient;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public class WebhooksClientImpl
extends AbstractClient
implements WebhooksClient {
    private static final String WEBHOOKS_PATH = "webhooks";
    private static final Type WEBHOOKS_TYPE = new TypeToken<ItemsResponse<WebhookResponse>>(){}.getType();

    public WebhooksClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<ItemsResponse<WebhookResponse>> retrieveWebhooks() {
        return this.apiClient.getAsync(WEBHOOKS_PATH, this.sdkAuthorization(), WEBHOOKS_TYPE);
    }

    @Override
    public CompletableFuture<WebhookResponse> registerWebhook(WebhookRequest webhookRequest) {
        return this.registerWebhook(webhookRequest, null);
    }

    @Override
    public CompletableFuture<WebhookResponse> registerWebhook(WebhookRequest webhookRequest, String idempotencyKey) {
        CheckoutUtils.validateParams("webhookRequest", webhookRequest);
        return this.apiClient.postAsync(WEBHOOKS_PATH, this.sdkAuthorization(), WebhookResponse.class, (Object)webhookRequest, idempotencyKey);
    }

    @Override
    public CompletableFuture<WebhookResponse> retrieveWebhook(String webhookId) {
        CheckoutUtils.validateParams("webhookId", webhookId);
        return this.apiClient.getAsync(WebhooksClientImpl.buildPath(WEBHOOKS_PATH, webhookId), this.sdkAuthorization(), WebhookResponse.class);
    }

    @Override
    public CompletableFuture<WebhookResponse> updateWebhook(String webhookId, WebhookRequest webhookRequest) {
        CheckoutUtils.validateParams("webhookId", webhookId, "webhookRequest", webhookRequest);
        return this.apiClient.putAsync(WebhooksClientImpl.buildPath(WEBHOOKS_PATH, webhookId), this.sdkAuthorization(), WebhookResponse.class, webhookRequest);
    }

    @Override
    public CompletableFuture<EmptyResponse> removeWebhook(String webhookId) {
        CheckoutUtils.validateParams("webhookId", webhookId);
        return this.apiClient.deleteAsync(WebhooksClientImpl.buildPath(WEBHOOKS_PATH, webhookId), this.sdkAuthorization());
    }
}

