/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.sessions;

import com.checkout.CheckoutAuthorizationException;
import com.checkout.PlatformType;
import com.checkout.SdkAuthorization;
import com.checkout.SdkAuthorizationType;
import com.checkout.SdkCredentials;
import com.checkout.common.CheckoutUtils;

final class SessionSecretSdkCredentials
extends SdkCredentials {
    private final String secret;

    SessionSecretSdkCredentials(String secret) {
        super(PlatformType.CUSTOM);
        CheckoutUtils.validateParams("secret", secret);
        this.secret = secret;
    }

    @Override
    public SdkAuthorization getAuthorization(SdkAuthorizationType authorizationType) {
        if (SdkAuthorizationType.CUSTOM.equals((Object)authorizationType)) {
            return new SdkAuthorization(this.platformType, this.secret);
        }
        throw CheckoutAuthorizationException.invalidAuthorization(authorizationType);
    }

    String getSecret() {
        return this.secret;
    }
}

