package com.checkout.common;

import com.google.gson.annotations.SerializedName;
import lombok.Getter;

public enum CountryCode {

    @SerializedName(value = "AF", alternate = "AFG")
    AF("93"),
    @SerializedName(value = "AX", alternate = "ALA")
    AX("35818"),
    @SerializedName(value = "AL",alternate = "ALB")
    AL("355"),
    @SerializedName(value = "DZ", alternate = "DZA")
    DZ("213"),
    @SerializedName(value = "AS",alternate = "ASM")
    AS("1684"),
    @SerializedName(value = "AD", alternate = "AND")
    AD("376"),
    @SerializedName(value = "AO",alternate = "AGO")
    AO("244"),
    @SerializedName(value = "AI",alternate = "AIA")
    AI("1264"),
    @SerializedName(value = "AG",alternate = "ATG")
    AG("1268"),
    @SerializedName(value = "AR",alternate = "ARG")
    AR("54"),
    @SerializedName(value = "AM",alternate = "ARM")
    AM("374"),
    @SerializedName(value = "AW",alternate = "ABW")
    AW("297"),
    @SerializedName(value = "AC",alternate = "ASC")
    AC("247"),
    @SerializedName(value = "AU",alternate = "AUS")
    AU("61"),
    @SerializedName(value = "AQ",alternate = "ATA")
    AQ("672"),
    @SerializedName(value = "AT",alternate = "AUT")
    AT("43"),
    @SerializedName(value = "AZ",alternate = "AZE")
    AZ("994"),
    @SerializedName(value = "BS",alternate = "BHS")
    BS("1242"),
    @SerializedName(value = "BH",alternate = "BHR")
    BH("973"),
    @SerializedName(value = "BD",alternate = "BGD")
    BD("880"),
    @SerializedName(value = "BB",alternate = "BRB")
    BB("1246"),
    @SerializedName(value = "BY",alternate = "BLR")
    BY("375"),
    @SerializedName(value = "BE",alternate = "BEL")
    BE("32"),
    @SerializedName(value = "BZ",alternate = "BLZ")
    BZ("501"),
    @SerializedName(value = "BJ",alternate = "BEN")
    BJ("229"),
    @SerializedName(value = "BM",alternate = "BMU")
    BM("1441"),
    @SerializedName(value = "BT",alternate = "BTN")
    BT("975"),
    @SerializedName(value = "BO",alternate = "BOL")
    BO("591"),
    @SerializedName(value = "BQ",alternate = "BES")
    BQ("5997"),
    @SerializedName(value = "BA",alternate = "BIH")
    BA("387"),
    @SerializedName(value = "BW",alternate = "BWA")
    BW("267"),
    @SerializedName(value = "BV",alternate = "BVT")
    BV(""),
    @SerializedName(value = "BR",alternate = "BRA")
    BR("55"),
    @SerializedName(value = "IO",alternate = "IOT")
    IO("2"),
    @SerializedName(value = "VG",alternate = "VGB")
    VG("1284"),
    @SerializedName(value = "BN",alternate = "BRN")
    BN("673"),
    @SerializedName(value = "BG",alternate = "BGR")
    BG("359"),
    @SerializedName(value = "BF",alternate = "BFA")
    BF("226"),
    @SerializedName(value = "BI",alternate = "BDI")
    BI("257"),
    @SerializedName(value = "KH",alternate = "KHM")
    KH("855"),
    @SerializedName(value = "CM",alternate = "CMR")
    CM("237"),
    @SerializedName(value = "CA",alternate = "CAN")
    CA("1"),
    @SerializedName(value = "CV",alternate = "CPV")
    CV("238"),
    @SerializedName(value = "KY",alternate = "CYM")
    KY("1345"),
    @SerializedName(value = "CF",alternate = "CAF")
    CF("236"),
    @SerializedName(value = "TD",alternate = "TCD")
    TD("235"),
    @SerializedName(value = "CL",alternate = "CHL")
    CL("56"),
    @SerializedName(value = "CN",alternate = "CHN")
    CN("86"),
    @SerializedName(value = "TW",alternate = "TWN")
    TW("886"),
    @SerializedName(value = "CX",alternate = "CXR")
    CX("61"),
    @SerializedName(value = "PF",alternate = "PFY")
    PF("689"),
    @SerializedName(value = "CC",alternate = "CCK")
    CC("61"),
    @SerializedName(value = "CO",alternate = "COL")
    CO("57"),
    @SerializedName(value = "KM",alternate = "COM")
    KM("269"),
    @SerializedName(value = "CG",alternate = "COG")
    CG("242"),
    @SerializedName(value = "CD",alternate = "COD")
    CD("243"),
    @SerializedName(value = "CK",alternate = "COK")
    CK("682"),
    @SerializedName(value = "CR",alternate = "CRI")
    CR("506"),
    @SerializedName(value = "CI",alternate = "CIV")
    CI("225"),
    @SerializedName(value = "HR",alternate = "HRV")
    HR("385"),
    @SerializedName(value = "CU",alternate = "CUB")
    CU("53"),
    @SerializedName(value = "CW",alternate = "ANG")
    CW("5999"),
    @SerializedName(value = "CY",alternate = "CYP")
    CY("357"),
    @SerializedName(value = "CZ",alternate = "CZE")
    CZ("420"),
    @SerializedName(value = "DK",alternate = "DKN")
    DK("45"),
    @SerializedName(value = "DJ",alternate = "DJI")
    DJ("253"),
    @SerializedName(value = "DM",alternate = "DMA")
    DM("1767"),
    @SerializedName(value = "DO",alternate = "DOM")
    DO("1809"),
    @SerializedName(value = "EC",alternate = "ECU")
    EC("593"),
    @SerializedName(value = "EG",alternate = "EGY")
    EG("20"),
    @SerializedName(value = "SV",alternate = "SLV")
    SV("503"),
    @SerializedName(value = "GQ",alternate = "GNQ")
    GQ("240"),
    @SerializedName(value = "ER",alternate = "ERI")
    ER("291"),
    @SerializedName(value = "EE",alternate = "EST")
    EE("372"),
    @SerializedName(value = "SZ",alternate = "SWZ")
    SZ("268"),
    @SerializedName(value = "ET",alternate = "ETH")
    ET("251"),
    @SerializedName(value = "FK",alternate = "FLK")
    FK("500"),
    @SerializedName(value = "FO",alternate = "FRO")
    FO("298"),
    @SerializedName(value = "FJ",alternate = "FJI")
    FJ("679"),
    @SerializedName(value = "FI",alternate = "FIN")
    FI("358"),
    @SerializedName(value = "FR",alternate = "FRA")
    FR("33"),
    @SerializedName(value = "GF",alternate = "GUF")
    GF("594"),
    @SerializedName(value = "TF",alternate = "ATF")
    TF("590"),
    @SerializedName(value = "GA",alternate = "GAB")
    GA("241"),
    @SerializedName(value = "GM",alternate = "GMB")
    GM("220"),
    @SerializedName(value = "GE",alternate = "GEO")
    GE("995"),
    @SerializedName(value = "DE",alternate = "DEU")
    DE("49"),
    @SerializedName(value = "GH",alternate = "GHA")
    GH("223"),
    @SerializedName(value = "GI",alternate = "GIB")
    GI("350"),
    @SerializedName(value = "GR",alternate = "GRC")
    GR("30"),
    @SerializedName(value = "GL",alternate = "GRL")
    GL("299"),
    @SerializedName(value = "GD",alternate = "GRD")
    GD("1473"),
    @SerializedName(value = "GP",alternate = "GLP")
    GP("590"),
    @SerializedName(value = "GU",alternate = "GUM")
    GU("1671"),
    @SerializedName(value = "GT",alternate = "GTM")
    GT("502"),
    @SerializedName(value = "GG",alternate = "GGY")
    GG("441481"),
    @SerializedName(value = "GN",alternate = "GIN")
    GN("224"),
    @SerializedName(value = "GW",alternate = "GNB")
    GW("245"),
    @SerializedName(value = "GY",alternate = "GUY")
    GY("592"),
    @SerializedName(value = "HT",alternate = "HTI")
    HT("509"),
    @SerializedName(value = "HM",alternate = "HMD")
    HM(""),
    @SerializedName(value = "HN",alternate = "HND")
    HN("504"),
    @SerializedName(value = "HK",alternate = "HKG")
    HK("852"),
    @SerializedName(value = "HU",alternate = "HUN")
    HU("36"),
    @SerializedName(value = "IS",alternate = "ISL")
    IS("354"),
    @SerializedName(value = "IN",alternate = "IND")
    IN("91"),
    @SerializedName(value = "ID",alternate = "IDN")
    ID("62"),
    @SerializedName(value = "IR",alternate = "IRN")
    IR("98"),
    @SerializedName(value = "IQ",alternate = "IRQ")
    IQ("964"),
    @SerializedName(value = "IE",alternate = "IRL")
    IE("353"),
    @SerializedName(value = "IM",alternate = "IMN")
    IM("44"),
    @SerializedName(value = "IL",alternate = "ISR")
    IL("972"),
    @SerializedName(value = "IT",alternate = "ITA")
    IT("39"),
    @SerializedName(value = "JM",alternate = "JAM")
    JM("1876"),
    @SerializedName(value = "JP",alternate = "JPN")
    JP("81"),
    @SerializedName(value = "JE",alternate = "JEY")
    JE("44"),
    @SerializedName(value = "JO",alternate = "JOR")
    JO("962"),
    @SerializedName(value = "KZ",alternate = "KAZ")
    KZ("7"),
    @SerializedName(value = "KE",alternate = "KEN")
    KE("254"),
    @SerializedName(value = "KI",alternate = "KIR")
    KI("686"),
    @SerializedName(value = "KP",alternate = "PRK")
    KP("850"),
    @SerializedName(value = "KR",alternate = "KOR")
    KR("82"),
    @SerializedName(value = "KW",alternate = "KWT")
    KW("965"),
    @SerializedName(value = "KG",alternate = "KGZ")
    KG("996"),
    @SerializedName(value = "LA",alternate = "LAO")
    LA("856"),
    @SerializedName(value = "LV",alternate = "LVA")
    LV("371"),
    @SerializedName(value = "LB",alternate = "LBN")
    LB("961"),
    @SerializedName(value = "LS",alternate = "LSO")
    LS("266"),
    @SerializedName(value = "LR",alternate = "LBR")
    LR("231"),
    @SerializedName(value = "LY",alternate = "LBY")
    LY("218"),
    @SerializedName(value = "LI",alternate = "LIE")
    LI("423"),
    @SerializedName(value = "LT",alternate = "LTU")
    LT("370"),
    @SerializedName(value = "LU",alternate = "LUX")
    LU("352"),
    @SerializedName(value = "MO",alternate = "MAX")
    MO("853"),
    @SerializedName(value = "MK",alternate = "MKD")
    MK("389"),
    @SerializedName(value = "MG",alternate = "MDG")
    MG("261"),
    @SerializedName(value = "MW",alternate = "MWI")
    MW("265"),
    @SerializedName(value = "MY",alternate = "MYS")
    MY("60"),
    @SerializedName(value = "MV",alternate = "MDV")
    MV("960"),
    @SerializedName(value = "ML",alternate = "MLI")
    ML("223"),
    @SerializedName(value = "MT",alternate = "MLT")
    MT("356"),
    @SerializedName(value = "MH",alternate = "MHL")
    MH("692"),
    @SerializedName(value = "MQ",alternate = "MTQ")
    MQ("596"),
    @SerializedName(value = "MR",alternate = "MRT")
    MR("222"),
    @SerializedName(value = "MU",alternate = "MUS")
    MU("230"),
    @SerializedName(value = "YT",alternate = "MYT")
    YT("262"),
    @SerializedName(value = "MX",alternate = "MEX")
    MX("52"),
    @SerializedName(value = "FM",alternate = "FSM")
    FM("691"),
    @SerializedName(value = "MD",alternate = "MDA")
    MD("372"),
    @SerializedName(value = "MC",alternate = "MCO")
    MC("377"),
    @SerializedName(value = "MN",alternate = "MNG")
    MN("976"),
    @SerializedName(value = "ME",alternate = "MNE")
    ME("382"),
    @SerializedName(value = "MS",alternate = "MSR")
    MS("1664"),
    @SerializedName(value = "MA",alternate = "MAR")
    MA("212"),
    @SerializedName(value = "MZ",alternate = "MOZ")
    MZ("258"),
    @SerializedName(value = "MM",alternate = "MMR")
    MM("95"),
    @SerializedName(value = "NA",alternate = "NAM")
    NA("264"),
    @SerializedName(value = "NR",alternate = "NRU")
    NR("674"),
    @SerializedName(value = "NP",alternate = "NPL")
    NP("977"),
    @SerializedName(value = "NL",alternate = "NLD")
    NL("31"),
    @SerializedName(value = "AN",alternate = "ANT")
    AN("599"),
    @SerializedName(value = "NC",alternate = "NCL")
    NC("687"),
    @SerializedName(value = "NZ",alternate = "NZL")
    NZ("64"),
    @SerializedName(value = "NI",alternate = "NIC")
    NI("505"),
    @SerializedName(value = "NE",alternate = "NER")
    NE("227"),
    @SerializedName(value = "NG",alternate = "NGA")
    NG("234"),
    @SerializedName(value = "NU",alternate = "NIU")
    NU("683"),
    @SerializedName(value = "NF",alternate = "MFK")
    NF("672"),
    @SerializedName(value = "MP",alternate = "MPN")
    MP("1670"),
    @SerializedName(value = "NO",alternate = "NOR")
    NO("47"),
    @SerializedName(value = "OM",alternate = "OMN")
    OM("968"),
    @SerializedName(value = "PK",alternate = "PAK")
    PK("92"),
    @SerializedName(value = "PW",alternate = "PLW")
    PW("680"),
    @SerializedName(value = "PA",alternate = "PAN")
    PA("507"),
    @SerializedName(value = "PG",alternate = "PNG")
    PG("675"),
    @SerializedName(value = "PY",alternate = "PRY")
    PY("595"),
    @SerializedName(value = "PE",alternate = "PER")
    PE("51"),
    @SerializedName(value = "PH",alternate = "PHL")
    PH("63"),
    @SerializedName(value = "PN",alternate = "PCN")
    PN("870"),
    @SerializedName(value = "PL",alternate = "POL")
    PL("48"),
    @SerializedName(value = "PT",alternate = "PRT")
    PT("351"),
    @SerializedName(value = "PR",alternate = "PRI")
    PR("1787"),
    @SerializedName(value = "QA",alternate = "QAT")
    QA("974"),
    @SerializedName(value = "RE",alternate = "REU")
    RE("262"),
    @SerializedName(value = "RO",alternate = "ROU")
    RO("40"),
    @SerializedName(value = "RU",alternate = "RUS")
    RU("7"),
    @SerializedName(value = "RW",alternate = "RWA")
    RW("250"),
    @SerializedName(value = "BL",alternate = "BLM")
    BL("590"),
    @SerializedName(value = "SH",alternate = "SHN")
    SH("290"),
    @SerializedName(value = "KN",alternate = "KNA")
    KN("1869"),
    @SerializedName(value = "LC",alternate = "LCA")
    LC("1758"),
    @SerializedName(value = "MF",alternate = "MAF")
    MF("1599"),
    @SerializedName(value = "PM",alternate = "SPM")
    PM("508"),
    @SerializedName(value = "VC",alternate = "VCT")
    VC("1784"),
    @SerializedName(value = "WS",alternate = "WSM")
    WS("685"),
    @SerializedName(value = "SM",alternate = "SMR")
    SM("378"),
    @SerializedName(value = "ST",alternate = "STP")
    ST("239"),
    @SerializedName(value = "SA",alternate = "SAU")
    SA("966"),
    @SerializedName(value = "SN",alternate = "SEN")
    SN("221"),
    @SerializedName(value = "RS",alternate = "SRB")
    RS("381"),
    @SerializedName(value = "SC",alternate = "SYC")
    SC("248"),
    @SerializedName(value = "SL",alternate = "SLE")
    SL("232"),
    @SerializedName(value = "SG",alternate = "SGP")
    SG("65"),
    @SerializedName(value = "SX",alternate = "SXM")
    SX("1721"),
    @SerializedName(value = "SK",alternate = "SVK")
    SK("421"),
    @SerializedName(value = "SI",alternate = "SVN")
    SI("386"),
    @SerializedName(value = "SB",alternate = "SLB")
    SB("677"),
    @SerializedName(value = "SO",alternate = "SOM")
    SO("252"),
    @SerializedName(value = "ZA",alternate = "ZAF")
    ZA("27"),
    @SerializedName(value = "GS",alternate = "SGS")
    GS("500"),
    @SerializedName(value = "SS",alternate = "SSD")
    SS("211"),
    @SerializedName(value = "ES",alternate = "ESP")
    ES("34"),
    @SerializedName(value = "LK",alternate = "LKA")
    LK("94"),
    @SerializedName(value = "SD",alternate = "SDN")
    SD("249"),
    @SerializedName(value = "SR",alternate = "SUR")
    SR("597"),
    @SerializedName(value = "SJ",alternate = "SJM")
    SJ("4779"),
    @SerializedName(value = "SE",alternate = "SWE")
    SE("46"),
    @SerializedName(value = "CH",alternate = "CHE")
    CH("41"),
    @SerializedName(value = "SY",alternate = "SYR")
    SY("963"),
    @SerializedName(value = "TJ",alternate = "TJK")
    TJ("992"),
    @SerializedName(value = "TZ",alternate = "TZA")
    TZ("255"),
    @SerializedName(value = "TH",alternate = "THA")
    TH("66"),
    @SerializedName(value = "TL",alternate = "TLS")
    TL("670"),
    @SerializedName(value = "TG",alternate = "TGO")
    TG("228"),
    @SerializedName(value = "TK",alternate = "TKL")
    TK("690"),
    @SerializedName(value = "TO",alternate = "TON")
    TO("676"),
    @SerializedName(value = "TT",alternate = "TTO")
    TT("1868"),
    @SerializedName(value = "TA",alternate = "TAA")
    TA("2908"),
    @SerializedName(value = "TN",alternate = "TUN")
    TN("216"),
    @SerializedName(value = "TR",alternate = "TUR")
    TR("90"),
    @SerializedName(value = "TM",alternate = "TKM")
    TM("993"),
    @SerializedName(value = "TC",alternate = "TCA")
    TC("1649"),
    @SerializedName(value = "TV",alternate = "TUV")
    TV("688"),
    @SerializedName(value = "VI",alternate = "VIR")
    VI("1340"),
    @SerializedName(value = "UG",alternate = "UGA")
    UG("256"),
    @SerializedName(value = "UA",alternate = "UKR")
    UA("380"),
    @SerializedName(value = "AE",alternate = "ARE")
    AE("971"),
    @SerializedName(value = "GB",alternate = {"GBR", "UK"})
    GB("44"),
    @SerializedName(value = "US",alternate = "USA")
    US("1"),
    @SerializedName(value = "UY",alternate = "URY")
    UY("598"),
    @SerializedName(value = "UZ",alternate = "UZB")
    UZ("998"),
    @SerializedName(value = "VU",alternate = "VUT")
    VU("678"),
    @SerializedName(value = "VA",alternate = "VAT")
    VA("39"),
    @SerializedName(value = "VE",alternate = "VEN")
    VE("58"),
    @SerializedName(value = "VN",alternate = "VNM")
    VN("84"),
    @SerializedName(value = "UM",alternate = "UMI")
    UM("1808"),
    @SerializedName(value = "WF",alternate = "WLF")
    WF("681"),
    @SerializedName(value = "EH",alternate = "ESH")
    EH("2125288"),
    @SerializedName(value = "YE",alternate = "YEM")
    YE("967"),
    @SerializedName(value = "ZM",alternate = "ZMB")
    ZM("260"),
    @SerializedName(value = "ZW",alternate = "ZWE")
    ZW("263"),
    @SerializedName(value = "PS",alternate = "PSE")
    PS("970"),
    @SerializedName(value = "QZ")
    QZ(""),
    @SerializedName(value = "XK")
    XK("");

    @Getter
    private final String dialCode;

    CountryCode(final String dialCode) {
        this.dialCode = dialCode;
    }

}
