/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.AbstractStaticKeysSdkCredentials;
import com.checkout.CheckoutAuthorizationException;
import com.checkout.PlatformType;
import com.checkout.SdkAuthorization;
import com.checkout.SdkAuthorizationType;

public final class StaticKeysSdkCredentials
extends AbstractStaticKeysSdkCredentials {
    private static final String SECRET_KEY_PATTERN = "^sk_(sbox_)?[a-z2-7]{26}[a-z2-7*#$=]$";
    private static final String PUBLIC_KEY_PATTEN = "^pk_(sbox_)?[a-z2-7]{26}[a-z2-7*#$=]$";

    StaticKeysSdkCredentials(String secretKey, String publicKey) {
        super(PlatformType.DEFAULT, SECRET_KEY_PATTERN, PUBLIC_KEY_PATTEN, secretKey, publicKey);
    }

    @Override
    public SdkAuthorization getAuthorization(SdkAuthorizationType authorizationType) {
        switch (authorizationType) {
            case SECRET_KEY: 
            case SECRET_KEY_OR_OAUTH: {
                return new SdkAuthorization(this.platformType, this.secretKey);
            }
            case PUBLIC_KEY: 
            case PUBLIC_KEY_OR_OAUTH: {
                return new SdkAuthorization(this.platformType, this.publicKey);
            }
        }
        throw CheckoutAuthorizationException.invalidAuthorization(authorizationType);
    }
}

