/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.forex;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.forex.ForexClient;
import com.checkout.forex.QuoteRequest;
import com.checkout.forex.QuoteResponse;
import com.checkout.forex.RatesQueryFilter;
import com.checkout.forex.RatesQueryResponse;
import java.util.concurrent.CompletableFuture;

public class ForexClientImpl
extends AbstractClient
implements ForexClient {
    public ForexClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.OAUTH);
    }

    @Override
    public CompletableFuture<QuoteResponse> requestQuote(QuoteRequest quoteRequest) {
        CheckoutUtils.validateParams("quoteRequest", quoteRequest);
        return this.apiClient.postAsync("forex/quotes", this.sdkAuthorization(), QuoteResponse.class, (Object)quoteRequest, null);
    }

    @Override
    public CompletableFuture<RatesQueryResponse> getRates(RatesQueryFilter ratesQuery) {
        CheckoutUtils.validateParams("ratesQuery", ratesQuery);
        return this.apiClient.queryAsync("forex/rates", this.sdkAuthorization(), ratesQuery, RatesQueryResponse.class);
    }
}

