/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.payments.request.source;

import com.checkout.common.AccountHolder;
import com.checkout.common.AccountType;
import com.checkout.common.CountryCode;
import com.checkout.common.PaymentSourceType;
import com.checkout.payments.request.source.AbstractRequestSource;
import com.google.gson.annotations.SerializedName;
import lombok.Generated;

public final class RequestBankAccountSource
extends AbstractRequestSource {
    @SerializedName(value="payment_method")
    private String paymentMethod;
    @SerializedName(value="account_type")
    private AccountType accountType;
    private CountryCode country;
    @SerializedName(value="account_number")
    private String accountNumber;
    @SerializedName(value="bank_code")
    private String bankCode;
    @SerializedName(value="account_holder")
    private AccountHolder accountHolder;

    public RequestBankAccountSource() {
        super(PaymentSourceType.BANK_ACCOUNT);
    }

    private RequestBankAccountSource(String paymentMethod, AccountType accountType, CountryCode country, String accountNumber, String bankCode, AccountHolder accountHolder) {
        super(PaymentSourceType.BANK_ACCOUNT);
        this.paymentMethod = paymentMethod;
        this.accountType = accountType;
        this.country = country;
        this.accountNumber = accountNumber;
        this.bankCode = bankCode;
        this.accountHolder = accountHolder;
    }

    @Generated
    public static RequestBankAccountSourceBuilder builder() {
        return new RequestBankAccountSourceBuilder();
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Generated
    public CountryCode getCountry() {
        return this.country;
    }

    @Generated
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @Generated
    public String getBankCode() {
        return this.bankCode;
    }

    @Generated
    public AccountHolder getAccountHolder() {
        return this.accountHolder;
    }

    @Generated
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Generated
    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    @Generated
    public void setCountry(CountryCode country) {
        this.country = country;
    }

    @Generated
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @Generated
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    @Generated
    public void setAccountHolder(AccountHolder accountHolder) {
        this.accountHolder = accountHolder;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestBankAccountSource)) {
            return false;
        }
        RequestBankAccountSource other = (RequestBankAccountSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        AccountType this$accountType = this.getAccountType();
        AccountType other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)((Object)this$accountType)).equals((Object)other$accountType)) {
            return false;
        }
        CountryCode this$country = this.getCountry();
        CountryCode other$country = other.getCountry();
        if (this$country == null ? other$country != null : !((Object)((Object)this$country)).equals((Object)other$country)) {
            return false;
        }
        String this$accountNumber = this.getAccountNumber();
        String other$accountNumber = other.getAccountNumber();
        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
            return false;
        }
        String this$bankCode = this.getBankCode();
        String other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
            return false;
        }
        AccountHolder this$accountHolder = this.getAccountHolder();
        AccountHolder other$accountHolder = other.getAccountHolder();
        return !(this$accountHolder == null ? other$accountHolder != null : !((Object)this$accountHolder).equals(other$accountHolder));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestBankAccountSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        AccountType $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : ((Object)((Object)$accountType)).hashCode());
        CountryCode $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : ((Object)((Object)$country)).hashCode());
        String $accountNumber = this.getAccountNumber();
        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
        String $bankCode = this.getBankCode();
        result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
        AccountHolder $accountHolder = this.getAccountHolder();
        result = result * 59 + ($accountHolder == null ? 43 : ((Object)$accountHolder).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RequestBankAccountSource(super=" + super.toString() + ", paymentMethod=" + this.getPaymentMethod() + ", accountType=" + (Object)((Object)this.getAccountType()) + ", country=" + (Object)((Object)this.getCountry()) + ", accountNumber=" + this.getAccountNumber() + ", bankCode=" + this.getBankCode() + ", accountHolder=" + this.getAccountHolder() + ")";
    }

    @Generated
    public static class RequestBankAccountSourceBuilder {
        @Generated
        private String paymentMethod;
        @Generated
        private AccountType accountType;
        @Generated
        private CountryCode country;
        @Generated
        private String accountNumber;
        @Generated
        private String bankCode;
        @Generated
        private AccountHolder accountHolder;

        @Generated
        RequestBankAccountSourceBuilder() {
        }

        @Generated
        public RequestBankAccountSourceBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @Generated
        public RequestBankAccountSourceBuilder accountType(AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        @Generated
        public RequestBankAccountSourceBuilder country(CountryCode country) {
            this.country = country;
            return this;
        }

        @Generated
        public RequestBankAccountSourceBuilder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @Generated
        public RequestBankAccountSourceBuilder bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        @Generated
        public RequestBankAccountSourceBuilder accountHolder(AccountHolder accountHolder) {
            this.accountHolder = accountHolder;
            return this;
        }

        @Generated
        public RequestBankAccountSource build() {
            return new RequestBankAccountSource(this.paymentMethod, this.accountType, this.country, this.accountNumber, this.bankCode, this.accountHolder);
        }

        @Generated
        public String toString() {
            return "RequestBankAccountSource.RequestBankAccountSourceBuilder(paymentMethod=" + this.paymentMethod + ", accountType=" + (Object)((Object)this.accountType) + ", country=" + (Object)((Object)this.country) + ", accountNumber=" + this.accountNumber + ", bankCode=" + this.bankCode + ", accountHolder=" + this.accountHolder + ")";
        }
    }
}

