/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.CheckoutApiClient;
import com.checkout.CheckoutArgumentException;
import com.checkout.CheckoutConfiguration;
import com.checkout.DefaultCheckoutConfiguration;
import com.checkout.DefaultTransportConfiguration;
import com.checkout.EnvironmentSubdomain;
import com.checkout.IEnvironment;
import com.checkout.SdkCredentials;
import com.checkout.TransportConfiguration;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class AbstractCheckoutSdkBuilder<T extends CheckoutApiClient> {
    protected HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
    private IEnvironment environment;
    private EnvironmentSubdomain environmentSubdomain;
    private Executor executor = ForkJoinPool.commonPool();
    private TransportConfiguration transportConfiguration;
    private Boolean recordTelemetry = true;

    public AbstractCheckoutSdkBuilder<T> environment(IEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public AbstractCheckoutSdkBuilder<T> environmentSubdomain(String subdomain) {
        if (subdomain == null) {
            throw new CheckoutArgumentException("subdomain must be specified");
        }
        this.environmentSubdomain = new EnvironmentSubdomain(this.environment, subdomain);
        return this;
    }

    public AbstractCheckoutSdkBuilder<T> httpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        return this;
    }

    public AbstractCheckoutSdkBuilder<T> executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public AbstractCheckoutSdkBuilder<T> transportConfiguration(TransportConfiguration transportConfiguration) {
        this.transportConfiguration = transportConfiguration;
        return this;
    }

    protected IEnvironment getEnvironment() {
        return this.environment;
    }

    protected EnvironmentSubdomain getEnvironmentSubdomain() {
        return this.environmentSubdomain;
    }

    public AbstractCheckoutSdkBuilder<T> recordTelemetry(Boolean recordTelemetry) {
        this.recordTelemetry = recordTelemetry;
        return this;
    }

    protected abstract SdkCredentials getSdkCredentials();

    protected CheckoutConfiguration getCheckoutConfiguration() {
        if (this.environment == null) {
            throw new CheckoutArgumentException("environment must be specified");
        }
        SdkCredentials sdkCredentials = this.getSdkCredentials();
        if (this.transportConfiguration == null) {
            this.transportConfiguration = new DefaultTransportConfiguration();
        }
        return this.buildCheckoutConfiguration(sdkCredentials);
    }

    private CheckoutConfiguration buildCheckoutConfiguration(SdkCredentials sdkCredentials) {
        return new DefaultCheckoutConfiguration(sdkCredentials, this.getEnvironment(), this.getEnvironmentSubdomain(), this.httpClientBuilder, this.executor, this.transportConfiguration, this.recordTelemetry);
    }

    public abstract T build();
}

