/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.ApacheHttpClientTransport;
import com.checkout.ApiClient;
import com.checkout.CheckoutApiException;
import com.checkout.CheckoutConfiguration;
import com.checkout.CheckoutException;
import com.checkout.ClientOperation;
import com.checkout.ContentResponse;
import com.checkout.EmptyResponse;
import com.checkout.GsonSerializer;
import com.checkout.HttpMetadata;
import com.checkout.Response;
import com.checkout.SdkAuthorization;
import com.checkout.Serializer;
import com.checkout.Transport;
import com.checkout.UriStrategy;
import com.checkout.common.AbstractFileRequest;
import com.checkout.common.CheckoutUtils;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class ApiClientImpl
implements ApiClient {
    private static final String AUTHORIZATION = "authorization";
    private static final String PATH = "path";
    private final Serializer serializer = new GsonSerializer();
    private final Transport transport;

    public ApiClientImpl(CheckoutConfiguration configuration, UriStrategy uriStrategy) {
        this.transport = new ApacheHttpClientTransport(uriStrategy.getUri(), configuration.getHttpClientBuilder(), configuration.getExecutor(), configuration.getTransportConfiguration(), configuration);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> getAsync(String path, SdkAuthorization authorization, Class<T> responseType) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.GET, path, authorization, null, null, responseType);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> getAsync(String path, SdkAuthorization authorization, Type responseType) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.GET, path, authorization, null, null, responseType);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> putAsync(String path, SdkAuthorization authorization, Class<T> responseType, Object request) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.PUT, path, authorization, request, null, responseType);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> patchAsync(String path, SdkAuthorization authorization, Class<T> responseType, Object request, String idempotencyKey) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.PATCH, path, authorization, request, idempotencyKey, responseType);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> patchAsync(String path, SdkAuthorization authorization, Type type, Object request, String idempotencyKey) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization, "type", type, "request", request);
        return this.sendRequestAsync(ClientOperation.PATCH, path, authorization, request, idempotencyKey, type);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> postAsync(String path, SdkAuthorization authorization, Class<T> responseType, Object request, String idempotencyKey) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.POST, path, authorization, request, idempotencyKey, responseType);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> postAsync(String path, SdkAuthorization authorization, Type responseType, Object request, String idempotencyKey) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.POST, path, authorization, request, idempotencyKey, responseType);
    }

    @Override
    public CompletableFuture<EmptyResponse> deleteAsync(String path, SdkAuthorization authorization) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.DELETE, path, authorization, null, null, (Type)((Object)EmptyResponse.class));
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> deleteAsync(String path, SdkAuthorization authorization, Class<T> responseType) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        return this.sendRequestAsync(ClientOperation.DELETE, path, authorization, null, null, responseType);
    }

    @Override
    public CompletableFuture<? extends HttpMetadata> postAsync(String path, SdkAuthorization authorization, Map<Integer, Class<? extends HttpMetadata>> resultTypeMappings, Object request, String idempotencyKey) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization, "resultTypeMappings", resultTypeMappings);
        return ((CompletableFuture)this.transport.invoke(ClientOperation.POST, path, authorization, this.serializer.toJson(request), idempotencyKey, null).thenApply(this::errorCheck)).thenApply(response -> {
            Class responseType = (Class)resultTypeMappings.get(response.getStatusCode());
            if (responseType == null) {
                throw new IllegalStateException("The status code " + response.getStatusCode() + " is not mapped to a result type");
            }
            return this.deserialize((Response)response, responseType);
        });
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> queryAsync(String path, SdkAuthorization authorization, Object filter, Class<T> responseType) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization, "filter", filter);
        Map params = (Map)this.serializer.fromJson(this.serializer.toJson(filter), new TypeToken<Map<String, String>>(){}.getType());
        return ((CompletableFuture)this.transport.invoke(ClientOperation.QUERY, path, authorization, null, null, params).thenApply(this::errorCheck)).thenApply(response -> this.deserialize((Response)response, responseType));
    }

    @Override
    public CompletableFuture<ContentResponse> queryCsvContentAsync(String path, SdkAuthorization authorization, Object filter, String targetFile) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization);
        Map<String, String> params = new HashMap<String, String>();
        if (filter != null) {
            params = (Map)this.serializer.fromJson(this.serializer.toJson(filter), new TypeToken<Map<String, String>>(){}.getType());
        }
        return ((CompletableFuture)this.transport.invoke(ClientOperation.QUERY, path, authorization, null, null, params).thenApply(this::errorCheck)).thenApply(body -> this.transform((HttpMetadata)this.processAndGetContent(targetFile, (Response)body), (Response)body));
    }

    private ContentResponse processAndGetContent(String targetFile, Response response) {
        String content = response.getBody();
        if (StringUtils.isBlank((CharSequence)targetFile) || StringUtils.isBlank((CharSequence)content)) {
            return new ContentResponse(content);
        }
        File file = new File(targetFile);
        if (!file.exists()) {
            try {
                boolean bl = file.createNewFile();
            }
            catch (IOException e) {
                throw new CheckoutException(String.format("Failed creating file %s", targetFile));
            }
        }
        try {
            Files.copy(new ByteArrayInputStream(content.getBytes()), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new CheckoutException(String.format("Failed writing file %s", targetFile), e);
        }
        return new ContentResponse(content);
    }

    @Override
    public <T extends HttpMetadata> CompletableFuture<T> submitFileAsync(String path, SdkAuthorization authorization, AbstractFileRequest request, Class<T> responseType) {
        CheckoutUtils.validateParams(PATH, path, AUTHORIZATION, authorization, "fileRequest", request);
        return ((CompletableFuture)this.transport.submitFile(path, authorization, request).thenApply(this::errorCheck)).thenApply(response -> this.deserialize((Response)response, responseType));
    }

    private <T extends HttpMetadata> CompletableFuture<T> sendRequestAsync(ClientOperation clientOperation, String path, SdkAuthorization authorization, Object request, String idempotencyKey, Type responseType) {
        return ((CompletableFuture)this.transport.invoke(clientOperation, path, authorization, request == null ? null : this.serializer.toJson(request), idempotencyKey, null).thenApply(this::errorCheck)).thenApply(response -> this.deserialize((Response)response, responseType));
    }

    private Response errorCheck(Response response) {
        if (!CheckoutUtils.isSuccessHttpStatusCode(response.getStatusCode())) {
            Map<String, Object> errorDetails = this.serializer.fromJson(response.getBody());
            throw new CheckoutApiException(response.getStatusCode(), response.getHeaders(), errorDetails);
        }
        return response;
    }

    private <T extends HttpMetadata> T deserialize(Response response, Class<T> responseType) {
        HttpMetadata result = (HttpMetadata)this.serializer.fromJson(response.getBody(), responseType);
        if (result == null) {
            result = this.getInstanceFromT(responseType);
        }
        return (T)this.transform(result, response);
    }

    private <T extends HttpMetadata> T deserialize(Response response, Type responseType) {
        HttpMetadata result = (HttpMetadata)this.serializer.fromJson(response.getBody(), responseType);
        if (result == null) {
            result = this.getInstanceFromT(responseType);
        }
        return (T)this.transform(result, response);
    }

    private <T extends HttpMetadata> T getInstanceFromT(Type responseType) {
        try {
            Class<?> aClass;
            if (responseType instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)responseType;
                aClass = Class.forName(type.getRawType().getTypeName());
            } else {
                aClass = Class.forName(responseType.getTypeName());
            }
            return (T)((HttpMetadata)aClass.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new CheckoutException(e);
        }
    }

    private <T extends HttpMetadata> T transform(T result, Response response) {
        result.setBody(response.getBody());
        result.setHttpStatusCode(response.getStatusCode());
        result.setResponseHeaders(response.getHeaders());
        return result;
    }
}

