/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuthAccessToken {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthAccessToken.class);
    private final String token;
    private final String tokenType;
    private final LocalDateTime expirationDate;

    OAuthAccessToken(String token, String tokenType, LocalDateTime expirationDate) {
        this.token = token;
        this.tokenType = tokenType;
        this.expirationDate = expirationDate;
    }

    boolean isValid() {
        if (this.expirationDate == null) {
            log.warn("Token expiration date is null");
            return false;
        }
        boolean isValid = this.expirationDate.isAfter(LocalDateTime.now());
        if (!isValid) {
            log.debug("Token has expired at {}", (Object)this.expirationDate);
        } else if (this.expirationDate.isBefore(LocalDateTime.now().plusMinutes(5L))) {
            log.debug("Token is about to expire at {}", (Object)this.expirationDate);
        }
        return isValid;
    }

    String getToken() {
        return this.token;
    }

    String getTokenType() {
        return this.tokenType;
    }

    LocalDateTime getExpirationDate() {
        return this.expirationDate;
    }
}

