/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.payments.links;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.payments.links.PaymentLinkDetailsResponse;
import com.checkout.payments.links.PaymentLinkRequest;
import com.checkout.payments.links.PaymentLinkResponse;
import com.checkout.payments.links.PaymentLinksClient;
import java.util.concurrent.CompletableFuture;

public class PaymentLinksClientImpl
extends AbstractClient
implements PaymentLinksClient {
    private static final String PAYMENT_LINKS_PATH = "payment-links";

    public PaymentLinksClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<PaymentLinkDetailsResponse> getPaymentLink(String reference) {
        CheckoutUtils.validateParams("reference", reference);
        return this.apiClient.getAsync(PaymentLinksClientImpl.buildPath(PAYMENT_LINKS_PATH, reference), this.sdkAuthorization(), PaymentLinkDetailsResponse.class);
    }

    @Override
    public CompletableFuture<PaymentLinkResponse> createPaymentLink(PaymentLinkRequest paymentLinkRequest) {
        CheckoutUtils.validateParams("paymentLinkRequest", paymentLinkRequest);
        return this.apiClient.postAsync(PAYMENT_LINKS_PATH, this.sdkAuthorization(), PaymentLinkResponse.class, (Object)paymentLinkRequest, null);
    }
}

