/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.CheckoutException;
import com.checkout.common.CheckoutUtils;
import java.util.Map;
import lombok.Generated;

public final class CheckoutApiException
extends CheckoutException {
    private final Integer httpStatusCode;
    private final Map<String, String> responseHeaders;
    private final Map<String, Object> errorDetails;

    public CheckoutApiException(Integer httpStatusCode, Map<String, String> responseHeaders, Map<String, Object> errorDetails) {
        super("The API response status code (" + httpStatusCode + ") does not indicate success.");
        this.responseHeaders = responseHeaders;
        this.httpStatusCode = httpStatusCode;
        this.errorDetails = errorDetails;
    }

    public String getRequestId() {
        return CheckoutUtils.getRequestId(this.responseHeaders);
    }

    @Generated
    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Generated
    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Generated
    public Map<String, Object> getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    @Generated
    public String toString() {
        return "CheckoutApiException(httpStatusCode=" + this.getHttpStatusCode() + ", responseHeaders=" + this.getResponseHeaders() + ", errorDetails=" + this.getErrorDetails() + ")";
    }
}

