/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.customers.previous;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.IdResponse;
import com.checkout.customers.previous.CustomerDetailsResponse;
import com.checkout.customers.previous.CustomerRequest;
import com.checkout.customers.previous.CustomersClient;
import java.util.concurrent.CompletableFuture;

public class CustomersClientImpl
extends AbstractClient
implements CustomersClient {
    private static final String CUSTOMERS_PATH = "customers";

    public CustomersClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<CustomerDetailsResponse> get(String customerId) {
        CheckoutUtils.validateParams("customerId", customerId);
        return this.apiClient.getAsync(CustomersClientImpl.buildPath(CUSTOMERS_PATH, customerId), this.sdkAuthorization(), CustomerDetailsResponse.class);
    }

    @Override
    public CompletableFuture<IdResponse> create(CustomerRequest customerRequest) {
        CheckoutUtils.validateParams("customerRequest", customerRequest);
        return this.apiClient.postAsync(CUSTOMERS_PATH, this.sdkAuthorization(), IdResponse.class, (Object)customerRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> update(String customerId, CustomerRequest customerRequest) {
        CheckoutUtils.validateParams("customerId", customerId, "customerRequest", customerRequest);
        return this.apiClient.patchAsync(CustomersClientImpl.buildPath(CUSTOMERS_PATH, customerId), this.sdkAuthorization(), EmptyResponse.class, (Object)customerRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> delete(String customerId) {
        CheckoutUtils.validateParams("customerId", customerId);
        return this.apiClient.deleteAsync(CustomersClientImpl.buildPath(CUSTOMERS_PATH, customerId), this.sdkAuthorization());
    }
}

