/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.reconciliation.previous;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.ContentResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.QueryFilterDateRange;
import com.checkout.reconciliation.previous.ReconciliationClient;
import com.checkout.reconciliation.previous.ReconciliationPaymentReportResponse;
import com.checkout.reconciliation.previous.ReconciliationQueryPaymentsFilter;
import com.checkout.reconciliation.previous.StatementReportResponse;
import com.checkout.reconciliation.previous.StatementsQueryFilter;
import java.util.concurrent.CompletableFuture;

public class ReconciliationClientImpl
extends AbstractClient
implements ReconciliationClient {
    private static final String REPORTING_PATH = "reporting";
    private static final String PAYMENTS_PATH = "payments";
    private static final String STATEMENTS_PATH = "statements";
    private static final String DOWNLOAD_PATH = "download";

    public ReconciliationClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<ReconciliationPaymentReportResponse> queryPaymentsReport(ReconciliationQueryPaymentsFilter filter) {
        CheckoutUtils.validateParams("filter", filter);
        return this.apiClient.queryAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, PAYMENTS_PATH), this.sdkAuthorization(), filter, ReconciliationPaymentReportResponse.class);
    }

    @Override
    public CompletableFuture<ReconciliationPaymentReportResponse> singlePaymentReportAsync(String paymentId) {
        CheckoutUtils.validateParams("paymentId", paymentId);
        return this.apiClient.getAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, PAYMENTS_PATH, paymentId), this.sdkAuthorization(), ReconciliationPaymentReportResponse.class);
    }

    @Override
    public CompletableFuture<StatementReportResponse> queryStatementsReport(StatementsQueryFilter filter) {
        CheckoutUtils.validateParams("filter", filter);
        return this.apiClient.queryAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, STATEMENTS_PATH), this.sdkAuthorization(), filter, StatementReportResponse.class);
    }

    @Override
    public CompletableFuture<ReconciliationPaymentReportResponse> getStatementsReportById(String statementId) {
        CheckoutUtils.validateParams("statementId", statementId);
        return this.apiClient.getAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, STATEMENTS_PATH, statementId, PAYMENTS_PATH), this.sdkAuthorization(), ReconciliationPaymentReportResponse.class);
    }

    @Override
    public CompletableFuture<ReconciliationPaymentReportResponse> getStatementsReportByIdQuery(String statementId, StatementsQueryFilter filter) {
        CheckoutUtils.validateParams("statementId", statementId, "filter", filter);
        return this.apiClient.queryAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, STATEMENTS_PATH, statementId, PAYMENTS_PATH), this.sdkAuthorization(), filter, ReconciliationPaymentReportResponse.class);
    }

    @Override
    public CompletableFuture<ContentResponse> retrieveCSVPaymentReport(QueryFilterDateRange filter, String targetFile) {
        CheckoutUtils.validateParams("filter", filter);
        return this.apiClient.queryCsvContentAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, PAYMENTS_PATH, DOWNLOAD_PATH), this.sdkAuthorization(), filter, targetFile);
    }

    @Override
    public CompletableFuture<ContentResponse> retrieveCSVSingleStatementReport(String statementId, String targetFile) {
        CheckoutUtils.validateParams("statementId", statementId);
        return this.apiClient.queryCsvContentAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, STATEMENTS_PATH, statementId, PAYMENTS_PATH, DOWNLOAD_PATH), this.sdkAuthorization(), null, targetFile);
    }

    @Override
    public CompletableFuture<ContentResponse> retrieveCSVStatementsReport(StatementsQueryFilter filter, String targetFile) {
        CheckoutUtils.validateParams("filter", filter);
        return this.apiClient.queryCsvContentAsync(ReconciliationClientImpl.buildPath(REPORTING_PATH, STATEMENTS_PATH, DOWNLOAD_PATH), this.sdkAuthorization(), filter, targetFile);
    }
}

