/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.sessions;

import com.checkout.common.ChallengeIndicator;
import com.checkout.common.Currency;
import com.checkout.sessions.AuthenticationType;
import com.checkout.sessions.CardholderAccountInfo;
import com.checkout.sessions.Category;
import com.checkout.sessions.InitialTransaction;
import com.checkout.sessions.Installment;
import com.checkout.sessions.MerchantRiskInfo;
import com.checkout.sessions.Optimization;
import com.checkout.sessions.Recurring;
import com.checkout.sessions.SessionAddress;
import com.checkout.sessions.SessionMarketplaceData;
import com.checkout.sessions.SessionsBillingDescriptor;
import com.checkout.sessions.TransactionType;
import com.checkout.sessions.channel.ChannelData;
import com.checkout.sessions.completion.CompletionInfo;
import com.checkout.sessions.source.SessionCardSource;
import com.checkout.sessions.source.SessionSource;
import com.google.gson.annotations.SerializedName;
import lombok.Generated;

public final class SessionRequest {
    private SessionSource source;
    private Long amount;
    private Currency currency;
    @SerializedName(value="processing_channel_id")
    private String processingChannelId;
    @SerializedName(value="marketplace")
    private SessionMarketplaceData marketplace;
    @SerializedName(value="authentication_type")
    private AuthenticationType authenticationType;
    @SerializedName(value="authentication_category")
    private Category authenticationCategory;
    @SerializedName(value="account_info")
    private CardholderAccountInfo cardholderAccountInfo;
    @SerializedName(value="challenge_indicator")
    private ChallengeIndicator challengeIndicator;
    @SerializedName(value="billing_descriptor")
    private SessionsBillingDescriptor billingDescriptor;
    private String reference;
    @SerializedName(value="merchant_risk_info")
    private MerchantRiskInfo merchantRiskInfo;
    @SerializedName(value="prior_transaction_reference")
    private String priorTransactionReference;
    @SerializedName(value="transaction_type")
    private TransactionType transactionType;
    @SerializedName(value="shipping_address")
    private SessionAddress shippingAddress;
    @SerializedName(value="shipping_address_matches_billing")
    private Boolean shippingAddressMatchesBilling;
    private CompletionInfo completion;
    @SerializedName(value="channel_data")
    private ChannelData channelData;
    private Recurring recurring;
    private Installment installment;
    private Optimization optimization;
    @SerializedName(value="initial_transaction")
    private InitialTransaction initialTransaction;

    @Generated
    private static SessionSource $default$source() {
        return new SessionCardSource();
    }

    @Generated
    private static AuthenticationType $default$authenticationType() {
        return AuthenticationType.REGULAR;
    }

    @Generated
    private static Category $default$authenticationCategory() {
        return Category.PAYMENT;
    }

    @Generated
    private static ChallengeIndicator $default$challengeIndicator() {
        return ChallengeIndicator.NO_PREFERENCE;
    }

    @Generated
    private static TransactionType $default$transactionType() {
        return TransactionType.GOODS_SERVICE;
    }

    @Generated
    public static SessionRequestBuilder builder() {
        return new SessionRequestBuilder();
    }

    @Generated
    public SessionSource getSource() {
        return this.source;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Currency getCurrency() {
        return this.currency;
    }

    @Generated
    public String getProcessingChannelId() {
        return this.processingChannelId;
    }

    @Generated
    public SessionMarketplaceData getMarketplace() {
        return this.marketplace;
    }

    @Generated
    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Generated
    public Category getAuthenticationCategory() {
        return this.authenticationCategory;
    }

    @Generated
    public CardholderAccountInfo getCardholderAccountInfo() {
        return this.cardholderAccountInfo;
    }

    @Generated
    public ChallengeIndicator getChallengeIndicator() {
        return this.challengeIndicator;
    }

    @Generated
    public SessionsBillingDescriptor getBillingDescriptor() {
        return this.billingDescriptor;
    }

    @Generated
    public String getReference() {
        return this.reference;
    }

    @Generated
    public MerchantRiskInfo getMerchantRiskInfo() {
        return this.merchantRiskInfo;
    }

    @Generated
    public String getPriorTransactionReference() {
        return this.priorTransactionReference;
    }

    @Generated
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    @Generated
    public SessionAddress getShippingAddress() {
        return this.shippingAddress;
    }

    @Generated
    public Boolean getShippingAddressMatchesBilling() {
        return this.shippingAddressMatchesBilling;
    }

    @Generated
    public CompletionInfo getCompletion() {
        return this.completion;
    }

    @Generated
    public ChannelData getChannelData() {
        return this.channelData;
    }

    @Generated
    public Recurring getRecurring() {
        return this.recurring;
    }

    @Generated
    public Installment getInstallment() {
        return this.installment;
    }

    @Generated
    public Optimization getOptimization() {
        return this.optimization;
    }

    @Generated
    public InitialTransaction getInitialTransaction() {
        return this.initialTransaction;
    }

    @Generated
    public void setSource(SessionSource source) {
        this.source = source;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Generated
    public void setProcessingChannelId(String processingChannelId) {
        this.processingChannelId = processingChannelId;
    }

    @Generated
    public void setMarketplace(SessionMarketplaceData marketplace) {
        this.marketplace = marketplace;
    }

    @Generated
    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    @Generated
    public void setAuthenticationCategory(Category authenticationCategory) {
        this.authenticationCategory = authenticationCategory;
    }

    @Generated
    public void setCardholderAccountInfo(CardholderAccountInfo cardholderAccountInfo) {
        this.cardholderAccountInfo = cardholderAccountInfo;
    }

    @Generated
    public void setChallengeIndicator(ChallengeIndicator challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
    }

    @Generated
    public void setBillingDescriptor(SessionsBillingDescriptor billingDescriptor) {
        this.billingDescriptor = billingDescriptor;
    }

    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Generated
    public void setMerchantRiskInfo(MerchantRiskInfo merchantRiskInfo) {
        this.merchantRiskInfo = merchantRiskInfo;
    }

    @Generated
    public void setPriorTransactionReference(String priorTransactionReference) {
        this.priorTransactionReference = priorTransactionReference;
    }

    @Generated
    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    @Generated
    public void setShippingAddress(SessionAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    @Generated
    public void setShippingAddressMatchesBilling(Boolean shippingAddressMatchesBilling) {
        this.shippingAddressMatchesBilling = shippingAddressMatchesBilling;
    }

    @Generated
    public void setCompletion(CompletionInfo completion) {
        this.completion = completion;
    }

    @Generated
    public void setChannelData(ChannelData channelData) {
        this.channelData = channelData;
    }

    @Generated
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    @Generated
    public void setInstallment(Installment installment) {
        this.installment = installment;
    }

    @Generated
    public void setOptimization(Optimization optimization) {
        this.optimization = optimization;
    }

    @Generated
    public void setInitialTransaction(InitialTransaction initialTransaction) {
        this.initialTransaction = initialTransaction;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionRequest)) {
            return false;
        }
        SessionRequest other = (SessionRequest)o;
        SessionSource this$source = this.getSource();
        SessionSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        String this$processingChannelId = this.getProcessingChannelId();
        String other$processingChannelId = other.getProcessingChannelId();
        if (this$processingChannelId == null ? other$processingChannelId != null : !this$processingChannelId.equals(other$processingChannelId)) {
            return false;
        }
        SessionMarketplaceData this$marketplace = this.getMarketplace();
        SessionMarketplaceData other$marketplace = other.getMarketplace();
        if (this$marketplace == null ? other$marketplace != null : !((Object)this$marketplace).equals(other$marketplace)) {
            return false;
        }
        AuthenticationType this$authenticationType = this.getAuthenticationType();
        AuthenticationType other$authenticationType = other.getAuthenticationType();
        if (this$authenticationType == null ? other$authenticationType != null : !((Object)((Object)this$authenticationType)).equals((Object)other$authenticationType)) {
            return false;
        }
        Category this$authenticationCategory = this.getAuthenticationCategory();
        Category other$authenticationCategory = other.getAuthenticationCategory();
        if (this$authenticationCategory == null ? other$authenticationCategory != null : !((Object)((Object)this$authenticationCategory)).equals((Object)other$authenticationCategory)) {
            return false;
        }
        CardholderAccountInfo this$cardholderAccountInfo = this.getCardholderAccountInfo();
        CardholderAccountInfo other$cardholderAccountInfo = other.getCardholderAccountInfo();
        if (this$cardholderAccountInfo == null ? other$cardholderAccountInfo != null : !((Object)this$cardholderAccountInfo).equals(other$cardholderAccountInfo)) {
            return false;
        }
        ChallengeIndicator this$challengeIndicator = this.getChallengeIndicator();
        ChallengeIndicator other$challengeIndicator = other.getChallengeIndicator();
        if (this$challengeIndicator == null ? other$challengeIndicator != null : !((Object)((Object)this$challengeIndicator)).equals((Object)other$challengeIndicator)) {
            return false;
        }
        SessionsBillingDescriptor this$billingDescriptor = this.getBillingDescriptor();
        SessionsBillingDescriptor other$billingDescriptor = other.getBillingDescriptor();
        if (this$billingDescriptor == null ? other$billingDescriptor != null : !((Object)this$billingDescriptor).equals(other$billingDescriptor)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        MerchantRiskInfo this$merchantRiskInfo = this.getMerchantRiskInfo();
        MerchantRiskInfo other$merchantRiskInfo = other.getMerchantRiskInfo();
        if (this$merchantRiskInfo == null ? other$merchantRiskInfo != null : !((Object)this$merchantRiskInfo).equals(other$merchantRiskInfo)) {
            return false;
        }
        String this$priorTransactionReference = this.getPriorTransactionReference();
        String other$priorTransactionReference = other.getPriorTransactionReference();
        if (this$priorTransactionReference == null ? other$priorTransactionReference != null : !this$priorTransactionReference.equals(other$priorTransactionReference)) {
            return false;
        }
        TransactionType this$transactionType = this.getTransactionType();
        TransactionType other$transactionType = other.getTransactionType();
        if (this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType)) {
            return false;
        }
        SessionAddress this$shippingAddress = this.getShippingAddress();
        SessionAddress other$shippingAddress = other.getShippingAddress();
        if (this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress)) {
            return false;
        }
        Boolean this$shippingAddressMatchesBilling = this.getShippingAddressMatchesBilling();
        Boolean other$shippingAddressMatchesBilling = other.getShippingAddressMatchesBilling();
        if (this$shippingAddressMatchesBilling == null ? other$shippingAddressMatchesBilling != null : !((Object)this$shippingAddressMatchesBilling).equals(other$shippingAddressMatchesBilling)) {
            return false;
        }
        CompletionInfo this$completion = this.getCompletion();
        CompletionInfo other$completion = other.getCompletion();
        if (this$completion == null ? other$completion != null : !((Object)this$completion).equals(other$completion)) {
            return false;
        }
        ChannelData this$channelData = this.getChannelData();
        ChannelData other$channelData = other.getChannelData();
        if (this$channelData == null ? other$channelData != null : !((Object)this$channelData).equals(other$channelData)) {
            return false;
        }
        Recurring this$recurring = this.getRecurring();
        Recurring other$recurring = other.getRecurring();
        if (this$recurring == null ? other$recurring != null : !((Object)this$recurring).equals(other$recurring)) {
            return false;
        }
        Installment this$installment = this.getInstallment();
        Installment other$installment = other.getInstallment();
        if (this$installment == null ? other$installment != null : !((Object)this$installment).equals(other$installment)) {
            return false;
        }
        Optimization this$optimization = this.getOptimization();
        Optimization other$optimization = other.getOptimization();
        if (this$optimization == null ? other$optimization != null : !((Object)this$optimization).equals(other$optimization)) {
            return false;
        }
        InitialTransaction this$initialTransaction = this.getInitialTransaction();
        InitialTransaction other$initialTransaction = other.getInitialTransaction();
        return !(this$initialTransaction == null ? other$initialTransaction != null : !((Object)this$initialTransaction).equals(other$initialTransaction));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SessionSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        String $processingChannelId = this.getProcessingChannelId();
        result = result * 59 + ($processingChannelId == null ? 43 : $processingChannelId.hashCode());
        SessionMarketplaceData $marketplace = this.getMarketplace();
        result = result * 59 + ($marketplace == null ? 43 : ((Object)$marketplace).hashCode());
        AuthenticationType $authenticationType = this.getAuthenticationType();
        result = result * 59 + ($authenticationType == null ? 43 : ((Object)((Object)$authenticationType)).hashCode());
        Category $authenticationCategory = this.getAuthenticationCategory();
        result = result * 59 + ($authenticationCategory == null ? 43 : ((Object)((Object)$authenticationCategory)).hashCode());
        CardholderAccountInfo $cardholderAccountInfo = this.getCardholderAccountInfo();
        result = result * 59 + ($cardholderAccountInfo == null ? 43 : ((Object)$cardholderAccountInfo).hashCode());
        ChallengeIndicator $challengeIndicator = this.getChallengeIndicator();
        result = result * 59 + ($challengeIndicator == null ? 43 : ((Object)((Object)$challengeIndicator)).hashCode());
        SessionsBillingDescriptor $billingDescriptor = this.getBillingDescriptor();
        result = result * 59 + ($billingDescriptor == null ? 43 : ((Object)$billingDescriptor).hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        MerchantRiskInfo $merchantRiskInfo = this.getMerchantRiskInfo();
        result = result * 59 + ($merchantRiskInfo == null ? 43 : ((Object)$merchantRiskInfo).hashCode());
        String $priorTransactionReference = this.getPriorTransactionReference();
        result = result * 59 + ($priorTransactionReference == null ? 43 : $priorTransactionReference.hashCode());
        TransactionType $transactionType = this.getTransactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        SessionAddress $shippingAddress = this.getShippingAddress();
        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
        Boolean $shippingAddressMatchesBilling = this.getShippingAddressMatchesBilling();
        result = result * 59 + ($shippingAddressMatchesBilling == null ? 43 : ((Object)$shippingAddressMatchesBilling).hashCode());
        CompletionInfo $completion = this.getCompletion();
        result = result * 59 + ($completion == null ? 43 : ((Object)$completion).hashCode());
        ChannelData $channelData = this.getChannelData();
        result = result * 59 + ($channelData == null ? 43 : ((Object)$channelData).hashCode());
        Recurring $recurring = this.getRecurring();
        result = result * 59 + ($recurring == null ? 43 : ((Object)$recurring).hashCode());
        Installment $installment = this.getInstallment();
        result = result * 59 + ($installment == null ? 43 : ((Object)$installment).hashCode());
        Optimization $optimization = this.getOptimization();
        result = result * 59 + ($optimization == null ? 43 : ((Object)$optimization).hashCode());
        InitialTransaction $initialTransaction = this.getInitialTransaction();
        result = result * 59 + ($initialTransaction == null ? 43 : ((Object)$initialTransaction).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SessionRequest(source=" + this.getSource() + ", amount=" + this.getAmount() + ", currency=" + (Object)((Object)this.getCurrency()) + ", processingChannelId=" + this.getProcessingChannelId() + ", marketplace=" + this.getMarketplace() + ", authenticationType=" + (Object)((Object)this.getAuthenticationType()) + ", authenticationCategory=" + (Object)((Object)this.getAuthenticationCategory()) + ", cardholderAccountInfo=" + this.getCardholderAccountInfo() + ", challengeIndicator=" + (Object)((Object)this.getChallengeIndicator()) + ", billingDescriptor=" + this.getBillingDescriptor() + ", reference=" + this.getReference() + ", merchantRiskInfo=" + this.getMerchantRiskInfo() + ", priorTransactionReference=" + this.getPriorTransactionReference() + ", transactionType=" + (Object)((Object)this.getTransactionType()) + ", shippingAddress=" + this.getShippingAddress() + ", shippingAddressMatchesBilling=" + this.getShippingAddressMatchesBilling() + ", completion=" + this.getCompletion() + ", channelData=" + this.getChannelData() + ", recurring=" + this.getRecurring() + ", installment=" + this.getInstallment() + ", optimization=" + this.getOptimization() + ", initialTransaction=" + this.getInitialTransaction() + ")";
    }

    @Generated
    public SessionRequest(SessionSource source, Long amount, Currency currency, String processingChannelId, SessionMarketplaceData marketplace, AuthenticationType authenticationType, Category authenticationCategory, CardholderAccountInfo cardholderAccountInfo, ChallengeIndicator challengeIndicator, SessionsBillingDescriptor billingDescriptor, String reference, MerchantRiskInfo merchantRiskInfo, String priorTransactionReference, TransactionType transactionType, SessionAddress shippingAddress, Boolean shippingAddressMatchesBilling, CompletionInfo completion, ChannelData channelData, Recurring recurring, Installment installment, Optimization optimization, InitialTransaction initialTransaction) {
        this.source = source;
        this.amount = amount;
        this.currency = currency;
        this.processingChannelId = processingChannelId;
        this.marketplace = marketplace;
        this.authenticationType = authenticationType;
        this.authenticationCategory = authenticationCategory;
        this.cardholderAccountInfo = cardholderAccountInfo;
        this.challengeIndicator = challengeIndicator;
        this.billingDescriptor = billingDescriptor;
        this.reference = reference;
        this.merchantRiskInfo = merchantRiskInfo;
        this.priorTransactionReference = priorTransactionReference;
        this.transactionType = transactionType;
        this.shippingAddress = shippingAddress;
        this.shippingAddressMatchesBilling = shippingAddressMatchesBilling;
        this.completion = completion;
        this.channelData = channelData;
        this.recurring = recurring;
        this.installment = installment;
        this.optimization = optimization;
        this.initialTransaction = initialTransaction;
    }

    @Generated
    public SessionRequest() {
        this.source = SessionRequest.$default$source();
        this.authenticationType = SessionRequest.$default$authenticationType();
        this.authenticationCategory = SessionRequest.$default$authenticationCategory();
        this.challengeIndicator = SessionRequest.$default$challengeIndicator();
        this.transactionType = SessionRequest.$default$transactionType();
    }

    @Generated
    public static class SessionRequestBuilder {
        @Generated
        private boolean source$set;
        @Generated
        private SessionSource source;
        @Generated
        private Long amount;
        @Generated
        private Currency currency;
        @Generated
        private String processingChannelId;
        @Generated
        private SessionMarketplaceData marketplace;
        @Generated
        private boolean authenticationType$set;
        @Generated
        private AuthenticationType authenticationType;
        @Generated
        private boolean authenticationCategory$set;
        @Generated
        private Category authenticationCategory;
        @Generated
        private CardholderAccountInfo cardholderAccountInfo;
        @Generated
        private boolean challengeIndicator$set;
        @Generated
        private ChallengeIndicator challengeIndicator;
        @Generated
        private SessionsBillingDescriptor billingDescriptor;
        @Generated
        private String reference;
        @Generated
        private MerchantRiskInfo merchantRiskInfo;
        @Generated
        private String priorTransactionReference;
        @Generated
        private boolean transactionType$set;
        @Generated
        private TransactionType transactionType;
        @Generated
        private SessionAddress shippingAddress;
        @Generated
        private Boolean shippingAddressMatchesBilling;
        @Generated
        private CompletionInfo completion;
        @Generated
        private ChannelData channelData;
        @Generated
        private Recurring recurring;
        @Generated
        private Installment installment;
        @Generated
        private Optimization optimization;
        @Generated
        private InitialTransaction initialTransaction;

        @Generated
        SessionRequestBuilder() {
        }

        @Generated
        public SessionRequestBuilder source(SessionSource source) {
            this.source = source;
            this.source$set = true;
            return this;
        }

        @Generated
        public SessionRequestBuilder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public SessionRequestBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        @Generated
        public SessionRequestBuilder processingChannelId(String processingChannelId) {
            this.processingChannelId = processingChannelId;
            return this;
        }

        @Generated
        public SessionRequestBuilder marketplace(SessionMarketplaceData marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        @Generated
        public SessionRequestBuilder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            this.authenticationType$set = true;
            return this;
        }

        @Generated
        public SessionRequestBuilder authenticationCategory(Category authenticationCategory) {
            this.authenticationCategory = authenticationCategory;
            this.authenticationCategory$set = true;
            return this;
        }

        @Generated
        public SessionRequestBuilder cardholderAccountInfo(CardholderAccountInfo cardholderAccountInfo) {
            this.cardholderAccountInfo = cardholderAccountInfo;
            return this;
        }

        @Generated
        public SessionRequestBuilder challengeIndicator(ChallengeIndicator challengeIndicator) {
            this.challengeIndicator = challengeIndicator;
            this.challengeIndicator$set = true;
            return this;
        }

        @Generated
        public SessionRequestBuilder billingDescriptor(SessionsBillingDescriptor billingDescriptor) {
            this.billingDescriptor = billingDescriptor;
            return this;
        }

        @Generated
        public SessionRequestBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Generated
        public SessionRequestBuilder merchantRiskInfo(MerchantRiskInfo merchantRiskInfo) {
            this.merchantRiskInfo = merchantRiskInfo;
            return this;
        }

        @Generated
        public SessionRequestBuilder priorTransactionReference(String priorTransactionReference) {
            this.priorTransactionReference = priorTransactionReference;
            return this;
        }

        @Generated
        public SessionRequestBuilder transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            this.transactionType$set = true;
            return this;
        }

        @Generated
        public SessionRequestBuilder shippingAddress(SessionAddress shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        @Generated
        public SessionRequestBuilder shippingAddressMatchesBilling(Boolean shippingAddressMatchesBilling) {
            this.shippingAddressMatchesBilling = shippingAddressMatchesBilling;
            return this;
        }

        @Generated
        public SessionRequestBuilder completion(CompletionInfo completion) {
            this.completion = completion;
            return this;
        }

        @Generated
        public SessionRequestBuilder channelData(ChannelData channelData) {
            this.channelData = channelData;
            return this;
        }

        @Generated
        public SessionRequestBuilder recurring(Recurring recurring) {
            this.recurring = recurring;
            return this;
        }

        @Generated
        public SessionRequestBuilder installment(Installment installment) {
            this.installment = installment;
            return this;
        }

        @Generated
        public SessionRequestBuilder optimization(Optimization optimization) {
            this.optimization = optimization;
            return this;
        }

        @Generated
        public SessionRequestBuilder initialTransaction(InitialTransaction initialTransaction) {
            this.initialTransaction = initialTransaction;
            return this;
        }

        @Generated
        public SessionRequest build() {
            SessionSource source = this.source;
            if (!this.source$set) {
                source = SessionRequest.$default$source();
            }
            AuthenticationType authenticationType = this.authenticationType;
            if (!this.authenticationType$set) {
                authenticationType = SessionRequest.$default$authenticationType();
            }
            Category authenticationCategory = this.authenticationCategory;
            if (!this.authenticationCategory$set) {
                authenticationCategory = SessionRequest.$default$authenticationCategory();
            }
            ChallengeIndicator challengeIndicator = this.challengeIndicator;
            if (!this.challengeIndicator$set) {
                challengeIndicator = SessionRequest.$default$challengeIndicator();
            }
            TransactionType transactionType = this.transactionType;
            if (!this.transactionType$set) {
                transactionType = SessionRequest.$default$transactionType();
            }
            return new SessionRequest(source, this.amount, this.currency, this.processingChannelId, this.marketplace, authenticationType, authenticationCategory, this.cardholderAccountInfo, challengeIndicator, this.billingDescriptor, this.reference, this.merchantRiskInfo, this.priorTransactionReference, transactionType, this.shippingAddress, this.shippingAddressMatchesBilling, this.completion, this.channelData, this.recurring, this.installment, this.optimization, this.initialTransaction);
        }

        @Generated
        public String toString() {
            return "SessionRequest.SessionRequestBuilder(source=" + this.source + ", amount=" + this.amount + ", currency=" + (Object)((Object)this.currency) + ", processingChannelId=" + this.processingChannelId + ", marketplace=" + this.marketplace + ", authenticationType=" + (Object)((Object)this.authenticationType) + ", authenticationCategory=" + (Object)((Object)this.authenticationCategory) + ", cardholderAccountInfo=" + this.cardholderAccountInfo + ", challengeIndicator=" + (Object)((Object)this.challengeIndicator) + ", billingDescriptor=" + this.billingDescriptor + ", reference=" + this.reference + ", merchantRiskInfo=" + this.merchantRiskInfo + ", priorTransactionReference=" + this.priorTransactionReference + ", transactionType=" + (Object)((Object)this.transactionType) + ", shippingAddress=" + this.shippingAddress + ", shippingAddressMatchesBilling=" + this.shippingAddressMatchesBilling + ", completion=" + this.completion + ", channelData=" + this.channelData + ", recurring=" + this.recurring + ", installment=" + this.installment + ", optimization=" + this.optimization + ", initialTransaction=" + this.initialTransaction + ")";
        }
    }
}

