/*
 * Decompiled with CFR 0.152.
 */
package com.checkout;

import com.checkout.AbstractCheckoutSdkBuilder;
import com.checkout.CheckoutApiImpl;
import com.checkout.CheckoutArgumentException;
import com.checkout.CheckoutPreviousSdkBuilder;
import com.checkout.IEnvironment;
import com.checkout.OAuthScope;
import com.checkout.OAuthSdkCredentials;
import com.checkout.SdkCredentials;
import com.checkout.StaticKeysSdkCredentials;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class CheckoutSdkBuilder {
    public CheckoutPreviousSdkBuilder previous() {
        return new CheckoutPreviousSdkBuilder();
    }

    public CheckoutStaticKeysSdkBuilder staticKeys() {
        return new CheckoutStaticKeysSdkBuilder();
    }

    public CheckoutOAuthSdkBuilder oAuth() {
        return new CheckoutOAuthSdkBuilder();
    }

    public static class CheckoutStaticKeysSdkBuilder
    extends AbstractCheckoutSdkBuilder<CheckoutApiImpl> {
        private String publicKey;
        private String secretKey;

        public CheckoutStaticKeysSdkBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public CheckoutStaticKeysSdkBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Override
        protected SdkCredentials getSdkCredentials() {
            return new StaticKeysSdkCredentials(this.secretKey, this.publicKey);
        }

        @Override
        public CheckoutApiImpl build() {
            return new CheckoutApiImpl(this.getCheckoutConfiguration());
        }
    }

    public static class CheckoutOAuthSdkBuilder
    extends AbstractCheckoutSdkBuilder<CheckoutApiImpl> {
        private String clientId;
        private String clientSecret;
        private URI authorizationUri;
        private final Set<OAuthScope> scopes = new HashSet<OAuthScope>();

        public CheckoutOAuthSdkBuilder clientCredentials(URI authorizationUri, String clientId, String clientSecret) {
            this.authorizationUri = authorizationUri;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            return this;
        }

        public CheckoutOAuthSdkBuilder clientCredentials(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            return this;
        }

        public CheckoutOAuthSdkBuilder scopes(OAuthScope ... scopes) {
            this.scopes.addAll(Arrays.asList(scopes));
            return this;
        }

        @Override
        protected SdkCredentials getSdkCredentials() {
            if (this.authorizationUri == null) {
                IEnvironment environment = this.getEnvironment();
                if (environment == null) {
                    throw new CheckoutArgumentException("Invalid configuration. Please specify an Environment or a specific OAuth authorizationURI.");
                }
                this.authorizationUri = environment.getOAuthAuthorizationApi();
            }
            OAuthSdkCredentials credentials = new OAuthSdkCredentials(this.httpClientBuilder, this.authorizationUri, this.clientId, this.clientSecret, this.scopes);
            credentials.initOAuthAccess();
            return credentials;
        }

        @Override
        public CheckoutApiImpl build() {
            return new CheckoutApiImpl(this.getCheckoutConfiguration());
        }
    }
}

