/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.forward;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.forward.ForwardClient;
import com.checkout.forward.requests.ForwardRequest;
import com.checkout.forward.responses.ForwardAnApiResponse;
import com.checkout.forward.responses.GetForwardResponse;
import java.util.concurrent.CompletableFuture;

public class ForwardClientImpl
extends AbstractClient
implements ForwardClient {
    private static final String FORWARD_PATH = "forward";

    public ForwardClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<ForwardAnApiResponse> forwardAnApiRequest(ForwardRequest forwardRequest) {
        CheckoutUtils.validateParams("forwardRequest", forwardRequest);
        return this.apiClient.postAsync(FORWARD_PATH, this.sdkAuthorization(), ForwardAnApiResponse.class, (Object)forwardRequest, null);
    }

    @Override
    public CompletableFuture<GetForwardResponse> getForwardRequest(String forwardId) {
        CheckoutUtils.validateParams("forwardId", forwardId);
        return this.apiClient.getAsync(ForwardClientImpl.buildPath(FORWARD_PATH, forwardId), this.sdkAuthorization(), GetForwardResponse.class);
    }
}

