/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.handlepaymentsandpayouts.flow;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.handlepaymentsandpayouts.flow.FlowClient;
import com.checkout.handlepaymentsandpayouts.flow.paymentsessions.requests.PaymentSessionRequest;
import com.checkout.handlepaymentsandpayouts.flow.paymentsessions.responses.PaymentSessionResponse;
import com.checkout.handlepaymentsandpayouts.flow.paymentsessionscomplete.requests.PaymentSessionWithPaymentRequest;
import com.checkout.handlepaymentsandpayouts.flow.paymentsessionscomplete.responses.PaymentSessionWithPaymentResponse;
import com.checkout.handlepaymentsandpayouts.flow.paymentsessionssubmit.requests.SubmitPaymentSessionRequest;
import com.checkout.handlepaymentsandpayouts.flow.paymentsessionssubmit.responses.SubmitPaymentSessionResponse;
import java.util.concurrent.CompletableFuture;

public class FlowClientImpl
extends AbstractClient
implements FlowClient {
    private static final String PAYMENT_SESSIONS_PATH = "payment-sessions";
    private static final String COMPLETE_PATH = "complete";
    private static final String SUBMIT_PATH = "submit";

    public FlowClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public CompletableFuture<PaymentSessionResponse> requestPaymentSession(PaymentSessionRequest paymentSessionRequest) {
        CheckoutUtils.validateParams("paymentSessionRequest", paymentSessionRequest);
        return this.apiClient.postAsync(PAYMENT_SESSIONS_PATH, this.sdkAuthorization(), PaymentSessionResponse.class, (Object)paymentSessionRequest, null);
    }

    @Override
    public CompletableFuture<SubmitPaymentSessionResponse> submitPaymentSessions(String paymentId, SubmitPaymentSessionRequest submitPaymentSessionsRequest) {
        CheckoutUtils.validateParams("paymentId", paymentId, "submitPaymentSessionsRequest", submitPaymentSessionsRequest);
        return this.apiClient.postAsync(FlowClientImpl.buildPath(PAYMENT_SESSIONS_PATH, paymentId, SUBMIT_PATH), this.sdkAuthorization(), SubmitPaymentSessionResponse.class, (Object)submitPaymentSessionsRequest, null);
    }

    @Override
    public CompletableFuture<PaymentSessionWithPaymentResponse> requestPaymentSessionWithPayment(PaymentSessionWithPaymentRequest paymentSessionWithPaymentRequest) {
        CheckoutUtils.validateParams("paymentSessionWithPaymentRequest", paymentSessionWithPaymentRequest);
        return this.apiClient.postAsync(FlowClientImpl.buildPath(PAYMENT_SESSIONS_PATH, COMPLETE_PATH), this.sdkAuthorization(), PaymentSessionWithPaymentResponse.class, (Object)paymentSessionWithPaymentRequest, null);
    }
}

