/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.instruments;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.common.CountryCode;
import com.checkout.common.Currency;
import com.checkout.instruments.InstrumentsClient;
import com.checkout.instruments.create.CreateInstrumentRequest;
import com.checkout.instruments.create.CreateInstrumentResponse;
import com.checkout.instruments.get.BankAccountFieldQuery;
import com.checkout.instruments.get.BankAccountFieldResponse;
import com.checkout.instruments.get.GetInstrumentResponse;
import com.checkout.instruments.update.UpdateInstrumentRequest;
import com.checkout.instruments.update.UpdateInstrumentResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public class InstrumentsClientImpl
extends AbstractClient
implements InstrumentsClient {
    private static final String INSTRUMENTS_PATH = "instruments";
    private static final String VALIDATION_PATH = "validation/bank-accounts";
    private static final Type CREATE_TYPE = TypeToken.get(CreateInstrumentResponse.class).getType();
    private static final Type UPDATE_TYPE = TypeToken.get(UpdateInstrumentResponse.class).getType();
    private static final Type GET_TYPE = TypeToken.get(GetInstrumentResponse.class).getType();

    public InstrumentsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY_OR_OAUTH);
    }

    @Override
    public <T extends CreateInstrumentResponse> CompletableFuture<T> create(CreateInstrumentRequest createInstrumentRequest) {
        CheckoutUtils.validateParams("createInstrumentRequest", createInstrumentRequest);
        return this.apiClient.postAsync(INSTRUMENTS_PATH, this.sdkAuthorization(), CREATE_TYPE, (Object)createInstrumentRequest, null);
    }

    @Override
    public CompletableFuture<GetInstrumentResponse> get(String instrumentId) {
        CheckoutUtils.validateParams("instrumentId", instrumentId);
        return this.apiClient.getAsync(InstrumentsClientImpl.buildPath(INSTRUMENTS_PATH, instrumentId), this.sdkAuthorization(), GET_TYPE);
    }

    @Override
    public <T extends UpdateInstrumentResponse> CompletableFuture<T> update(String instrumentId, UpdateInstrumentRequest updateInstrumentRequest) {
        CheckoutUtils.validateParams("instrumentId", instrumentId, "updateInstrumentRequest", updateInstrumentRequest);
        return this.apiClient.patchAsync(InstrumentsClientImpl.buildPath(INSTRUMENTS_PATH, instrumentId), this.sdkAuthorization(), UPDATE_TYPE, (Object)updateInstrumentRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> delete(String instrumentId) {
        CheckoutUtils.validateParams("instrumentId", instrumentId);
        return this.apiClient.deleteAsync(InstrumentsClientImpl.buildPath(INSTRUMENTS_PATH, instrumentId), this.sdkAuthorization());
    }

    @Override
    public CompletableFuture<BankAccountFieldResponse> getBankAccountFieldFormatting(CountryCode country, Currency currency, BankAccountFieldQuery query) {
        CheckoutUtils.validateParams("country", (Object)country, "currency", (Object)currency, "query", query);
        return this.apiClient.queryAsync(InstrumentsClientImpl.buildPath(VALIDATION_PATH, country.name(), currency.name()), this.sdkAuthorization(SdkAuthorizationType.OAUTH), query, BankAccountFieldResponse.class);
    }
}

