/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.instruments.previous;

import com.checkout.AbstractClient;
import com.checkout.ApiClient;
import com.checkout.CheckoutConfiguration;
import com.checkout.EmptyResponse;
import com.checkout.SdkAuthorizationType;
import com.checkout.common.CheckoutUtils;
import com.checkout.instruments.previous.CreateInstrumentRequest;
import com.checkout.instruments.previous.CreateInstrumentResponse;
import com.checkout.instruments.previous.InstrumentDetailsResponse;
import com.checkout.instruments.previous.InstrumentsClient;
import com.checkout.instruments.previous.UpdateInstrumentRequest;
import com.checkout.instruments.previous.UpdateInstrumentResponse;
import java.util.concurrent.CompletableFuture;

public class InstrumentsClientImpl
extends AbstractClient
implements InstrumentsClient {
    private static final String INSTRUMENTS_PATH = "instruments";
    private static final String INSTRUMENT_ID = "instrumentId";

    public InstrumentsClientImpl(ApiClient apiClient, CheckoutConfiguration configuration) {
        super(apiClient, configuration, SdkAuthorizationType.SECRET_KEY);
    }

    @Override
    public CompletableFuture<CreateInstrumentResponse> create(CreateInstrumentRequest createInstrumentRequest) {
        CheckoutUtils.validateParams("createInstrumentRequest", createInstrumentRequest);
        return this.apiClient.postAsync(INSTRUMENTS_PATH, this.sdkAuthorization(), CreateInstrumentResponse.class, (Object)createInstrumentRequest, null);
    }

    @Override
    public CompletableFuture<InstrumentDetailsResponse> get(String instrumentId) {
        CheckoutUtils.validateParams(INSTRUMENT_ID, instrumentId);
        return this.apiClient.getAsync(InstrumentsClientImpl.buildPath(INSTRUMENTS_PATH, instrumentId), this.sdkAuthorization(), InstrumentDetailsResponse.class);
    }

    @Override
    public CompletableFuture<UpdateInstrumentResponse> update(String instrumentId, UpdateInstrumentRequest updateInstrumentRequest) {
        CheckoutUtils.validateParams(INSTRUMENT_ID, instrumentId, "updateInstrumentRequest", updateInstrumentRequest);
        return this.apiClient.patchAsync(InstrumentsClientImpl.buildPath(INSTRUMENTS_PATH, instrumentId), this.sdkAuthorization(), UpdateInstrumentResponse.class, (Object)updateInstrumentRequest, null);
    }

    @Override
    public CompletableFuture<EmptyResponse> delete(String instrumentId) {
        CheckoutUtils.validateParams(INSTRUMENT_ID, instrumentId);
        return this.apiClient.deleteAsync(InstrumentsClientImpl.buildPath(INSTRUMENTS_PATH, instrumentId), this.sdkAuthorization());
    }
}

