/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j.analysis;

import com.chenlb.mmseg4j.Dictionary;
import com.chenlb.mmseg4j.MaxWordSeg;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.analysis.MMSegTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public class MMSegAnalyzer
extends Analyzer {
    protected Dictionary dic;

    public MMSegAnalyzer() {
        this.dic = Dictionary.getInstance();
    }

    public MMSegAnalyzer(String path) {
        this.dic = Dictionary.getInstance((String)path);
    }

    public MMSegAnalyzer(File path) {
        this.dic = Dictionary.getInstance((File)path);
    }

    public MMSegAnalyzer(Dictionary dic) {
        this.dic = dic;
    }

    protected Seg newSeg() {
        return new MaxWordSeg(this.dic);
    }

    public Dictionary getDict() {
        return this.dic;
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        MMSegTokenizer mmsegTokenizer = (MMSegTokenizer)((Object)this.getPreviousTokenStream());
        if (mmsegTokenizer == null) {
            mmsegTokenizer = new MMSegTokenizer(this.newSeg(), reader);
            this.setPreviousTokenStream((Object)mmsegTokenizer);
        } else {
            mmsegTokenizer.reset(reader);
        }
        return mmsegTokenizer;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        MMSegTokenizer ts = new MMSegTokenizer(this.newSeg(), reader);
        return ts;
    }
}

