/*
 * Decompiled with CFR 0.152.
 */
package com.chrisomeara.pillar.cli;

import com.chrisomeara.pillar.ConfigurationException;
import com.chrisomeara.pillar.Registry;
import com.chrisomeara.pillar.Registry$;
import com.chrisomeara.pillar.Reporter;
import com.chrisomeara.pillar.cli.App$;
import com.chrisomeara.pillar.cli.Command;
import com.chrisomeara.pillar.cli.CommandExecutor$;
import com.chrisomeara.pillar.cli.CommandLineConfiguration;
import com.chrisomeara.pillar.cli.CommandLineConfiguration$;
import com.chrisomeara.pillar.cli.Initialize$;
import com.chrisomeara.pillar.cli.MigratorAction;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!<Q!\u0001\u0002\t\u0002-\t1!\u00119q\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\rALG\u000e\\1s\u0015\t9\u0001\"A\u0006dQJL7o\\7fCJ\f'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u0007\u0005\u0003\bo\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\t\u000biiA\u0011A\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005qy\u0006C\u0001\u0007\u001e\r\u0011q!\u0001\u0001\u0010\u0014\u0005u\u0001\u0002\u0002\u0003\u0011\u001e\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u0011I,\u0007o\u001c:uKJ\u0004\"AI\u0012\u000e\u0003\u0011I!\u0001\n\u0003\u0003\u0011I+\u0007o\u001c:uKJDQaF\u000f\u0005\u0002\u0019\"\"\u0001H\u0014\t\u000b\u0001*\u0003\u0019A\u0011\t\u000b%jB\u0011\u0001\u0016\u0002\u0007I,h\u000e\u0006\u0002,]A\u0011\u0011\u0003L\u0005\u0003[I\u0011A!\u00168ji\")q\u0006\u000ba\u0001a\u0005I\u0011M]4v[\u0016tGo\u001d\t\u0004#E\u001a\u0014B\u0001\u001a\u0013\u0005\u0015\t%O]1z!\t!tG\u0004\u0002\u0012k%\u0011aGE\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027%!)1(\bC\u0005y\u0005!r-\u001a;Ge>l7i\u001c8gS\u001e,(/\u0019;j_:$baM\u001fH\u0013.k\u0005\"\u0002 ;\u0001\u0004y\u0014!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u000611m\u001c8gS\u001eT!\u0001\u0012\u0005\u0002\u0011QL\b/Z:bM\u0016L!AR!\u0003\r\r{gNZ5h\u0011\u0015A%\b1\u00014\u0003\u0011q\u0017-\\3\t\u000b)S\u0004\u0019A\u001a\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0005\u0006\u0019j\u0002\raM\u0001\u0004W\u0016L\bb\u0002(;!\u0003\u0005\raT\u0001\bI\u00164\u0017-\u001e7u!\r\t\u0002kM\u0005\u0003#J\u0011aa\u00149uS>t\u0007bB*\u001e#\u0003%I\u0001V\u0001\u001fO\u0016$hI]8n\u0007>tg-[4ve\u0006$\u0018n\u001c8%I\u00164\u0017-\u001e7uIU*\u0012!\u0016\u0016\u0003\u001fZ[\u0013a\u0016\t\u00031vk\u0011!\u0017\u0006\u00035n\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005q\u0013\u0012AC1o]>$\u0018\r^5p]&\u0011a,\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002\u0011\u001a!\u0003\u0005\r!\t\u0005\u0006C6!\tAY\u0001\u0005[\u0006Lg\u000e\u0006\u0002,G\")q\u0006\u0019a\u0001a!9Q-DI\u0001\n\u00031\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003\u001dT#!\t,")
public class App {
    private final Reporter reporter;

    public static Reporter apply$default$1() {
        return App$.MODULE$.apply$default$1();
    }

    public static void main(String[] stringArray) {
        App$.MODULE$.main(stringArray);
    }

    public static App apply(Reporter reporter) {
        return App$.MODULE$.apply(reporter);
    }

    public void run(String[] arguments) {
        CommandLineConfiguration commandLineConfiguration = CommandLineConfiguration$.MODULE$.buildFromArguments(arguments);
        Registry registry = Registry$.MODULE$.fromDirectory(new File(commandLineConfiguration.migrationsDirectory(), commandLineConfiguration.dataStore()));
        Config configuration = ConfigFactory.load();
        String dataStoreName = commandLineConfiguration.dataStore();
        String environment = commandLineConfiguration.environment();
        String keyspace = this.getFromConfiguration(configuration, dataStoreName, environment, "cassandra-keyspace-name", this.getFromConfiguration$default$5());
        String seedAddress = this.getFromConfiguration(configuration, dataStoreName, environment, "cassandra-seed-address", (Option<String>)new Some((Object)"127.0.0.1"));
        Integer port = Integer.valueOf(this.getFromConfiguration(configuration, dataStoreName, environment, "cassandra-port", (Option<String>)new Some((Object)((Object)BoxesRunTime.boxToInteger((int)9042)).toString())));
        String username = this.getFromConfiguration(configuration, dataStoreName, environment, "cassandra-username", (Option<String>)new Some((Object)"cassandra"));
        String password = this.getFromConfiguration(configuration, dataStoreName, environment, "cassandra-password", (Option<String>)new Some((Object)"cassandra"));
        Cluster.Builder builder = Cluster.builder().addContactPoint(seedAddress).withPort(Predef$.MODULE$.Integer2int(port)).withCredentials(username, password);
        Object object = new StringOps(Predef$.MODULE$.augmentString(this.getFromConfiguration(configuration, dataStoreName, environment, "cassandra-ssl", (Option<String>)new Some((Object)"false")))).toBoolean() ? builder.withSSL() : BoxedUnit.UNIT;
        Cluster cluster = builder.build();
        MigratorAction migratorAction = commandLineConfiguration.command();
        Initialize$ initialize$ = Initialize$.MODULE$;
        MigratorAction migratorAction2 = migratorAction;
        Session session = !(initialize$ != null ? !initialize$.equals(migratorAction2) : migratorAction2 != null) ? cluster.connect() : cluster.connect(keyspace);
        Session session2 = session;
        Command command = new Command(commandLineConfiguration.command(), session2, keyspace, commandLineConfiguration.timeStampOption(), registry);
        try {
            CommandExecutor$.MODULE$.apply().execute(command, this.reporter);
            return;
        }
        finally {
            session2.close();
        }
    }

    private String getFromConfiguration(Config configuration, String name, String environment, String key, Option<String> option) {
        String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pillar.", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, environment, key}));
        if (configuration.hasPath(path)) {
            return configuration.getString(path);
        }
        if (option == None$.MODULE$) {
            throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not found in application configuration"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        return (String)option.get();
    }

    private Option<String> getFromConfiguration$default$5() {
        return None$.MODULE$;
    }

    public App(Reporter reporter) {
        this.reporter = reporter;
    }
}

