/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import com.cisco.oss.foundation.configuration.CCPUtil;
import com.cisco.oss.foundation.configuration.xml.jaxb.NamespaceDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.NamespaceDefinitions;
import com.cisco.oss.foundation.configuration.xml.jaxb.NamespaceIdentifier;
import com.cisco.oss.foundation.configuration.xml.jaxb.Parameter;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.PrimitiveValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureMemberDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureMemberValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCPPropertiesMerge {
    private static final Logger logger = LoggerFactory.getLogger(CCPPropertiesMerge.class);
    private static final String paramNameSeperator = ".";

    public static Map<NamespaceIdentifier, Map<String, Parameter>> mergerPropertiesToCCPObjects(NamespaceDefinitions namespaceDefinitions, Properties properties) {
        AbstractConfiguration.setDefaultListDelimiter((char)'<');
        logger.trace("Merging properties object with CCP Namespace Parameters");
        HashMap<NamespaceIdentifier, Map<String, Parameter>> meregedConfigurationMap = new HashMap<NamespaceIdentifier, Map<String, Parameter>>();
        CompositeConfiguration configProperties = new CompositeConfiguration();
        configProperties.setDelimiterParsingDisabled(true);
        for (Object property : properties.keySet()) {
            String propertyValue = properties.getProperty(property.toString());
            if (StringUtils.isEmpty((String)propertyValue) || StringUtils.startsWith((String)propertyValue, (String)"<") && StringUtils.endsWith((String)propertyValue, (String)">")) {
                logger.trace("Ignoring " + property + " parameter from properties object as it has no valid value: " + propertyValue);
                continue;
            }
            configProperties.addProperty(property.toString(), (Object)StringEscapeUtils.escapeXml((String)propertyValue));
            logger.trace("Adding " + property + " parameter from properties object with value " + propertyValue + " to configuration object");
        }
        for (NamespaceDefinition namespaceDefinition : namespaceDefinitions.getNamespaceDefinitions()) {
            logger.trace("Looking for new parameters value for parameters from namspace: " + namespaceDefinition.getNamespaceIdentifier().getName() + " - " + namespaceDefinition.getNamespaceIdentifier().getVersion());
            HashMap<String, Parameter> mergedParameterValues = new HashMap<String, Parameter>();
            HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>();
            ArrayList<String> primitiveParameterList = new ArrayList<String>();
            ArrayList<String> primitiveArrayParameterList = new ArrayList<String>();
            HashMap<String, Parameter> structureDefinitionMap = new HashMap<String, Parameter>();
            HashMap<String, List<String>> structureMemberMap = new HashMap<String, List<String>>();
            CCPPropertiesMerge.generatePrimitiveParameterList(parameterMap, namespaceDefinition, primitiveParameterList, primitiveArrayParameterList, structureDefinitionMap, structureMemberMap);
            Set structureNameSet = structureDefinitionMap.keySet();
            Iterator propertyKeyIterator = configProperties.getKeys();
            while (propertyKeyIterator.hasNext()) {
                ParameterValue parameterValue;
                String propertyKey = (String)propertyKeyIterator.next();
                if (primitiveParameterList.contains(propertyKey)) {
                    ParameterValue parameterValue2 = CCPPropertiesMerge.generatePrimitiveParameterValue((Configuration)configProperties, propertyKey);
                    Parameter parameter = (Parameter)parameterMap.get(propertyKey);
                    parameter.setValue(parameterValue2);
                    mergedParameterValues.put(propertyKey, parameter);
                    continue;
                }
                if (primitiveArrayParameterList.contains(StringUtils.substringBeforeLast((String)propertyKey, (String)paramNameSeperator))) {
                    String primitivePropertyName = StringUtils.substringBeforeLast((String)propertyKey, (String)paramNameSeperator);
                    if (mergedParameterValues.containsKey(primitivePropertyName)) continue;
                    ParameterValue parameterValue3 = CCPPropertiesMerge.generatePrimitiveArrayParameterValue((Configuration)configProperties, primitivePropertyName);
                    Parameter parameter = (Parameter)parameterMap.get(primitivePropertyName);
                    parameter.setValue(parameterValue3);
                    mergedParameterValues.put(primitivePropertyName, parameter);
                    continue;
                }
                String candidateStructName = propertyKey;
                while (StringUtils.isNotEmpty((String)candidateStructName) && !structureNameSet.contains(candidateStructName)) {
                    if (candidateStructName.contains(paramNameSeperator)) {
                        candidateStructName = StringUtils.substringBeforeLast((String)candidateStructName, (String)paramNameSeperator);
                        continue;
                    }
                    candidateStructName = "";
                }
                if (StringUtils.isEmpty((String)candidateStructName)) continue;
                Parameter structureParameter = (Parameter)structureDefinitionMap.get(candidateStructName);
                if (mergedParameterValues.containsKey(candidateStructName) || null == (parameterValue = CCPPropertiesMerge.generateStructureParameterValue(candidateStructName, structureParameter, (Configuration)configProperties))) continue;
                Parameter parameter = (Parameter)parameterMap.get(candidateStructName);
                parameter.setValue(parameterValue);
                mergedParameterValues.put(candidateStructName, parameter);
            }
            meregedConfigurationMap.put(namespaceDefinition.getNamespaceIdentifier(), mergedParameterValues);
        }
        return meregedConfigurationMap;
    }

    private static List<String> generatePrimitiveParameterList(Map<String, Parameter> parameterMap, NamespaceDefinition namespaceDefinition, List<String> primitiveParameterList, List<String> primitiveArrayParameterList, Map<String, Parameter> structureDefinitionMap, Map<String, List<String>> structureMemberMap) {
        for (Parameter parameter : namespaceDefinition.getParameters()) {
            parameterMap.put(parameter.getName(), CCPUtil.clone(parameter));
            if (null == parameter.getStructureDefinition()) {
                if (!parameter.isIsArray()) {
                    primitiveParameterList.add(parameter.getName());
                    continue;
                }
                primitiveArrayParameterList.add(parameter.getName());
                continue;
            }
            structureDefinitionMap.put(parameter.getName(), CCPUtil.clone(parameter));
            ArrayList<String> structureMemeberList = new ArrayList<String>();
            for (StructureMemberDefinition structureMemberDefinition : parameter.getStructureDefinition().getStructureMemberDefinitions()) {
                structureMemeberList.add(structureMemberDefinition.getName());
            }
            structureMemberMap.put(parameter.getName(), structureMemeberList);
        }
        return primitiveParameterList;
    }

    private static ParameterValue generatePrimitiveParameterValue(Configuration configuration, String propertyName) {
        PrimitiveValue primitiveValue = new PrimitiveValue();
        primitiveValue.setValue(CCPPropertiesMerge.getValueFromConfiguration(propertyName, configuration));
        ArrayList<PrimitiveValue> primitiveValueList = new ArrayList<PrimitiveValue>();
        primitiveValueList.add(primitiveValue);
        ParameterValue parameterValue = new ParameterValue();
        parameterValue.setPrimitiveValues(primitiveValueList);
        configuration.clearProperty(propertyName);
        return parameterValue;
    }

    private static ParameterValue generatePrimitiveArrayParameterValue(Configuration configuration, String propertyName) {
        ArrayList<PrimitiveValue> primitiveValueList = new ArrayList<PrimitiveValue>();
        Iterator arrayProperties = configuration.getKeys(propertyName);
        while (arrayProperties.hasNext()) {
            String arrayElementProperty = (String)arrayProperties.next();
            PrimitiveValue primitiveValue = new PrimitiveValue();
            primitiveValue.setValue(CCPPropertiesMerge.getValueFromConfiguration(arrayElementProperty, configuration));
            primitiveValue.setIndex(StringUtils.substringAfterLast((String)arrayElementProperty, (String)paramNameSeperator));
            primitiveValueList.add(primitiveValue);
            configuration.clearProperty(arrayElementProperty);
        }
        ParameterValue parameterValue = new ParameterValue();
        parameterValue.setPrimitiveValues(primitiveValueList);
        return parameterValue;
    }

    private static ParameterValue generateStructureParameterValue(String structureName, Parameter structureParameter, Configuration configuration) {
        List<StructureValue> structureValueList = CCPPropertiesMerge.generateListOfStructureValue(structureName, structureParameter.getStructureDefinition(), structureParameter.isIsArray(), configuration);
        if (null == structureValueList || structureValueList.size() == 0) {
            return null;
        }
        ParameterValue parameterValue = new ParameterValue();
        parameterValue.setStructureValues(structureValueList);
        return parameterValue;
    }

    private static List<StructureValue> generateListOfStructureValue(String structureName, StructureDefinition structureDefinition, boolean isArray, Configuration configuration) {
        String structureConfiguration;
        Iterator structureConfigurationIter;
        String flatNamePrefix = structureName;
        HashMap<String, CompositeConfiguration> structureIndexValueMap = new HashMap<String, CompositeConfiguration>();
        if (isArray) {
            structureConfigurationIter = configuration.getKeys(flatNamePrefix);
            while (structureConfigurationIter.hasNext()) {
                structureConfiguration = (String)structureConfigurationIter.next();
                String index = StringUtils.substringBetween((String)structureConfiguration, (String)(flatNamePrefix + paramNameSeperator), (String)paramNameSeperator);
                if (StringUtils.isEmpty((String)index)) continue;
                if (!structureIndexValueMap.containsKey(index)) {
                    structureIndexValueMap.put(index, new CompositeConfiguration());
                }
                ((Configuration)structureIndexValueMap.get(index)).addProperty(structureConfiguration, (Object)CCPPropertiesMerge.getValueFromConfiguration(structureConfiguration, configuration));
            }
        } else {
            structureIndexValueMap.put(null, new CompositeConfiguration());
            structureConfigurationIter = configuration.getKeys(flatNamePrefix);
            while (structureConfigurationIter.hasNext()) {
                structureConfiguration = (String)structureConfigurationIter.next();
                ((Configuration)structureIndexValueMap.get(null)).addProperty(structureConfiguration, (Object)CCPPropertiesMerge.getValueFromConfiguration(structureConfiguration, configuration));
            }
        }
        ArrayList<StructureValue> structureValueList = new ArrayList<StructureValue>();
        for (String structureIndex : structureIndexValueMap.keySet()) {
            StructureValue structureValue;
            String index = null;
            if (StringUtils.isNotEmpty((String)structureIndex)) {
                index = structureIndex;
            }
            if (null == (structureValue = CCPPropertiesMerge.generateStructureValue(structureName, structureDefinition, index, configuration))) continue;
            structureValueList.add(structureValue);
        }
        return structureValueList;
    }

    private static List<StructureValue> generateListOfStructureValueFromDefault(StructureMemberDefinition structureMemberDefinition) {
        if (null == structureMemberDefinition.getDefaultValue() || null == structureMemberDefinition.getDefaultValue().getStructureValues() || structureMemberDefinition.getDefaultValue().getStructureValues().size() <= 0) {
            return null;
        }
        return structureMemberDefinition.getDefaultValue().getStructureValues();
    }

    private static StructureValue generateStructureValue(String structureName, StructureDefinition structureDefinition, String index, Configuration configuration) {
        ArrayList<StructureMemberValue> structureMemeberValueList = new ArrayList<StructureMemberValue>();
        String flatConfigPrefix = structureName + paramNameSeperator;
        if (null != index) {
            flatConfigPrefix = flatConfigPrefix + index + paramNameSeperator;
        }
        for (StructureMemberDefinition structureMemberDefinition : structureDefinition.getStructureMemberDefinitions()) {
            StructureMemberValue structureMemberValue = new StructureMemberValue();
            structureMemberValue.setName(structureMemberDefinition.getName());
            String flatConfig = flatConfigPrefix;
            if (!structureMemberDefinition.isIgnoreName()) {
                flatConfig = flatConfig + structureMemberDefinition.getName();
            } else if (flatConfigPrefix.endsWith(paramNameSeperator)) {
                flatConfig = flatConfigPrefix.substring(0, flatConfigPrefix.length() - 1);
            }
            if (null != structureMemberDefinition.getStructureDefinition()) {
                List<StructureValue> nestedStructureValue = CCPPropertiesMerge.generateListOfStructureValue(flatConfig, structureMemberDefinition.getStructureDefinition(), structureMemberDefinition.isIsArray(), configuration);
                if (structureMemberDefinition.isRequired() && (null == nestedStructureValue || nestedStructureValue.size() == 0)) {
                    nestedStructureValue = CCPPropertiesMerge.generateListOfStructureValueFromDefault(structureMemberDefinition);
                }
                if (structureMemberDefinition.isRequired() && (null == nestedStructureValue || nestedStructureValue.size() == 0)) {
                    logger.warn("Neither config.proeprties file nor ccpConfig.xml file contains value for: " + flatConfig);
                    continue;
                }
                structureMemberValue.setStructureValues(nestedStructureValue);
                structureMemeberValueList.add(structureMemberValue);
                continue;
            }
            if (structureMemberDefinition.isIsArray()) {
                List<StructureMemberValue> structureValueList = CCPPropertiesMerge.generateListOfPrimitiveStructureMemeberValue(flatConfig, structureMemberDefinition.getName(), configuration);
                if (structureMemberDefinition.isRequired() && (null == structureValueList || structureValueList.size() == 0)) {
                    structureValueList = CCPPropertiesMerge.generateListOfPrimitiveStructureMemeberValueFromDefaultValue(structureMemberDefinition);
                }
                if (structureMemberDefinition.isRequired() && (null == structureValueList || structureValueList.size() == 0)) {
                    logger.warn("Neither config.proeprties file nor ccpConfig.xml file contains value for: " + flatConfig);
                    continue;
                }
                structureMemeberValueList.addAll(structureValueList);
                continue;
            }
            String memberValue = CCPPropertiesMerge.getValueFromConfiguration(flatConfig, configuration);
            if (StringUtils.isEmpty((String)memberValue) && null != structureMemberDefinition.getDefaultValue() && null != structureMemberDefinition.getDefaultValue().getPrimitiveValues() && structureMemberDefinition.getDefaultValue().getPrimitiveValues().size() == 1) {
                memberValue = structureMemberDefinition.getDefaultValue().getPrimitiveValues().get(0).getValue();
            }
            if (StringUtils.isEmpty((String)memberValue)) {
                if (!structureMemberDefinition.isRequired()) continue;
                logger.warn("Neither config.proeprties file nor ccpConfig.xml file contains value for: " + flatConfig);
                continue;
            }
            structureMemberValue.setValue(memberValue);
            structureMemeberValueList.add(structureMemberValue);
            configuration.clearProperty(flatConfig);
        }
        StructureValue structureValue = new StructureValue();
        structureValue.setIndex(index);
        structureValue.setStructureMemberValues(structureMemeberValueList);
        return structureValue;
    }

    private static List<StructureMemberValue> generateListOfPrimitiveStructureMemeberValue(String flatConfigPrefix, String memberName, Configuration configuration) {
        ArrayList<StructureMemberValue> structureMemeberValueList = new ArrayList<StructureMemberValue>();
        Iterator structureMemeberArrayKeys = configuration.getKeys(flatConfigPrefix);
        while (structureMemeberArrayKeys.hasNext()) {
            String arrayKey = (String)structureMemeberArrayKeys.next();
            String index = StringUtils.substringAfter((String)arrayKey, (String)(flatConfigPrefix + paramNameSeperator));
            StructureMemberValue structureMemberValue = new StructureMemberValue();
            structureMemberValue.setIndex(index);
            structureMemberValue.setName(memberName);
            structureMemberValue.setValue(CCPPropertiesMerge.getValueFromConfiguration(flatConfigPrefix + paramNameSeperator + index, configuration));
            structureMemeberValueList.add(structureMemberValue);
            configuration.clearProperty(flatConfigPrefix + paramNameSeperator + index);
        }
        return structureMemeberValueList;
    }

    private static List<StructureMemberValue> generateListOfPrimitiveStructureMemeberValueFromDefaultValue(StructureMemberDefinition structureMemberDefinition) {
        if (null == structureMemberDefinition.getDefaultValue() || null == structureMemberDefinition.getDefaultValue().getPrimitiveValues() || structureMemberDefinition.getDefaultValue().getPrimitiveValues().size() <= 0) {
            return null;
        }
        ArrayList<StructureMemberValue> structureMemeberValueList = new ArrayList<StructureMemberValue>();
        for (PrimitiveValue primitiveValue : structureMemberDefinition.getDefaultValue().getPrimitiveValues()) {
            StructureMemberValue structureMemberValue = new StructureMemberValue();
            structureMemberValue.setIndex(primitiveValue.getIndex());
            structureMemberValue.setName(structureMemberDefinition.getName());
            structureMemberValue.setValue(primitiveValue.getValue());
            structureMemeberValueList.add(structureMemberValue);
        }
        return structureMemeberValueList;
    }

    private static String getValueFromConfiguration(String popetyName, Configuration config) {
        String value = config.getString(popetyName);
        return value;
    }
}

