/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import com.cisco.oss.foundation.configuration.xml.jaxb.Parameter;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.PrimitiveValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureMemberValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureValue;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CCPUtil {
    public static boolean equals(ParameterValue valueA, ParameterValue valueB) {
        if (valueA.getPrimitiveValues() != null && valueA.getPrimitiveValues().size() > 0) {
            if (valueB.getPrimitiveValues() == null || valueB.getPrimitiveValues().size() == 0) {
                return false;
            }
            if (valueA.getPrimitiveValues().size() != valueB.getPrimitiveValues().size()) {
                return false;
            }
            List<PrimitiveValue> primitiveValuesA = CCPUtil.sortPrimitiveValues(valueA.getPrimitiveValues());
            List<PrimitiveValue> primitiveValuesB = CCPUtil.sortPrimitiveValues(valueB.getPrimitiveValues());
            for (int i = 0; i < primitiveValuesA.size(); ++i) {
                PrimitiveValue primitiveA = primitiveValuesA.get(i);
                PrimitiveValue primitiveB = primitiveValuesB.get(i);
                if (CCPUtil.equals(primitiveA.getIndex(), primitiveB.getIndex()) && CCPUtil.equals(primitiveA.getValue(), primitiveB.getValue())) continue;
                return false;
            }
            return true;
        }
        return CCPUtil.equals(valueA.getStructureValues(), valueB.getStructureValues());
    }

    private static boolean equals(List<StructureValue> structureListA, List<StructureValue> structureListB) {
        if (null == structureListA && null == structureListB) {
            return true;
        }
        if (null == structureListA && null != structureListB || null != structureListA && null == structureListB) {
            return false;
        }
        if (structureListA.size() != structureListB.size()) {
            return false;
        }
        List<StructureValue> structureValuesA = CCPUtil.sort(structureListA);
        List<StructureValue> structureValuesB = CCPUtil.sort(structureListB);
        for (int i = 0; i < structureValuesA.size(); ++i) {
            StructureValue structureB;
            StructureValue structureA = structureValuesA.get(i);
            if (CCPUtil.equals(structureA, structureB = structureValuesB.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(StructureValue structureA, StructureValue structureB) {
        if (structureA.getIndex() != structureB.getIndex()) {
            return false;
        }
        List<StructureMemberValue> structureMemeberValueListA = structureA.getStructureMemberValues();
        List<StructureMemberValue> structureMemeberValueListB = structureB.getStructureMemberValues();
        if (null == structureMemeberValueListA && null == structureMemeberValueListB) {
            return true;
        }
        if (null == structureMemeberValueListA && null != structureMemeberValueListB || null != structureMemeberValueListA && null == structureMemeberValueListB) {
            return false;
        }
        if (structureMemeberValueListA.size() != structureMemeberValueListB.size()) {
            return false;
        }
        List<StructureMemberValue> structureMemeberValuesA = CCPUtil.sortStructureMembers(structureMemeberValueListA);
        List<StructureMemberValue> structureMemeberValuesB = CCPUtil.sortStructureMembers(structureMemeberValueListB);
        for (int i = 0; i < structureMemeberValuesA.size(); ++i) {
            StructureMemberValue structureMemberValueA = structureMemeberValuesA.get(i);
            StructureMemberValue structureMemberValueB = structureMemeberValuesB.get(i);
            if (CCPUtil.equals(structureMemberValueA.getStructureValues(), structureMemberValueB.getStructureValues()) && CCPUtil.equals(structureMemberValueA.getValue(), structureMemberValueB.getValue()) && CCPUtil.equals(structureMemberValueA.getIndex(), structureMemberValueB.getIndex())) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(String strA, String strB) {
        if (null == strA && null == strB) {
            return true;
        }
        if (null == strA && null != strB || null != strA && null == strB) {
            return false;
        }
        return strA.equals(strB);
    }

    private static List<PrimitiveValue> sortPrimitiveValues(List<PrimitiveValue> primitiveValues) {
        Collections.sort(primitiveValues, new Comparator<PrimitiveValue>(){

            @Override
            public int compare(PrimitiveValue o1, PrimitiveValue o2) {
                if (null == o1) {
                    return -1;
                }
                if (null == o2 || null == o1.getIndex()) {
                    return 1;
                }
                if (null == o2.getIndex()) {
                    return -1;
                }
                return o1.getIndex().compareTo(o2.getIndex());
            }
        });
        return primitiveValues;
    }

    private static List<StructureValue> sort(List<StructureValue> structureValues) {
        Collections.sort(structureValues, new Comparator<StructureValue>(){

            @Override
            public int compare(StructureValue o1, StructureValue o2) {
                if (null == o1) {
                    return -1;
                }
                if (null == o2 || null == o1.getIndex()) {
                    return 1;
                }
                if (null == o2.getIndex()) {
                    return -1;
                }
                return o1.getIndex().compareTo(o2.getIndex());
            }
        });
        return structureValues;
    }

    private static List<StructureMemberValue> sortStructureMembers(List<StructureMemberValue> structureMemeberValues) {
        Collections.sort(structureMemeberValues, new Comparator<StructureMemberValue>(){

            @Override
            public int compare(StructureMemberValue o1, StructureMemberValue o2) {
                if (null == o1) {
                    return -1;
                }
                if (null == o2 || null == o1.getName()) {
                    return 1;
                }
                if (null == o2.getName()) {
                    return -1;
                }
                int compareameResult = o1.getName().compareTo(o2.getName());
                if (compareameResult != 0) {
                    return compareameResult;
                }
                if (null == o1.getIndex()) {
                    return 1;
                }
                if (null == o2.getIndex()) {
                    return -1;
                }
                return o1.getIndex().compareTo(o2.getIndex());
            }
        });
        return structureMemeberValues;
    }

    public static Parameter clone(Parameter parameter) {
        Parameter clonedParameter = new Parameter();
        clonedParameter.setAdvanced(parameter.isAdvanced());
        clonedParameter.setBase(parameter.getBase());
        clonedParameter.setDefaultInstantiationLevelId(parameter.getDefaultInstantiationLevelId());
        clonedParameter.setDefaultValue(parameter.getDefaultValue());
        clonedParameter.setHidden(parameter.isHidden());
        clonedParameter.setInstantiationLevel(parameter.getInstantiationLevel());
        clonedParameter.setInstantiationLevelId(parameter.getInstantiationLevelId());
        clonedParameter.setInstantiationLevelName(parameter.getInstantiationLevelName());
        clonedParameter.setIsArray(parameter.isIsArray());
        clonedParameter.setName(parameter.getName());
        clonedParameter.setParamId(parameter.getParamId());
        clonedParameter.setReadOnly(parameter.isReadOnly());
        clonedParameter.setRequired(parameter.isRequired());
        clonedParameter.setRequiresRestart(parameter.isRequiresRestart());
        clonedParameter.setStructureDefinition(parameter.getStructureDefinition());
        clonedParameter.setType(parameter.getType());
        clonedParameter.setUnit(parameter.getUnit());
        return clonedParameter;
    }
}

