/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import com.cisco.oss.foundation.configuration.ConfigurationFactory;
import com.cisco.oss.foundation.environment.utils.EnvUtils;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;

public final class ConfigUtil {
    private static final Pattern HEX_REGEX_PATTERN = Pattern.compile("^[A-Fa-f0-9]+$");
    private static final char DECIMAL_SEP = DecimalFormatSymbols.getInstance().getDecimalSeparator();

    private ConfigUtil() {
    }

    public static HierarchicalConfiguration getHierarchicalConfiguration(Configuration configuration) {
        if (configuration instanceof CompositeConfiguration) {
            CompositeConfiguration compositeConfig = (CompositeConfiguration)configuration;
            for (int i = 0; i < compositeConfig.getNumberOfConfigurations(); ++i) {
                if (!(compositeConfig.getConfiguration(i) instanceof HierarchicalConfiguration)) continue;
                return (HierarchicalConfiguration)compositeConfig.getConfiguration(i);
            }
        }
        return null;
    }

    public static Configuration createCompositeConfiguration(Class<?> clazz, Configuration configuration) {
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
        Configuration defaultConfiguration = ConfigurationFactory.getDefaultConfiguration();
        if (configuration != null) {
            compositeConfiguration.addConfiguration(configuration);
        }
        compositeConfiguration.addConfiguration(defaultConfiguration);
        return compositeConfiguration;
    }

    public static void enableCcp(String componentName, String componentVersion, String installPath, String compoentHostName, String ccpServerHostName) {
        ConfigUtil.enableCcp(componentName, componentVersion, installPath, compoentHostName, ccpServerHostName, 5670);
    }

    public static void enableCcp(String componentName, String componentVersion, String installPath, String compoentHostName, String ccpServerHostName, int ccpServerPort) {
        EnvUtils.updateEnv((String)"_CCP_ENABLED", (String)"true");
        EnvUtils.updateEnv((String)"_FQDN", (String)compoentHostName);
        EnvUtils.updateEnv((String)"_RPM_SOFTWARE_NAME", (String)compoentHostName);
        EnvUtils.updateEnv((String)"_ARTIFACT_VERSION", (String)componentVersion);
        EnvUtils.updateEnv((String)"_INSTALL_DIR", (String)installPath);
        EnvUtils.updateEnv((String)"_CCP_SERVER", (String)(ccpServerHostName + ":" + ccpServerPort));
    }

    public static void disableCcp() {
        EnvUtils.updateEnv((String)"_CCP_ENABLED", (String)"false");
    }

    public static Map<String, Map<String, String>> parseComplexArrayStructure(String configPrefix) {
        Configuration configuration = ConfigurationFactory.getConfiguration();
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        Configuration subset = configuration.subset(configPrefix);
        Iterator keys = subset.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String mapKey = ConfigUtil.stripKey(key);
            if (mapKey == null) continue;
            if (!result.containsKey(mapKey)) {
                result.put(mapKey, new HashMap());
            }
            String innerMapKey = ConfigUtil.getInnerMapKey(key);
            ((Map)result.get(mapKey)).put(innerMapKey, subset.getString(key));
        }
        return result;
    }

    public static Map<String, String> parseSimpleArrayAsMap(String configPrefix) {
        Configuration configuration = ConfigurationFactory.getConfiguration();
        return ConfigUtil.parseSimpleArrayAsMap(configuration, configPrefix);
    }

    public static Map<String, String> parseSimpleArrayAsMap(Configuration configuration, String configPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        Configuration subset = configuration.subset(configPrefix);
        Iterator keys = subset.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            result.put(key, subset.getString(key));
        }
        return result;
    }

    private static String getInnerMapKey(String key) {
        int index = key.indexOf(".");
        return key.substring(index + 1);
    }

    private static String stripKey(String key) {
        int index = key.indexOf(".");
        if (index > 0) {
            return key.substring(0, index);
        }
        return null;
    }

    public static boolean isNumeric(String value) {
        return ConfigUtil.isNumeric(value, 0, -1);
    }

    public static boolean isNumeric(String value, int startIndex, int endIndex) {
        if (value == null) {
            return false;
        }
        if (endIndex < 0) {
            endIndex = value.length();
        }
        boolean hadDecimalSep = false;
        for (int i = startIndex; i < endIndex; ++i) {
            char c = value.charAt(i);
            if (c == DECIMAL_SEP) {
                if (hadDecimalSep) {
                    return false;
                }
                hadDecimalSep = true;
                continue;
            }
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value.getClass() == String.class) {
            return ConfigUtil.isEmpty(value.toString());
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() == 0;
        }
        return false;
    }

    public static boolean isEmpty(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexadecimal(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return HEX_REGEX_PATTERN.matcher(value).matches();
    }

    public static Double toNumber(String value) {
        return ConfigUtil.toNumber(value, 0, -1);
    }

    public static Double toNumber(String value, int startIndex, int endIndex) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (endIndex < 0) {
            endIndex = value.length();
        }
        if (startIndex > 0 || endIndex < value.length()) {
            value = value.substring(startIndex, endIndex);
        }
        try {
            Double dbl = Double.parseDouble(value);
            if (dbl.isNaN()) {
                return null;
            }
            return dbl;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static boolean equalValues(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static URL getResource(String fileName) {
        return ConfigUtil.class.getResource(fileName);
    }

    public static String getResourcePath(String fileName) {
        URL url = ConfigUtil.getResource(fileName);
        if (url == null) {
            return null;
        }
        try {
            return url.toURI().getPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String fileName) {
        return ConfigUtil.class.getResourceAsStream(fileName);
    }
}

