/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration.validation;

import com.cisco.oss.foundation.configuration.ConfigUtil;
import com.cisco.oss.foundation.configuration.FoundationConfigurationListener;
import com.cisco.oss.foundation.configuration.FoundationConfigurationListenerRegistry;
import com.cisco.oss.foundation.configuration.validation.exceptions.GeneralConfigException;
import com.cisco.oss.foundation.configuration.validation.params.Param;
import com.cisco.oss.foundation.configuration.validation.params.ParamFactory;
import com.cisco.oss.foundation.configuration.validation.params.ParamListFactory;
import com.cisco.oss.foundation.configuration.validation.params.ParamReaders;
import com.cisco.oss.foundation.configuration.validation.params.ParamSetFactory;
import com.cisco.oss.foundation.configuration.validation.params.SimpleParamFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.configuration.Configuration;

public class BaseConfiguration
implements FoundationConfigurationListener {
    private static boolean enableStaticConfiguration = true;
    private static final ArrayList<Param> parameters = new ArrayList();
    private static final CopyOnWriteArraySet<ConfigChangeListener> configChangeListeners = new CopyOnWriteArraySet();
    protected Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        ParamReaders.getInstance().setConfiguration(configuration);
        FoundationConfigurationListenerRegistry.addFoundationConfigurationListener(this);
        this.verifyConfiguration();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void verifyConfiguration() {
        for (Param param : parameters) {
            this.readAndValidateParameter(param);
        }
    }

    private void readAndValidateParameter(Param param) {
        try {
            param.readValue();
            param.validate();
        }
        catch (GeneralConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GeneralConfigException("Configured value for '" + param.getName() + "' is invalid!", ex);
        }
    }

    public void addConfigurationChangeListener(ConfigChangeListener listener) {
        configChangeListeners.add(listener);
    }

    @Override
    public void configurationChanged() {
        HashSet<Param> changedParams = new HashSet<Param>();
        for (Param param : parameters) {
            if (param.isStatic()) continue;
            Object oldValue = param.getValue();
            this.readAndValidateParameter(param);
            if (ConfigUtil.equalValues(oldValue, param.getValue())) continue;
            changedParams.add(param);
        }
        if (!changedParams.isEmpty()) {
            for (ConfigChangeListener listener : configChangeListeners) {
                listener.configurationChanged(changedParams);
            }
        }
    }

    public static boolean isEnableStaticConfiguration() {
        return enableStaticConfiguration;
    }

    public void setEnableStaticConfiguration(boolean enableStaticConfiguration) {
        BaseConfiguration.enableStaticConfiguration = enableStaticConfiguration;
    }

    public static void addParameter(Param param) {
        parameters.add(param);
    }

    public static SimpleParamFactory staticParam() {
        return ParamFactory.staticFactory;
    }

    public static SimpleParamFactory dynamicParam() {
        return ParamFactory.dynamicFactory;
    }

    public static ParamListFactory staticParamList() {
        return ParamFactory.listStaticFactory;
    }

    public static ParamListFactory dynamicParamList() {
        return ParamFactory.listDynamicFactory;
    }

    public static ParamSetFactory staticParamSet() {
        return ParamFactory.setStaticFactory;
    }

    public static ParamSetFactory dynamicParamSet() {
        return ParamFactory.setDynamicFactory;
    }

    public static interface ConfigChangeListener {
        public void configurationChanged(HashSet<Param> var1);
    }
}

