/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration.validation.params;

import com.cisco.oss.foundation.configuration.validation.BaseConfiguration;
import com.cisco.oss.foundation.configuration.validation.params.ParamReaders;
import com.cisco.oss.foundation.configuration.validation.params.ParamValidators;
import com.cisco.oss.foundation.configuration.validation.params.ParamValueInterceptor;

public class Param<T> {
    private String name;
    private T value;
    private T defValue;
    private boolean staticParam;
    private ParamReaders.ParamReader<T> reader;
    private ParamValidators.ParamValidator<T> validator;
    private ParamValueInterceptor<T> valueInterceptor = null;

    public Param(ParamReaders.ParamReader<T> reader, String name) {
        this(reader, name, null);
    }

    public Param(ParamReaders.ParamReader<T> reader, String name, T defValue) {
        this(reader, name, defValue, null);
    }

    public Param(ParamReaders.ParamReader<T> reader, String name, T defValue, ParamValidators.ParamValidator<T> validator) {
        this.name = name;
        this.defValue = defValue;
        this.reader = reader;
        this.validator = validator;
        if (defValue == null && validator == null) {
            this.validator = ParamValidators.ParamValidator.instance(true);
        }
        BaseConfiguration.addParameter(this);
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        if (!BaseConfiguration.isEnableStaticConfiguration()) {
            this.readValue();
        }
        return this.value;
    }

    public void readValue() {
        this.value = this.defValue == null ? this.reader.readValue(this.name) : this.reader.readValue(this.name, this.defValue);
        if (this.valueInterceptor != null) {
            this.value = this.valueInterceptor.onValueRead(this.value);
        }
    }

    public Param<T> setValueInterceptor(ParamValueInterceptor<T> valueInterceptor) {
        this.valueInterceptor = valueInterceptor;
        return this;
    }

    public boolean isStatic() {
        return this.staticParam;
    }

    public void setStatic(boolean staticParam) {
        this.staticParam = staticParam;
    }

    public void validate() {
        if (this.validator != null) {
            this.validator.validate(this.name, this.value);
        }
    }
}

