/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration.validation.params;

import com.cisco.oss.foundation.configuration.validation.params.Param;
import com.cisco.oss.foundation.configuration.validation.params.ParamListFactory;
import com.cisco.oss.foundation.configuration.validation.params.ParamReaders;
import com.cisco.oss.foundation.configuration.validation.params.ParamSetFactory;
import com.cisco.oss.foundation.configuration.validation.params.ParamValidators;
import com.cisco.oss.foundation.configuration.validation.params.SimpleParamFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ParamFactory {
    public static final SimpleParamFactory staticFactory = new SimpleParamFactory(ParamType.Static);
    public static final SimpleParamFactory dynamicFactory = new SimpleParamFactory(ParamType.Dynamic);
    public static final ParamListFactory listStaticFactory = new ParamListFactory(ParamType.Static);
    public static final ParamListFactory listDynamicFactory = new ParamListFactory(ParamType.Dynamic);
    public static final ParamSetFactory setStaticFactory = new ParamSetFactory(ParamType.Static);
    public static final ParamSetFactory setDynamicFactory = new ParamSetFactory(ParamType.Dynamic);
    private ParamType paramType;

    protected ParamFactory(ParamType paramType) {
        this.paramType = paramType;
    }

    protected Param getParam(ParamReaders.ParamReader reader, String name) {
        return this.getParam(new Param(reader, name));
    }

    protected Param getParam(ParamReaders.ParamReader reader, String name, Object defValue) {
        return this.getParam(new Param<Object>(reader, name, defValue));
    }

    protected Param getParam(ParamReaders.ParamReader reader, String name, Object defValue, ParamValidators.ParamValidator validator) {
        return this.getParam(new Param<Object>(reader, name, defValue, validator));
    }

    private Param getParam(Param param) {
        param.setStatic(this.paramType == ParamType.Static);
        return param;
    }

    protected <T> List<T> toList(T value) {
        if (value == null) {
            return null;
        }
        return Arrays.asList(value);
    }

    protected <T> List<T> toList(T ... values) {
        if (values.length == 0 || values[0] == null) {
            return null;
        }
        return Arrays.asList(values);
    }

    protected <T, C extends Collection<T>> ParamValidators.ParamListValidator<T, C> getListValidator(ParamValidators.ParamValidator<T> validator) {
        if (validator == null) {
            return null;
        }
        return new ParamValidators.ParamListValidator(validator);
    }

    protected static enum ParamType {
        Dynamic,
        Static;

    }
}

