/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration.validation.params;

import com.cisco.oss.foundation.configuration.ConfigUtil;
import com.cisco.oss.foundation.configuration.validation.exceptions.GeneralConfigException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration.Configuration;

public class ParamReaders {
    public static final Class SET_CLASS = LinkedHashSet.class;
    private static final ParamReaders instance = new ParamReaders();
    private static final KeysComparator keysComparator = new KeysComparator();
    private static final Object[] emptyObjectArray = new Object[0];
    private static final Class[] emptyClassArray = new Class[0];
    public static final StringReader stringReader = new StringReader();
    public static final LongReader longReader = new LongReader();
    public static final IntReader intReader = new IntReader();
    public static final BooleanReader booleanReader = new BooleanReader();
    public static final FloatReader floatReader = new FloatReader();
    public static final DoubleReader doubleReader = new DoubleReader();
    public static final ShortReader shortReader = new ShortReader();
    public static final ByteReader byteReader = new ByteReader();
    public static final SetReader<String> stringSetReader = new SetReader<String>(SET_CLASS, stringReader);
    public static final SetReader<Long> longSetReader = new SetReader<Long>(SET_CLASS, longReader);
    public static final SetReader<Integer> intSetReader = new SetReader<Integer>(SET_CLASS, intReader);
    public static final SetReader<Boolean> booleanSetReader = new SetReader<Boolean>(SET_CLASS, booleanReader);
    public static final SetReader<Float> floatSetReader = new SetReader<Float>(SET_CLASS, floatReader);
    public static final SetReader<Double> doubleSetReader = new SetReader<Double>(SET_CLASS, doubleReader);
    public static final SetReader<Short> shortSetReader = new SetReader<Short>(SET_CLASS, shortReader);
    public static final SetReader<Byte> byteSetReader = new SetReader<Byte>(SET_CLASS, byteReader);
    public static final ListReader<String> stringListReader = new ListReader<String>(stringReader);
    public static final ListReader<Long> longListReader = new ListReader<Long>(longReader);
    public static final ListReader<Integer> intListReader = new ListReader<Integer>(intReader);
    public static final ListReader<Boolean> booleanListReader = new ListReader<Boolean>(booleanReader);
    public static final ListReader<Float> floatListReader = new ListReader<Float>(floatReader);
    public static final ListReader<Double> doubleListReader = new ListReader<Double>(doubleReader);
    public static final ListReader<Short> shortListReader = new ListReader<Short>(shortReader);
    public static final ListReader<Byte> byteListReader = new ListReader<Byte>(byteReader);
    private Configuration configuration;

    private ParamReaders() {
    }

    public static ParamReaders getInstance() {
        return instance;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private static Configuration config() {
        return ParamReaders.instance.configuration;
    }

    private static <V> TreeMap<String, V> getValuesMap(String prefix, ParamReader<V> reader) {
        TreeMap<String, V> map = null;
        Iterator iter = ParamReaders.config().getKeys(prefix);
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (map == null) {
                map = new TreeMap<String, V>(keysComparator);
            }
            map.put(key, reader.readValue(key));
        }
        return map;
    }

    public static class KeysComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2 || o1.equals(o2)) {
                return 0;
            }
            int indexOf1 = o1.lastIndexOf(".");
            if (indexOf1 < 0) {
                return o1.compareTo(o2);
            }
            int indexOf2 = o2.lastIndexOf(".");
            if (indexOf2 < 0) {
                return o1.compareTo(o2);
            }
            if (ConfigUtil.isNumeric(o1, ++indexOf1, -1) && ConfigUtil.isNumeric(o2, ++indexOf2, -1)) {
                Double n1 = ConfigUtil.toNumber(o1, indexOf1, -1);
                Double n2 = ConfigUtil.toNumber(o2, indexOf2, -1);
                if (n1 == null || n2 == null) {
                    return o1.compareTo(o2);
                }
                return n1.compareTo(n2);
            }
            return o1.compareTo(o2);
        }
    }

    public static class MethodReader<T>
    implements ParamReader<T> {
        private Object invoker;
        private String methodName;
        private Object[] args;
        private Class[] argsClass;

        public MethodReader(Object invoker, String methodName) {
            this(invoker, methodName, emptyObjectArray);
        }

        public MethodReader(Object invoker, String methodName, Object ... args) {
            this.invoker = invoker;
            this.methodName = methodName;
            this.args = args;
            if (args.length == 0) {
                this.argsClass = emptyClassArray;
            } else {
                this.argsClass = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    this.argsClass[i] = args[i].getClass();
                }
            }
        }

        @Override
        public T readValue(String name) {
            try {
                Class clazz = this.invoker.getClass();
                Object instance = this.invoker;
                if (this.invoker.getClass() == Class.class) {
                    clazz = (Class)this.invoker;
                    instance = null;
                }
                return (T)clazz.getMethod(this.methodName, this.argsClass).invoke(instance, this.args);
            }
            catch (Throwable e) {
                GeneralConfigException.convertToRuntimeException(e);
                return null;
            }
        }

        @Override
        public T readValue(String name, T defValue) {
            T value = this.readValue(name);
            if (value == null) {
                return defValue;
            }
            return value;
        }
    }

    public static class ListReader<V>
    implements ParamReader<List<V>> {
        private ParamReader<V> reader;

        public ListReader(ParamReader<V> reader) {
            this.reader = reader;
        }

        @Override
        public List<V> readValue(String name) {
            List<V> list = this.readValue(name, null);
            if (list == null) {
                list = new ArrayList<V>();
            }
            return list;
        }

        @Override
        public List<V> readValue(String name, List defValue) {
            TreeMap map = ParamReaders.getValuesMap(name, this.reader);
            if (map == null || map.size() == 0) {
                return defValue;
            }
            Collection values = map.values();
            if (values instanceof List) {
                return (List)values;
            }
            ArrayList list = new ArrayList(values.size());
            list.addAll(values);
            return list;
        }
    }

    public static class SetReader<V>
    implements ParamReader<Set<V>> {
        private Class<? extends Set<V>> set;
        private ParamReader<V> reader;

        public SetReader(Class<? extends Set<V>> set, ParamReader<V> reader) {
            this.set = set;
            this.reader = reader;
        }

        @Override
        public Set<V> readValue(String name) {
            Set<V> valueSet = this.readValue(name, null);
            if (valueSet == null) {
                valueSet = this.factorSetInstance();
            }
            return valueSet;
        }

        @Override
        public Set<V> readValue(String name, Set defValue) {
            TreeMap map = ParamReaders.getValuesMap(name, this.reader);
            if (map == null || map.size() == 0) {
                return defValue;
            }
            Set<V> valueSet = this.factorSetInstance();
            valueSet.addAll(map.values());
            return valueSet;
        }

        private Set<V> factorSetInstance() {
            try {
                return this.set.newInstance();
            }
            catch (Exception e) {
                GeneralConfigException.convertToRuntimeException(e);
                return null;
            }
        }
    }

    public static class ByteReader
    implements ParamReader<Byte> {
        @Override
        public Byte readValue(String name) {
            return ParamReaders.config().getByte(name);
        }

        @Override
        public Byte readValue(String name, Byte defValue) {
            return ParamReaders.config().getByte(name, defValue);
        }
    }

    public static class ShortReader
    implements ParamReader<Short> {
        @Override
        public Short readValue(String name) {
            return ParamReaders.config().getShort(name);
        }

        @Override
        public Short readValue(String name, Short defValue) {
            return ParamReaders.config().getShort(name, defValue);
        }
    }

    public static class DoubleReader
    implements ParamReader<Double> {
        @Override
        public Double readValue(String name) {
            return ParamReaders.config().getDouble(name);
        }

        @Override
        public Double readValue(String name, Double defValue) {
            return ParamReaders.config().getDouble(name, defValue);
        }
    }

    public static class FloatReader
    implements ParamReader<Float> {
        @Override
        public Float readValue(String name) {
            return Float.valueOf(ParamReaders.config().getFloat(name));
        }

        @Override
        public Float readValue(String name, Float defValue) {
            return ParamReaders.config().getFloat(name, defValue);
        }
    }

    public static class BooleanReader
    implements ParamReader<Boolean> {
        @Override
        public Boolean readValue(String name) {
            return ParamReaders.config().getBoolean(name);
        }

        @Override
        public Boolean readValue(String name, Boolean defValue) {
            return ParamReaders.config().getBoolean(name, defValue);
        }
    }

    public static class StringReader
    implements ParamReader<String> {
        @Override
        public String readValue(String name) {
            return ParamReaders.config().getString(name);
        }

        @Override
        public String readValue(String name, String defValue) {
            return ParamReaders.config().getString(name, defValue);
        }
    }

    public static class IntReader
    implements ParamReader<Integer> {
        @Override
        public Integer readValue(String name) {
            return ParamReaders.config().getInt(name);
        }

        @Override
        public Integer readValue(String name, Integer defValue) {
            return ParamReaders.config().getInt(name, defValue.intValue());
        }
    }

    public static class LongReader
    implements ParamReader<Long> {
        @Override
        public Long readValue(String name) {
            return ParamReaders.config().getLong(name);
        }

        @Override
        public Long readValue(String name, Long defValue) {
            return ParamReaders.config().getLong(name, defValue);
        }
    }

    public static interface ParamReader<T> {
        public T readValue(String var1);

        public T readValue(String var1, T var2);
    }
}

