/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration.validation.params;

import com.cisco.oss.foundation.configuration.ConfigUtil;
import com.cisco.oss.foundation.configuration.validation.exceptions.ValidationConfigException;
import com.cisco.oss.foundation.configuration.validation.params.Param;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class ParamValidators {
    private static final ConcurrentHashMap<Class, List<ParamValidator>> validatorsMap = ParamValidators.getValidatorsMap();

    private static ConcurrentHashMap<Class, List<ParamValidator>> getValidatorsMap() {
        ConcurrentHashMap<Class, List<ParamValidator>> map = new ConcurrentHashMap<Class, List<ParamValidator>>();
        ParamValidators.addValidators(map, ParamValidator.class, new ParamValidator(true), new ParamValidator(false));
        ParamValidators.addValidators(map, FileValidator.class, new FileValidator(true), new FileValidator(false));
        ParamValidators.addValidators(map, URLValidator.class, new URLValidator(true), new URLValidator(false));
        ParamValidators.addValidators(map, HEXValidator.class, new HEXValidator(true), new HEXValidator(false));
        return map;
    }

    private static <T extends ParamValidator> void addValidators(ConcurrentHashMap<Class, List<ParamValidator>> map, Class<T> clazz, T requiredValidator, T noneRequiredValidator) {
        CopyOnWriteArrayList<ParamValidator> validators = new CopyOnWriteArrayList<ParamValidator>(new ParamValidator[]{requiredValidator, noneRequiredValidator});
        map.put(clazz, validators);
    }

    public static <E, T extends ParamValidator<E>> T getValidator(Class<T> clazz, Param<Boolean> param) {
        List<ParamValidator> validators = validatorsMap.get(clazz);
        if (validators == null) {
            ParamValidators.addValidators(validatorsMap, clazz, null, null);
        }
        for (int i = 2; i < validators.size(); ++i) {
            ParamValidator validator = validators.get(i);
            if (validator.getClass() != ParamValidatorWrapper.class || ((ParamValidatorWrapper)validator).ifParam != param) continue;
            return (T)validator;
        }
        ParamValidatorWrapper validator = new ParamValidatorWrapper(clazz, param);
        validators.add(validator);
        return (T)validator;
    }

    public static <T extends ParamValidator> T getValidator(Class<T> clazz, boolean required) {
        List<ParamValidator> validators = validatorsMap.get(clazz);
        if (validators != null) {
            if (required) {
                return (T)validators.get(0);
            }
            return (T)validators.get(1);
        }
        return null;
    }

    public static class ParamListValidator<T, E extends Collection<T>>
    extends ParamValidator<E> {
        private ParamValidator<T> validator;

        public ParamListValidator(ParamValidator<T> validator) {
            this(validator, validator.required);
        }

        public ParamListValidator(ParamValidator<T> validator, boolean required) {
            super(required);
            this.validator = validator;
        }

        @Override
        public void validate(String name, E list) {
            if (this.validateAndReturnIfEmpty(name, list)) {
                return;
            }
            for (Object value : list) {
                this.validator.validate(name, value);
            }
        }
    }

    public static class HEXValidator
    extends ParamValidator<String> {
        private int maxLength;
        private boolean lengthInBits;
        private boolean exactLength;
        private double maxValue = -1.0;

        public static ParamValidator instance(boolean required) {
            return ParamValidators.getValidator(HEXValidator.class, required);
        }

        public static ParamValidator instance(Param<Boolean> param) {
            return ParamValidators.getValidator(HEXValidator.class, param);
        }

        private HEXValidator(boolean required) {
            this(required, -1, false, false);
        }

        public HEXValidator(boolean required, int maxLength, boolean lengthInBits, boolean exactLength) {
            super(required);
            this.maxLength = maxLength;
            this.lengthInBits = lengthInBits;
            this.exactLength = exactLength;
        }

        public HEXValidator(boolean required, double maxValue) {
            this(required);
            this.maxValue = maxValue;
        }

        @Override
        public void validate(String name, String value) {
            if (this.validateAndReturnIfEmpty(name, value)) {
                return;
            }
            String errMsg = null;
            errMsg = this.maxValue > -1.0 ? HEXValidator.validateHexValue(value, this.maxValue) : HEXValidator.validateHexValue(value, this.maxLength, this.lengthInBits, this.exactLength);
            if (errMsg != null) {
                throw new ValidationConfigException(errMsg + " (Parameter: " + name + ")");
            }
        }

        public static String validateHexValue(String hexValue, int maxLength, boolean lengthInBits, boolean exactLength) {
            if (!ConfigUtil.isHexadecimal(hexValue)) {
                return "'" + hexValue + "' is not a valid hexadecimal value.";
            }
            if (maxLength < 0) {
                return null;
            }
            if (lengthInBits) {
                byte[] bytes = null;
                try {
                    bytes = Hex.decodeHex((char[])hexValue.toCharArray());
                }
                catch (DecoderException e) {
                    return "'" + hexValue + "' hexadecimal value cannot be converted to bits.";
                }
                int bitsLen = 8 * bytes.length;
                if (exactLength && bitsLen != maxLength) {
                    return "'" + hexValue + "' hexadecimal length should be exactly " + maxLength + " bits.";
                }
                if (!exactLength && bitsLen > maxLength) {
                    return "'" + hexValue + "' exceeds number of hexadecimal bits [" + maxLength + "].";
                }
            } else if (exactLength) {
                if (hexValue.length() != maxLength) {
                    return "'" + hexValue + "' hexadecimal length should be exactly " + maxLength + " characters";
                }
            } else if (hexValue.length() > maxLength) {
                return "'" + hexValue + "' exceeds number of hexadecimal characters [" + maxLength + "].";
            }
            return null;
        }

        public static String validateHexValue(String hexValue) {
            return HEXValidator.validateHexValue(hexValue, -1, false, false);
        }

        public static String validateHexValue(String hexValue, double maxValue) {
            String errMsg = HEXValidator.validateHexValue(hexValue);
            if (errMsg != null) {
                return errMsg;
            }
            BigInteger longValue = new BigInteger(hexValue, 16);
            if (longValue.doubleValue() > maxValue) {
                return "'" + longValue + "' exceeds maximum value [" + new BigDecimal(maxValue).toString() + "].";
            }
            return null;
        }
    }

    public static class URLValidator
    extends ParamValidator<String> {
        public static ParamValidator instance(boolean required) {
            return ParamValidators.getValidator(URLValidator.class, required);
        }

        public static ParamValidator instance(Param<Boolean> param) {
            return ParamValidators.getValidator(URLValidator.class, param);
        }

        private URLValidator(boolean required) {
            super(required);
        }

        @Override
        public void validate(String name, String value) {
            if (this.validateAndReturnIfEmpty(name, value)) {
                return;
            }
            try {
                URL url = new URL(value);
            }
            catch (MalformedURLException e) {
                throw new ValidationConfigException("'" + value + "' is not a valid URL (Parameter: " + name + ")");
            }
        }
    }

    public static class FileValidator
    extends ParamValidator<String> {
        public static ParamValidator instance(boolean required) {
            return ParamValidators.getValidator(FileValidator.class, required);
        }

        public static ParamValidator instance(Param<Boolean> param) {
            return ParamValidators.getValidator(FileValidator.class, param);
        }

        private FileValidator(boolean required) {
            super(required);
        }

        @Override
        public void validate(String name, String value) {
            if (this.validateAndReturnIfEmpty(name, value)) {
                return;
            }
            URL url = ConfigUtil.getResource(value);
            if (url == null) {
                throw new ValidationConfigException("File '" + value + "' cannot be found (Parameter: " + name + ")");
            }
        }
    }

    public static class ParamValidatorWrapper<T>
    extends ParamValidator<T> {
        private Class validatorType;
        private Param ifParam;
        private Object ifValue;
        private boolean byBooleanParam = false;

        private ParamValidatorWrapper(Class validatorType, Param<Boolean> param) {
            super(false);
            this.validatorType = validatorType;
            this.ifParam = param;
            this.byBooleanParam = true;
        }

        private ParamValidatorWrapper(Class<T> validatorType, Param<T> ifParam, T ifValue, boolean required) {
            super(required);
            this.validatorType = validatorType;
            this.required = required;
            this.ifValue = ifValue;
            this.ifParam = ifParam;
        }

        @Override
        public void validate(String name, T value) {
            ParamValidator validator = null;
            if (this.byBooleanParam) {
                validator = (ParamValidator)ParamValidators.getValidator(this.validatorType, (Boolean)this.ifParam.getValue());
            } else if (ConfigUtil.equalValues(this.ifParam.getValue(), this.ifValue)) {
                validator = (ParamValidator)ParamValidators.getValidator(this.validatorType, this.required);
            }
            if (validator != null) {
                validator.validate(name, value);
            }
        }
    }

    public static class ParamValidator<T> {
        protected boolean required;

        public static ParamValidator instance(boolean required) {
            return ParamValidators.getValidator(ParamValidator.class, required);
        }

        public static ParamValidator instance(Param<Boolean> param) {
            return ParamValidators.getValidator(ParamValidator.class, param);
        }

        private ParamValidator(boolean required) {
            this.required = required;
        }

        public void validate(String name, T value) {
            this.validateAndReturnIfEmpty(name, value);
        }

        protected boolean validateAndReturnIfEmpty(String name, T value) {
            if (ConfigUtil.isEmpty(value)) {
                if (this.required) {
                    throw new ValidationConfigException("Required parameter value is empty: " + name);
                }
                return true;
            }
            return false;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

