/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration.xml;

import com.cisco.oss.foundation.configuration.xml.Namespace;
import com.cisco.oss.foundation.configuration.xml.XmlException;
import com.cisco.oss.foundation.configuration.xml.XmlParser;
import com.cisco.oss.foundation.configuration.xml.jaxb.NamespaceDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.NamespaceDefinitions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamespaceDefinitionMessage {
    private String xml = null;
    private NamespaceDefinitions jaxb = null;
    private XmlParser parser = new XmlParser();

    public NamespaceDefinitionMessage(String xml) throws XmlException {
        this.jaxb = this.unmarshall(xml);
        this.xml = xml;
    }

    public NamespaceDefinitionMessage(NamespaceDefinitions jaxb) throws XmlException {
        this.xml = this.marshall(jaxb);
        this.jaxb = jaxb;
    }

    public String toXml() {
        return this.xml;
    }

    public NamespaceDefinitions jaxb() {
        return this.jaxb;
    }

    protected String marshall(NamespaceDefinitions jaxb) throws XmlException {
        return this.parser.marshall(jaxb);
    }

    protected NamespaceDefinitions unmarshall(String xml) throws XmlException {
        NamespaceDefinitions jaxb = null;
        try {
            jaxb = (NamespaceDefinitions)this.parser.unmarshall(xml);
        }
        catch (ClassCastException e) {
            throw new XmlException("The given message was not a NamespaceDefinitions Message - ClassCastException: " + e.getMessage(), e);
        }
        return jaxb;
    }

    public List<NamespaceDefinition> sortByDependencies() throws XmlException {
        ArrayList<NamespaceDefinition> sorted = new ArrayList<NamespaceDefinition>();
        Map<Namespace, List<String>> namespaceMap = this.createNamespaceMap(this.jaxb.getNamespaceDefinitions());
        NamespaceDefinition def = null;
        do {
            if ((def = this.extractNamespaceWithLeastDependencies(namespaceMap)) == null) continue;
            sorted.add(def);
        } while (def != null);
        return sorted;
    }

    protected NamespaceDefinition extractNamespaceWithLeastDependencies(Map<Namespace, List<String>> namespaceMap) {
        if (namespaceMap == null || namespaceMap.keySet().size() == 0) {
            return null;
        }
        Namespace lowest = null;
        int lowestSize = Integer.MAX_VALUE;
        for (Namespace current : namespaceMap.keySet()) {
            int currentSize = namespaceMap.get(current).size();
            if (lowest != null && currentSize >= lowestSize) continue;
            lowest = current;
            lowestSize = currentSize;
        }
        namespaceMap.remove(lowest);
        return lowest.getNamespaceDefinition();
    }

    protected Map<Namespace, List<String>> createNamespaceMap(List<NamespaceDefinition> namespaceDefs) throws XmlException {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (NamespaceDefinition namespaceDef : namespaceDefs) {
            Namespace node = new Namespace(namespaceDef);
            if (namespaces.contains(node)) {
                throw new XmlException("duplicate NamespaceDefinitions found: " + node.getId());
            }
            namespaces.add(node);
        }
        for (Namespace namespace : namespaces) {
            List<String> dependencyIds = namespace.getDirectDependencyIds();
            for (String id : dependencyIds) {
                if (this.find(namespaces, id) != null) continue;
                throw new XmlException("Found missing dependency: " + id);
            }
        }
        HashMap<Namespace, List<String>> namespaceFullDependencyMap = new HashMap<Namespace, List<String>>();
        for (Namespace namespace : namespaces) {
            ArrayList<String> fullDependencies = new ArrayList<String>();
            for (String directDependencyId : namespace.getDirectDependencyIds()) {
                this.addDependenciesRecursively(namespace, namespaces, directDependencyId, fullDependencies);
            }
            namespaceFullDependencyMap.put(namespace, fullDependencies);
        }
        return namespaceFullDependencyMap;
    }

    protected void addDependenciesRecursively(Namespace namespace, List<Namespace> namespaceList, String dependencyId, List<String> extendedDependencies) throws XmlException {
        if (extendedDependencies.contains(dependencyId)) {
            return;
        }
        if (namespace.getId().equals(dependencyId)) {
            throw new XmlException("Circular dependency found in " + namespace.getId());
        }
        Namespace dependency = this.find(namespaceList, dependencyId);
        extendedDependencies.add(dependency.getId());
        for (String indirectDependencyId : dependency.getDirectDependencyIds()) {
            this.addDependenciesRecursively(namespace, namespaceList, indirectDependencyId, extendedDependencies);
        }
    }

    private Namespace find(List<Namespace> namespaces, String id) throws XmlException {
        for (Namespace namespace : namespaces) {
            if (!namespace.getId().equals(id)) continue;
            return namespace;
        }
        return null;
    }
}

