/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import com.cisco.oss.foundation.configuration.xml.ConfigurationResponseMessage;
import com.cisco.oss.foundation.configuration.xml.NamespaceDefinitionMessage;
import com.cisco.oss.foundation.configuration.xml.XmlException;
import com.cisco.oss.foundation.configuration.xml.jaxb.ConfigurationResponse;
import com.cisco.oss.foundation.configuration.xml.jaxb.NamespaceDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.NamespaceParameters;
import com.cisco.oss.foundation.configuration.xml.jaxb.Parameter;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterKind;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterType;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.PrimitiveValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureMemberDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureMemberValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureValue;
import com.cisco.oss.foundation.http.HttpClient;
import com.cisco.oss.foundation.http.HttpMethod;
import com.cisco.oss.foundation.http.HttpRequest;
import com.cisco.oss.foundation.http.HttpResponse;
import com.cisco.oss.foundation.http.apache.ApacheHttpClientFactory;
import com.cisco.oss.foundation.http.apache.ApacheHttpResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CentralConfigurationUtil {
    INSTANCE;

    public static final String CCP_BACKUP_FILE_NAME;
    public static final String CCP_BACKUP_DIR = "_CCP_BACKUP_DIR";
    public static final Map<String, Parameter> parameterMap;
    private static final MessageFormat GET_CONFIG_URL;
    private static final MessageFormat REGISTER_URL;
    private static final MessageFormat RENEW_LEASE_URL;
    private static final Logger LOGGER;
    private static String uniqueProcName;
    private static HttpClient httpClient;
    private static AtomicBoolean firstTime;

    public static String getUniqueProcessName() {
        String rpmSoftwareName = System.getenv("_RPM_SOFTWARE_NAME");
        if (rpmSoftwareName == null) {
            rpmSoftwareName = System.getenv("_ARTIFACT_NAME");
        }
        if (rpmSoftwareName == null) {
            throw new IllegalArgumentException("_RPM_SOFTWARE_NAME environment variable is mandatory when CCP is enabled");
        }
        if ("vcsconsole".equals(rpmSoftwareName)) {
            return CentralConfigurationUtil.getProcNameforVCSConsoleModule();
        }
        return CentralConfigurationUtil.getProcNameforNonVCSConsoleModule(rpmSoftwareName);
    }

    private static String getProcNameforVCSConsoleModule() {
        File ccpConfigFile;
        String webUniqueProcName = null;
        String artifactName = null;
        String artifactVersion = null;
        BufferedReader reader = null;
        URL ccpConfigFileResource = CentralConfigurationUtil.class.getResource("/ccpConfig.xml");
        if (ccpConfigFileResource == null) {
            throw new IllegalArgumentException("for ndsconsole or one of its modules ccpConfig.xml must be in the module classpath");
        }
        LOGGER.debug("processing the ccp file: " + ccpConfigFileResource.getFile());
        try {
            InputStream ccpConfigFileStream = ccpConfigFileResource.openStream();
            reader = new BufferedReader(new InputStreamReader(ccpConfigFileStream));
            String line = reader.readLine();
            boolean stop = false;
            while (line != null && !stop) {
                if (line.contains("NamespaceIdentifier")) {
                    int nameIndex = line.indexOf("name=\"") + 6;
                    int versionIndex = line.indexOf("version=\"") + 9;
                    artifactName = line.substring(nameIndex, line.indexOf("\"", nameIndex));
                    artifactVersion = line.substring(versionIndex, line.indexOf("\"", versionIndex));
                    LOGGER.debug("Setting the artifact name and version of {} and {}", (Object)artifactName, (Object)artifactVersion);
                    stop = true;
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("CCP is enabled, but can't load the system as unique process name is unknown. Error is: " + e, e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        File currentFile = ccpConfigFile = new File(ccpConfigFileResource.getFile());
        String artifactInstallDir = null;
        boolean stop = false;
        for (File parentFile = ccpConfigFile.getParentFile(); parentFile != null && parentFile.exists() && !stop; parentFile = parentFile.getParentFile()) {
            if ("/opt/nds/installed".equals(parentFile.getPath())) {
                artifactInstallDir = currentFile.getPath();
                stop = true;
            }
            currentFile = parentFile;
        }
        if (artifactInstallDir == null) {
            throw new IllegalArgumentException("Can't calculate the correct install path based on the ccpConfigFile location: " + ccpConfigFile.getPath());
        }
        webUniqueProcName = System.getenv("_FQDN");
        webUniqueProcName = webUniqueProcName + "-" + artifactName;
        webUniqueProcName = webUniqueProcName + "-" + artifactVersion;
        webUniqueProcName = webUniqueProcName + "-" + artifactInstallDir.replaceAll("/", "_");
        LOGGER.debug("web module unique proc name is: " + webUniqueProcName);
        return webUniqueProcName;
    }

    private static String getProcNameforNonVCSConsoleModule(String rpmSoftwareName) {
        if (uniqueProcName == null) {
            uniqueProcName = System.getenv("_FQDN");
            uniqueProcName = uniqueProcName + "-" + rpmSoftwareName;
            uniqueProcName = uniqueProcName + "-" + System.getenv("_ARTIFACT_VERSION");
            uniqueProcName = uniqueProcName + "-" + System.getenv("_INSTALL_DIR").replaceAll("/", "_");
        }
        return uniqueProcName;
    }

    public static String getCcpBackupFileName() {
        String backupDir = System.getenv(CCP_BACKUP_DIR);
        if (StringUtils.isBlank((String)backupDir)) {
            backupDir = System.getProperty("user.dir");
        }
        backupDir = backupDir.endsWith("etc") ? backupDir + "/../docs/ccp" : backupDir + "/docs/ccp";
        return backupDir;
    }

    private HttpClient<HttpRequest, ApacheHttpResponse> getHttpClient() {
        MapConfiguration mapConfiguration = new MapConfiguration(this.loadHttpMetadata());
        return ApacheHttpClientFactory.createHttpClient((String)"service.configurationLib", (Configuration)mapConfiguration);
    }

    public Properties loadHttpMetadata() {
        Properties properties = new Properties();
        String ccpServerData = System.getenv("_CCP_SERVER");
        if (StringUtils.isEmpty((String)ccpServerData)) {
            throw new IllegalArgumentException("the CCP_SERVER environment variable does not have a legal host port pair. The value read is: " + ccpServerData);
        }
        if (!ccpServerData.matches("[[a-zA-Z0-9\\-]*:\\d*[;]*]*") && !ccpServerData.matches("[/^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$/:\\d*[;]*]*")) {
            throw new IllegalArgumentException("the CCP_SERVER environment variable does not have a legal host port pair. The value read is: " + ccpServerData);
        }
        String[] hostPortPairs = ccpServerData.split(";");
        int numOfServers = 1;
        for (String hostPortString : hostPortPairs) {
            int index = hostPortString.lastIndexOf(":");
            String host = hostPortString.substring(0, index);
            String port = hostPortString.substring(index + 1);
            properties.setProperty("service.configurationLib." + numOfServers + ".host", host);
            properties.setProperty("service.configurationLib." + numOfServers + ".port", port);
            ++numOfServers;
        }
        return properties;
    }

    void loadPropertiesFromXml(Map<String, String> props, InputStream is, Map<String, ParameterType> baseMap, Map<String, Parameter> childMap, CompositeConfiguration configuration) {
        String xml = new Scanner(is).useDelimiter("\\Z").next();
        try {
            NamespaceDefinitionMessage namespaceDefinitionMessage = new NamespaceDefinitionMessage(xml);
            List namespaceDefinitions = namespaceDefinitionMessage.jaxb().getNamespaceDefinitions();
            this.loadProps(props, namespaceDefinitions, baseMap, childMap, configuration);
        }
        catch (XmlException e) {
            throw new IllegalArgumentException("cannot parse default config xml file.", e);
        }
    }

    private void loadProps(Map<String, String> props, List<NamespaceDefinition> namespaceDefinitions, Map<String, ParameterType> baseMap, Map<String, Parameter> childMap, CompositeConfiguration configuration) {
        if (namespaceDefinitions.isEmpty()) {
            throw new UnsupportedOperationException("the configSchema.xml file must contain one name space defiinition");
        }
        NamespaceDefinition namespaceDefinition = namespaceDefinitions.get(0);
        this.loadPropsFromNamespaceDefinition(props, baseMap, childMap, namespaceDefinition, configuration);
    }

    private void loadPropsFromNamespaceDefinition(Map<String, String> props, Map<String, ParameterType> baseMap, Map<String, Parameter> childMap, NamespaceDefinition namespaceDefinition, CompositeConfiguration configuration) {
        List parameters = namespaceDefinition.getParameters();
        List parameterTypes = namespaceDefinition.getParameterTypes();
        for (ParameterType parameterType : parameterTypes) {
            baseMap.put(parameterType.getName(), parameterType);
        }
        for (Parameter parameter : parameters) {
            parameterMap.put(parameter.getName(), parameter);
            this.loadPropsFromParameter(props, childMap, parameter, configuration);
        }
    }

    public void loadPropsFromParameter(Map<String, String> props, Map<String, Parameter> childMap, Parameter parameter, CompositeConfiguration configuration) {
        ParameterValue defaultValue;
        String key = parameter.getName();
        if (StringUtils.isNotEmpty((String)parameter.getBase())) {
            childMap.put(key, parameter);
            return;
        }
        if (ParameterKind.STRUCTURE.equals((Object)parameter.getType())) {
            this.updatePropFromStructureDefaults(props, parameter);
        }
        if ((defaultValue = parameter.getDefaultValue()) != null) {
            if (ParameterKind.STRUCTURE.equals((Object)parameter.getType())) {
                List structureValues = defaultValue.getStructureValues();
                this.fillFromStructure(props, parameter, structureValues, configuration);
            } else {
                List primitiveValues = defaultValue.getPrimitiveValues();
                this.updateProps(props, parameter, key, primitiveValues, (Configuration)configuration);
            }
        }
    }

    private void updatePropFromStructureDefaults(Map<String, String> props, Parameter parameter) {
        StructureDefinition structureDefinition = parameter.getStructureDefinition();
        if (structureDefinition != null && !parameter.isIsArray()) {
            List structureMemberDefinitions = structureDefinition.getStructureMemberDefinitions();
            for (StructureMemberDefinition structureMemberDefinition : structureMemberDefinitions) {
                if (!ParameterKind.STRUCTURE.equals((Object)structureMemberDefinition.getType())) {
                    ParameterValue defaultValue;
                    if (structureMemberDefinition.getDefaultValue() == null) continue;
                    String key = parameter.getName();
                    if (!structureMemberDefinition.isIgnoreName()) {
                        key = key + "." + structureMemberDefinition.getName();
                    }
                    if ((defaultValue = structureMemberDefinition.getDefaultValue()).getPrimitiveValues() == null) continue;
                    if (defaultValue.getPrimitiveValues().size() == 1) {
                        props.put(key, ((PrimitiveValue)defaultValue.getPrimitiveValues().get(0)).getValue());
                        continue;
                    }
                    for (PrimitiveValue primitiveValue : defaultValue.getPrimitiveValues()) {
                        String index = primitiveValue.getIndex();
                        props.put(key + "." + index, primitiveValue.getValue());
                    }
                    continue;
                }
                StructureDefinition innerStructureDefinition = structureMemberDefinition.getStructureDefinition();
                if (innerStructureDefinition == null) continue;
                List innerStructureMemberDefinitions = innerStructureDefinition.getStructureMemberDefinitions();
                for (StructureMemberDefinition innerStructureMemberDefinition : innerStructureMemberDefinitions) {
                    ParameterValue defaultValue;
                    if (innerStructureMemberDefinition.getDefaultValue() == null) continue;
                    String key = parameter.getName();
                    if (!structureMemberDefinition.isIgnoreName()) {
                        key = key + "." + structureMemberDefinition.getName();
                    }
                    if ((defaultValue = structureMemberDefinition.getDefaultValue()) == null || defaultValue.getStructureValues() == null) continue;
                    if (defaultValue.getStructureValues().size() == 1) {
                        StructureValue structureValue = (StructureValue)defaultValue.getStructureValues().get(0);
                        this.updatePropsFromStructureMemberValue(props, key, structureValue);
                        continue;
                    }
                    for (StructureValue structureValue : defaultValue.getStructureValues()) {
                        this.updatePropsFromStructureMemberValue(props, key + "." + structureValue.getIndex(), structureValue);
                    }
                }
            }
        }
    }

    public void updatePropsFromStructureMemberValue(Map<String, String> props, String key, StructureValue structureValue) {
        List structureMemberValues = structureValue.getStructureMemberValues();
        for (StructureMemberValue structureMemberValue : structureMemberValues) {
            String newKey = key + structureMemberValue.getName();
            props.put(newKey, structureMemberValue.getValue());
        }
    }

    private void fillFromStructure(Map<String, String> props, Parameter parameter, List<StructureValue> structureValues, CompositeConfiguration configuration) {
        HashMap<String, String> tempProps = new HashMap<String, String>();
        Map<String, Boolean> ignoreNamesMap = this.createIgnoreNamesMap(parameter);
        String key = parameter.getName();
        for (StructureValue structureValue : structureValues) {
            List structureMemberValues = structureValue.getStructureMemberValues();
            for (StructureMemberValue structureMemberValue : structureMemberValues) {
                String value;
                Boolean ignoreName;
                String structKey = key;
                if (structureValue.getIndex() != null) {
                    structKey = key + "." + structureValue.getIndex();
                }
                if ((ignoreName = ignoreNamesMap.get(structureMemberValue.getName())) == null || ignoreName != null && Boolean.FALSE.equals(ignoreName)) {
                    structKey = structKey + "." + structureMemberValue.getName();
                }
                if (structureMemberValue.getIndex() != null) {
                    structKey = structKey + "." + structureMemberValue.getIndex();
                }
                if ((value = structureMemberValue.getValue()) == null) {
                    List innerStructureValues = structureMemberValue.getStructureValues();
                    for (StructureValue innerStructureValue : innerStructureValues) {
                        String index = innerStructureValue.getIndex();
                        List innerStructureMemberValues = innerStructureValue.getStructureMemberValues();
                        for (StructureMemberValue innerStructureMemberValue : innerStructureMemberValues) {
                            String innerStructValue;
                            String innerStructName = innerStructureMemberValue.getName();
                            String tempKey = structKey;
                            if (index != null) {
                                tempKey = structKey + "." + index;
                            }
                            if ((ignoreName = ignoreNamesMap.get(innerStructName)) == null || ignoreName != null && Boolean.FALSE.equals(ignoreName)) {
                                tempKey = tempKey + "." + innerStructName;
                            }
                            if ((innerStructValue = innerStructureMemberValue.getValue()) == null) {
                                List structureValues2 = innerStructureMemberValue.getStructureValues();
                                for (StructureValue structureValue2 : structureValues2) {
                                    String index2 = structureValue2.getIndex();
                                    String tempKey2 = tempKey;
                                    if (index2 != null) {
                                        tempKey2 = tempKey2 + "." + index2;
                                    }
                                    List structureMemberValues2 = structureValue2.getStructureMemberValues();
                                    for (StructureMemberValue structureMemberValue2 : structureMemberValues2) {
                                        String tempKey3 = structureMemberValue2.getName();
                                        tempKey3 = tempKey2 + "." + tempKey3;
                                        tempProps.put(tempKey3, structureMemberValue2.getValue());
                                    }
                                }
                                continue;
                            }
                            tempProps.put(tempKey, innerStructValue);
                        }
                    }
                    continue;
                }
                tempProps.put(structKey, value);
            }
        }
        boolean override = true;
        Set keys = tempProps.keySet();
        for (String tempKey : keys) {
            if (!configuration.containsKey(tempKey.toString()) || parameter.isMergeOverrides()) continue;
            override = false;
            break;
        }
        if (override) {
            props.putAll(tempProps);
        }
    }

    private Map<String, Boolean> createIgnoreNamesMap(Parameter parameter) {
        HashMap<String, Boolean> ignoreNamesMap = new HashMap<String, Boolean>();
        StructureDefinition structureDefinition = parameter.getStructureDefinition();
        if (structureDefinition != null) {
            List structureMemberDefinitions = structureDefinition.getStructureMemberDefinitions();
            for (StructureMemberDefinition structureMemberDefinition : structureMemberDefinitions) {
                boolean ignoreName = structureMemberDefinition.isIgnoreName();
                ignoreNamesMap.put(structureMemberDefinition.getName(), ignoreName);
                if (structureMemberDefinition.getStructureDefinition() == null) continue;
                List innerStructureMemberDefinitions = structureMemberDefinition.getStructureDefinition().getStructureMemberDefinitions();
                for (StructureMemberDefinition innerStructureMemberDefinition : innerStructureMemberDefinitions) {
                    ignoreName = innerStructureMemberDefinition.isIgnoreName();
                    ignoreNamesMap.put(innerStructureMemberDefinition.getName(), ignoreName);
                }
            }
        }
        return ignoreNamesMap;
    }

    private void updateProps(Map<String, String> props, Parameter parameter, String key, List<PrimitiveValue> primitiveValues, Configuration configuration) {
        if (primitiveValues.size() == 1 && !parameter.isIsArray()) {
            props.put(key, primitiveValues.get(0).getValue());
        } else {
            for (PrimitiveValue primitiveValue : primitiveValues) {
                String arrayKey = key + "." + primitiveValue.getIndex();
                if (configuration.containsKey(arrayKey)) break;
                props.put(arrayKey, primitiveValue.getValue());
            }
        }
    }

    public void loadCentralConfiguration(CompositeConfiguration configuration, Map<String, String> descriptionMap, Set<String> enablesDynamicSupportSet) {
        String uniqeProcessName = CentralConfigurationUtil.getUniqueProcessName();
        if (StringUtils.isBlank((String)uniqeProcessName)) {
            throw new IllegalArgumentException("Central configuraiotn is enabled but the properties for CCP were not filled. Please check if you are using the latest GIS.");
        }
        try {
            if (StringUtils.isNotBlank((String)System.getenv("_CCP_SERVER"))) {
                this.loadFromHTTP(configuration, descriptionMap, enablesDynamicSupportSet, uniqeProcessName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reading central configuration from DB or Server. Reading from fallback file instead. Error is: " + e.toString(), (Throwable)e);
            this.loadFromFallbackPropertyFile(configuration);
        }
    }

    private void loadFromHTTP(CompositeConfiguration configuration, Map<String, String> descriptionMap, Set<String> enablesDynamicSupportSet, String uniqeProcessName) {
        ConfigurationResponse configurationResponse = this.getConfigurationResponseViaHttp(uniqeProcessName);
        List namespaceParameters = configurationResponse.getNamespaceParameters();
        this.updateCentralConfigFromNamespaceParameters(configuration, namespaceParameters, descriptionMap, enablesDynamicSupportSet);
    }

    public ConfigurationResponse getConfigurationResponseViaHttp() {
        return this.getConfigurationResponseViaHttp(CentralConfigurationUtil.getUniqueProcessName());
    }

    public ConfigurationResponse getConfigurationResponseViaHttp(String uniqeProcessName) {
        ConfigurationResponse configurationResponse = null;
        HttpRequest httpRequest = HttpRequest.newBuilder().httpMethod(HttpMethod.GET).uri("/api/configuration?process-name=" + uniqeProcessName).build();
        if (firstTime.compareAndSet(true, false)) {
            httpClient = this.getHttpClient();
        }
        HttpResponse httpResponse = httpClient.executeWithLoadBalancer(httpRequest);
        int statusCode = httpResponse.getStatus();
        String xml = httpResponse.getResponseAsString();
        if (statusCode == 200) {
            try {
                ConfigurationResponseMessage message = new ConfigurationResponseMessage(xml);
                configurationResponse = message.jaxb();
            }
            catch (XmlException e) {
                throw new IllegalArgumentException("cannot process http get message.", e);
            }
        } else {
            throw new IllegalArgumentException("received an invalid response. error code is: " + statusCode + ". response is: " + xml);
        }
        if (configurationResponse == null) {
            throw new IllegalArgumentException("couldn't find any available ccp server to get the configuration.");
        }
        return configurationResponse;
    }

    private void updateCentralConfigFromNamespaceParameters(CompositeConfiguration configuration, List<NamespaceParameters> namespaceParameters, Map<String, String> descriptionMap, Set<String> enablesDynamicSupportSet) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (NamespaceParameters namespaceParameter : namespaceParameters) {
            List parameters = namespaceParameter.getParameters();
            for (Parameter parameter : parameters) {
                String key = parameter.getName();
                String description = parameter.getDescription();
                ParameterValue value = parameter.getValue();
                if (value == null) continue;
                List valueList = value.getPrimitiveValues();
                boolean enablesDynamicSupport = false;
                if (!parameter.isRequiresRestart()) {
                    enablesDynamicSupport = true;
                }
                if (valueList.size() == 1 && !parameter.isIsArray()) {
                    configMap.put(key, StringEscapeUtils.unescapeXml((String)((PrimitiveValue)valueList.get(0)).getValue()));
                    descriptionMap.put(key, description);
                    if (enablesDynamicSupport) {
                        enablesDynamicSupportSet.add(key);
                    }
                } else {
                    for (PrimitiveValue primitiveValue : valueList) {
                        key = parameter.getName() + "." + primitiveValue.getIndex();
                        descriptionMap.put(key, description);
                        configMap.put(key, StringEscapeUtils.unescapeXml((String)primitiveValue.getValue()));
                        if (!enablesDynamicSupport) continue;
                        enablesDynamicSupportSet.add(key);
                    }
                }
                List strucutValueList = value.getStructureValues();
                this.updateCentralConfigWithStructure(configMap, descriptionMap, parameter.getName(), strucutValueList, description, enablesDynamicSupport, enablesDynamicSupportSet);
            }
        }
        MapConfiguration mapConfiguration = new MapConfiguration(configMap);
        configuration.addConfiguration((Configuration)mapConfiguration);
    }

    private void updateCentralConfigWithStructure(Map<String, String> configMap, Map<String, String> descriptionMap, String keyPrefix, List<StructureValue> strucutValueList, String description, boolean enablesDynamicSupport, Set<String> enablesDynamicSupportSet) {
        for (StructureValue structureValue : strucutValueList) {
            List structureMemberValues = structureValue.getStructureMemberValues();
            for (StructureMemberValue structureMemberValue : structureMemberValues) {
                String key = keyPrefix + "." + (structureValue.getIndex() != null ? structureValue.getIndex() + "." : "") + structureMemberValue.getName();
                if (StringUtils.isNotEmpty((String)structureMemberValue.getIndex())) {
                    key = key + "." + structureMemberValue.getIndex();
                }
                descriptionMap.put(key, description);
                if (null != structureMemberValue.getStructureValues() && structureMemberValue.getStructureValues().size() > 0) {
                    this.updateCentralConfigWithStructure(configMap, descriptionMap, key, structureMemberValue.getStructureValues(), description, enablesDynamicSupport, enablesDynamicSupportSet);
                    continue;
                }
                configMap.put(key, StringEscapeUtils.unescapeXml((String)structureMemberValue.getValue()));
                if (!enablesDynamicSupport) continue;
                enablesDynamicSupportSet.add(key);
            }
        }
    }

    private void loadFromFallbackPropertyFile(CompositeConfiguration configuration) {
        PropertiesConfiguration propertiesConfiguration;
        String backupDir = System.getProperty("user.dir");
        backupDir = backupDir.endsWith("etc") ? backupDir + "/../docs/ccp" : backupDir + "/docs/ccp";
        File fallbackFile = new File(backupDir + CCP_BACKUP_FILE_NAME);
        if (fallbackFile.exists()) {
            LOGGER.info("Problems in DB load, using fallback file: \"" + fallbackFile.getPath() + "\" instead.");
            propertiesConfiguration = null;
            try {
                propertiesConfiguration = new PropertiesConfiguration(fallbackFile);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException("cannot fallback to proeprty file!", e);
            }
        } else {
            throw new IllegalArgumentException("cannot fallback to proeprty file, as the file: \"" + fallbackFile.getPath() + "\" does not exist.");
        }
        configuration.addConfiguration((Configuration)propertiesConfiguration);
    }

    static {
        CCP_BACKUP_FILE_NAME = System.getProperty("app.instance.name") == null ? "/ccp.backup.properties" : "/ccp." + System.getProperty("app.instance.name") + ".backup.properties";
        parameterMap = new HashMap<String, Parameter>();
        GET_CONFIG_URL = new MessageFormat("http://{0}:{1}/api/configuration?process-name={2}");
        REGISTER_URL = new MessageFormat("http://{0}:{1}/api/register?uniqueProcessName={2}");
        RENEW_LEASE_URL = new MessageFormat("http://{0}:{1}/api/renewLease?levelInstanceId={2,number,#}");
        LOGGER = LoggerFactory.getLogger(CentralConfigurationUtil.class);
        uniqueProcName = null;
        httpClient = null;
        firstTime = new AtomicBoolean(true);
    }
}

