/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import com.cisco.oss.foundation.configuration.CentralConfigurationUtil;
import com.cisco.oss.foundation.configuration.FoundationCompositeConfiguration;
import com.cisco.oss.foundation.configuration.FoundationConfigurationListenerRegistry;
import com.cisco.oss.foundation.configuration.xml.jaxb.EnabledBy;
import com.cisco.oss.foundation.configuration.xml.jaxb.Operator;
import com.cisco.oss.foundation.configuration.xml.jaxb.Parameter;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterKind;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterRange;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterType;
import com.cisco.oss.foundation.configuration.xml.jaxb.ParameterValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.PrimitiveValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StringEnum;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureMemberDefinition;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureMemberValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.StructureValue;
import com.cisco.oss.foundation.configuration.xml.jaxb.ValueRange;
import com.cisco.oss.foundation.logging.ApplicationStateInterface;
import com.cisco.oss.foundation.logging.FoundationLevel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class CommonConfigurationsLoader
implements FactoryBean<Configuration>,
InitializingBean {
    private static final int NUM_OF_BACKUP_FILES = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonConfigurationsLoader.class);
    private static final Logger AUDITOR = LoggerFactory.getLogger((String)("audit." + CommonConfigurationsLoader.class));
    private static CompositeConfiguration configuration = null;
    private static boolean printedToLog = false;
    private List<Resource> resourcesList;
    private static final SimpleDateFormat ROLLING_TIME_STAMP = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    private final Map<String, String> descriptionMap = new HashMap<String, String>();
    private final Set<String> enablesDynamicSupportSet = new HashSet<String>();
    private boolean delimiterParsingDisabled = false;
    private String defaultListDelimiter = ",";
    private ApplicationStateInterface applicationState;

    public void setApplicationState(ApplicationStateInterface applicationState) {
        this.applicationState = applicationState;
    }

    public void afterPropertiesSet() throws Exception {
        if (configuration == null) {
            configuration = new FoundationCompositeConfiguration();
            configuration.setDelimiterParsingDisabled(this.delimiterParsingDisabled);
            AbstractConfiguration.setDefaultListDelimiter((char)this.defaultListDelimiter.charAt(0));
            boolean centralConfigEnabled = Boolean.valueOf(System.getenv("_CCP_ENABLED"));
            if (centralConfigEnabled) {
                if (this.applicationState != null) {
                    this.applicationState.setState(FoundationLevel.INFO, (Object)"central configuration IS enabled!");
                }
                CentralConfigurationUtil.INSTANCE.loadCentralConfiguration(configuration, this.descriptionMap, this.enablesDynamicSupportSet);
                this.loadNonCentralConfiguration(configuration, false);
                this.createFallBackFile(configuration);
                LOGGER.info("central configuration dynamic reload IS enabled!");
                DynamicConfigurationSupport dynamicConfigurationSupport = new DynamicConfigurationSupport();
                dynamicConfigurationSupport.start();
            } else {
                if (this.applicationState != null) {
                    this.applicationState.setState(FoundationLevel.INFO, (Object)"central configuration IS NOT enabled!");
                }
                this.loadNonCentralConfiguration(configuration, true);
                this.validateConfiguration();
                this.reportOrphanParameters();
            }
            this.printPropertiesLoaded(configuration);
        }
    }

    private void reportOrphanParameters() {
        StringBuilder orphansStr = new StringBuilder("The following configuration parameters were found with no backing definition in any component/library:\n");
        ArrayList<String> suspectedOrphans = new ArrayList<String>();
        try {
            Iterator keys = configuration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (CentralConfigurationUtil.parameterMap.containsKey(key)) continue;
                suspectedOrphans.add(key);
            }
            Iterator suspecteOrphaneItr = suspectedOrphans.iterator();
            block3: while (suspecteOrphaneItr.hasNext()) {
                String suspectedOrphan = (String)suspecteOrphaneItr.next();
                Set<Map.Entry<String, Parameter>> paramEntries = CentralConfigurationUtil.parameterMap.entrySet();
                for (Map.Entry<String, Parameter> paramEntry : paramEntries) {
                    String name;
                    String key = paramEntry.getKey();
                    Parameter parameter = paramEntry.getValue();
                    if (!suspectedOrphan.startsWith(key) || !parameter.isIsArray() && !parameter.getType().equals((Object)ParameterKind.STRUCTURE)) continue;
                    if (parameter.isIsArray() && !parameter.getType().equals((Object)ParameterKind.STRUCTURE)) {
                        String stripedKey = suspectedOrphan.substring(0, suspectedOrphan.lastIndexOf("."));
                        if (!stripedKey.equals(key)) continue;
                        suspecteOrphaneItr.remove();
                        continue block3;
                    }
                    String[] splittedOrphan = suspectedOrphan.split("\\.");
                    String base = "";
                    int baseIndex = 0;
                    if (key.contains(".")) {
                        String[] split = key.split("\\.");
                        int numberOfDots = split.length - 1;
                        baseIndex += numberOfDots;
                        for (int i = 0; i < split.length; ++i) {
                            base = base + split[i] + ".";
                        }
                        base = base.substring(0, base.lastIndexOf(46));
                    } else {
                        base = splittedOrphan[baseIndex];
                    }
                    if (!key.equals(base)) continue;
                    boolean found = false;
                    int index = baseIndex + 2;
                    if (parameter.isIsArray()) {
                        List structureMemberDefinitions = parameter.getStructureDefinition().getStructureMemberDefinitions();
                        block6: for (StructureMemberDefinition structureMemberDefinition : structureMemberDefinitions) {
                            name = structureMemberDefinition.getName();
                            int numOfTokens = 0;
                            if (name.contains(".")) {
                                numOfTokens = name.split("\\.").length - 1;
                            }
                            if (splittedOrphan.length > index + numOfTokens) {
                                String orphanSubset = splittedOrphan[index];
                                if (numOfTokens > 0) {
                                    for (int i = 1; i <= numOfTokens; ++i) {
                                        orphanSubset = orphanSubset + "." + splittedOrphan[index + i];
                                    }
                                }
                                if (name.equals(orphanSubset)) {
                                    suspecteOrphaneItr.remove();
                                    found = true;
                                    break;
                                }
                            }
                            if (!structureMemberDefinition.isIgnoreName() || !structureMemberDefinition.isIsArray() || splittedOrphan.length <= baseIndex + 3 || structureMemberDefinition.getStructureDefinition() == null || structureMemberDefinition.getStructureDefinition().getStructureMemberDefinitions().size() <= 0) continue;
                            List inner = structureMemberDefinition.getStructureDefinition().getStructureMemberDefinitions();
                            block8: for (StructureMemberDefinition innerStructureMemberDefinition : inner) {
                                StructureDefinition innerStructureDefinition = innerStructureMemberDefinition.getStructureDefinition();
                                if (innerStructureMemberDefinition.isIgnoreName() && innerStructureMemberDefinition.isIsArray() && splittedOrphan.length > baseIndex + 4 && innerStructureDefinition != null && innerStructureDefinition.getStructureMemberDefinitions().size() > 0) {
                                    List innerStructureMemberDefinitionList = innerStructureDefinition.getStructureMemberDefinitions();
                                    for (StructureMemberDefinition structureMemberDefinition2 : innerStructureMemberDefinitionList) {
                                        if (!structureMemberDefinition2.getName().equals(splittedOrphan[baseIndex + 4])) continue;
                                        suspecteOrphaneItr.remove();
                                        found = true;
                                        continue block8;
                                    }
                                    continue;
                                }
                                if (!innerStructureMemberDefinition.getName().equals(splittedOrphan[baseIndex + 3])) continue;
                                suspecteOrphaneItr.remove();
                                found = true;
                                continue block6;
                            }
                        }
                        if (!found) continue;
                        continue block3;
                    }
                    List structureMemberDefinitions = parameter.getStructureDefinition().getStructureMemberDefinitions();
                    block10: for (StructureMemberDefinition structureMemberDefinition : structureMemberDefinitions) {
                        String orphanSubset;
                        name = structureMemberDefinition.getName();
                        boolean ignoreName = structureMemberDefinition.isIgnoreName();
                        if (structureMemberDefinition.isIsArray()) {
                            if (structureMemberDefinition.getType().equals((Object)ParameterKind.STRUCTURE)) {
                                List innerStructureMemberDefinitions = structureMemberDefinition.getStructureDefinition().getStructureMemberDefinitions();
                                block11: for (StructureMemberDefinition innerStructureMemberDefinition : innerStructureMemberDefinitions) {
                                    if (splittedOrphan.length > index && innerStructureMemberDefinition.getName().equals(splittedOrphan[index])) {
                                        suspecteOrphaneItr.remove();
                                        found = true;
                                        continue block10;
                                    }
                                    if (splittedOrphan.length > index + 1 && !ignoreName && innerStructureMemberDefinition.getName().equals(splittedOrphan[index + 1])) {
                                        suspecteOrphaneItr.remove();
                                        found = true;
                                        continue block10;
                                    }
                                    if (innerStructureMemberDefinition.isIgnoreName() && innerStructureMemberDefinition.isIsArray() && splittedOrphan.length > baseIndex + 3 && innerStructureMemberDefinition.getStructureDefinition() != null && innerStructureMemberDefinition.getStructureDefinition().getStructureMemberDefinitions().size() > 0) {
                                        List innerStructureMemberDefinitionList = innerStructureMemberDefinition.getStructureDefinition().getStructureMemberDefinitions();
                                        block12: for (StructureMemberDefinition innerInnerStructureMemberDefinition : innerStructureMemberDefinitionList) {
                                            StructureDefinition innerStructureDefinition = innerInnerStructureMemberDefinition.getStructureDefinition();
                                            if (innerInnerStructureMemberDefinition.isIgnoreName() && innerInnerStructureMemberDefinition.isIsArray() && splittedOrphan.length > baseIndex + 4 && innerInnerStructureMemberDefinition != null && innerStructureDefinition.getStructureMemberDefinitions().size() > 0) {
                                                List innerInnerStructureMemberDefinitionList = innerStructureDefinition.getStructureMemberDefinitions();
                                                for (StructureMemberDefinition structureMemberDefinition2 : innerInnerStructureMemberDefinitionList) {
                                                    if (!structureMemberDefinition2.getName().equals(splittedOrphan[baseIndex + 4])) continue;
                                                    suspecteOrphaneItr.remove();
                                                    found = true;
                                                    continue block12;
                                                }
                                                continue;
                                            }
                                            if (!innerInnerStructureMemberDefinition.getName().equals(splittedOrphan[baseIndex + 3])) continue;
                                            suspecteOrphaneItr.remove();
                                            found = true;
                                            continue block11;
                                        }
                                        continue;
                                    }
                                    if (splittedOrphan.length <= index || !innerStructureMemberDefinition.getName().equals(splittedOrphan[index])) continue;
                                    suspecteOrphaneItr.remove();
                                    found = true;
                                    continue block10;
                                }
                                continue;
                            }
                            int numOfTokens = 0;
                            if (name.contains(".") && name.contains(".")) {
                                numOfTokens = name.split("\\.").length;
                            }
                            if (splittedOrphan.length <= baseIndex + numOfTokens) continue;
                            orphanSubset = splittedOrphan[baseIndex + 1];
                            if (numOfTokens > 0) {
                                orphanSubset = "";
                                for (int i = 0; i < numOfTokens; ++i) {
                                    orphanSubset = orphanSubset + splittedOrphan[baseIndex + 1 + i] + ".";
                                }
                                orphanSubset = orphanSubset.substring(0, orphanSubset.lastIndexOf(46));
                            }
                            if (!name.equals(orphanSubset)) continue;
                            suspecteOrphaneItr.remove();
                            found = true;
                            break;
                        }
                        if (name.contains(".")) {
                            int numOfTokens = 0;
                            if (name.contains(".") && name.contains(".")) {
                                numOfTokens = name.split("\\.").length;
                            }
                            if (splittedOrphan.length <= baseIndex + numOfTokens) continue;
                            orphanSubset = "";
                            for (int i = 0; i < numOfTokens; ++i) {
                                orphanSubset = orphanSubset + splittedOrphan[baseIndex + 1 + i] + ".";
                            }
                            if (!name.equals(orphanSubset = orphanSubset.substring(0, orphanSubset.lastIndexOf(46)))) continue;
                            suspecteOrphaneItr.remove();
                            found = true;
                            break;
                        }
                        if (!name.equals(splittedOrphan[baseIndex + 1])) continue;
                        suspecteOrphaneItr.remove();
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            suspectedOrphans = new ArrayList();
            LOGGER.debug("couldn't run the orhpan configuration validation test. error is: " + e);
        }
        for (String suspectedOrphan : suspectedOrphans) {
            orphansStr.append(suspectedOrphan).append("\n");
        }
        if (suspectedOrphans.size() > 0) {
            LOGGER.debug(orphansStr.toString());
        }
    }

    private void validateConfiguration() {
        try {
            ArrayList<String> requiredErrors = new ArrayList<String>();
            ArrayList<String> typeErrors = new ArrayList<String>();
            ArrayList<String> rangeErrors = new ArrayList<String>();
            Map<String, Parameter> parameterMap = CentralConfigurationUtil.parameterMap;
            for (Parameter parameter : parameterMap.values()) {
                List structureMemberDefinitions;
                String name = parameter.getName();
                boolean required = parameter.isRequired();
                ParameterKind type = parameter.getType();
                ParameterRange range = parameter.getRange();
                EnabledBy enabledBy = parameter.getEnabledBy();
                if (parameter.isIsArray()) {
                    if (ParameterKind.STRUCTURE.equals((Object)parameter.getType())) {
                        List structureMemberDefinitions2 = parameter.getStructureDefinition().getStructureMemberDefinitions();
                        this.validateStructureArray(requiredErrors, typeErrors, rangeErrors, name, structureMemberDefinitions2, enabledBy);
                        continue;
                    }
                    this.validatePrimitveArray(requiredErrors, typeErrors, rangeErrors, name, required, type, range, enabledBy);
                    continue;
                }
                if (!ParameterKind.STRUCTURE.equals((Object)parameter.getType())) {
                    this.validateSingleParameter(requiredErrors, typeErrors, rangeErrors, name, required, type, range, enabledBy);
                    continue;
                }
                StructureDefinition structureDefinition = parameter.getStructureDefinition();
                if (structureDefinition == null || (structureMemberDefinitions = structureDefinition.getStructureMemberDefinitions()) == null) continue;
                for (StructureMemberDefinition structureMemberDefinition : structureMemberDefinitions) {
                    boolean isArray = structureMemberDefinition.isIsArray();
                    if (isArray) {
                        boolean ignoreName = structureMemberDefinition.isIgnoreName();
                        String tempName = name;
                        if (!ignoreName) {
                            tempName = tempName + "." + structureMemberDefinition.getName();
                        }
                        if (structureMemberDefinition.getStructureDefinition() != null) {
                            List innerStructureMemberDefinitions = structureMemberDefinition.getStructureDefinition().getStructureMemberDefinitions();
                            this.validateStructureArray(requiredErrors, typeErrors, rangeErrors, tempName, innerStructureMemberDefinitions, enabledBy);
                            continue;
                        }
                        this.validatePrimitveArray(requiredErrors, typeErrors, rangeErrors, tempName, structureMemberDefinition.isRequired(), structureMemberDefinition.getType(), range, enabledBy);
                        continue;
                    }
                    String tempName = name + "." + structureMemberDefinition.getName();
                    required = structureMemberDefinition.isRequired();
                    type = structureMemberDefinition.getType();
                    range = structureMemberDefinition.getRange();
                    this.validateSingleParameter(requiredErrors, typeErrors, rangeErrors, tempName, required, type, range, enabledBy);
                }
            }
            if (!(requiredErrors.isEmpty() && typeErrors.isEmpty() && rangeErrors.isEmpty())) {
                String errorMessage = this.buildErrorMultiLineMessage(requiredErrors, typeErrors, rangeErrors);
                if (configuration.getBoolean("configuration.rejectInvalidConfiguration", false)) {
                    throw new IllegalArgumentException(errorMessage);
                }
                LOGGER.error(errorMessage);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("can't run configuraiton validation", (Throwable)e);
        }
    }

    private void validatePrimitveArray(List<String> requiredErrors, List<String> typeErrors, List<String> rangeErrors, String name, boolean required, ParameterKind type, ParameterRange range, EnabledBy enabledBy) {
        Configuration subset = configuration.subset(name);
        Iterator keys = subset.getKeys();
        boolean found = false;
        if (keys.hasNext()) {
            while (keys.hasNext()) {
                found = true;
                String index = (String)keys.next();
                this.validateSingleParameter(requiredErrors, typeErrors, rangeErrors, name + "." + index, required, type, range, enabledBy);
            }
        } else if (enabledBy != null) {
            List primitiveValues;
            String enabledByName = enabledBy.getParameterName();
            Operator operator = enabledBy.getOperator();
            if (Operator.E.equals((Object)operator) && (primitiveValues = enabledBy.getValue().getPrimitiveValues()) != null) {
                String enabledByValue = ((PrimitiveValue)primitiveValues.get(0)).getValue();
                String enabledByValue2 = configuration.getString(enabledByName, null);
                if (enabledByValue != null && enabledByValue2 != null && !enabledByValue.equals(enabledByValue2)) {
                    found = true;
                }
            }
        }
        if (required && !found) {
            requiredErrors.add("[Array] " + name);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateStructureArray(List<String> requiredErrors, List<String> typeErrors, List<String> rangeErrors, String baseName, List<StructureMemberDefinition> structureMemberDefinitions, EnabledBy enabledBy) {
        ArrayList<StructureMemberDefinition> primitives = new ArrayList<StructureMemberDefinition>();
        ArrayList<StructureMemberDefinition> arrays = new ArrayList<StructureMemberDefinition>();
        for (StructureMemberDefinition structureMemberDefinition : structureMemberDefinitions) {
            boolean isArray = structureMemberDefinition.isIsArray();
            if (isArray) {
                arrays.add(structureMemberDefinition);
                continue;
            }
            primitives.add(structureMemberDefinition);
        }
        Set<Object> names = new HashSet<String>();
        for (StructureMemberDefinition structureMemberDefinition : primitives) {
            names.addAll(this.calculateNameWithIndex(baseName, structureMemberDefinition.getName()));
        }
        HashMap<String, StructureMemberDefinition> nameToPrimitiveDefinition = new HashMap<String, StructureMemberDefinition>();
        for (String string : names) {
            for (StructureMemberDefinition structureMemberDefinition : primitives) {
                String key = string + "." + structureMemberDefinition.getName();
                nameToPrimitiveDefinition.put(key, structureMemberDefinition);
            }
        }
        for (Map.Entry entry : nameToPrimitiveDefinition.entrySet()) {
            StructureMemberDefinition structureMemberDefinition = (StructureMemberDefinition)entry.getValue();
            boolean bl = structureMemberDefinition.isRequired();
            ParameterKind type = structureMemberDefinition.getType();
            ParameterRange range = structureMemberDefinition.getRange();
            this.validateSingleParameter(requiredErrors, typeErrors, rangeErrors, (String)entry.getKey(), bl, type, range, enabledBy, structureMemberDefinition.getDefaultValue());
        }
        for (StructureMemberDefinition structureMemberDefinition : arrays) {
            names = this.calculateNameWithIndex(baseName, structureMemberDefinition.getName());
            for (String string : names) {
                void var14_24;
                StructureDefinition structureDefinition;
                boolean ignoreName = structureMemberDefinition.isIgnoreName();
                if (!ignoreName) {
                    String string2 = string + "." + structureMemberDefinition.getName();
                }
                if ((structureDefinition = structureMemberDefinition.getStructureDefinition()) != null) {
                    List innerStructureMemberDefinitions = structureDefinition.getStructureMemberDefinitions();
                    this.validateStructureArray(requiredErrors, typeErrors, rangeErrors, (String)var14_24, innerStructureMemberDefinitions, enabledBy);
                    continue;
                }
                this.validatePrimitveArray(requiredErrors, typeErrors, rangeErrors, (String)var14_24, structureMemberDefinition.isRequired(), structureMemberDefinition.getType(), structureMemberDefinition.getRange(), enabledBy);
            }
        }
    }

    private Set<String> calculateNameWithIndex(String baseName, String name) {
        HashSet<String> names = new HashSet<String>();
        String origBaseName = baseName;
        Configuration subset = configuration.subset(baseName);
        Iterator keys = subset.getKeys();
        boolean found = false;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.contains("." + name)) continue;
            String tempBaseName = baseName + "." + key;
            tempBaseName = tempBaseName.substring(0, tempBaseName.lastIndexOf("." + name));
            names.add(tempBaseName);
            found = true;
        }
        return names;
    }

    private void validateSingleParameter(List<String> requiredErrors, List<String> typeErrors, List<String> rangeErrors, String name, boolean required, ParameterKind type, ParameterRange range, EnabledBy enabledBy) {
        this.validateSingleParameter(requiredErrors, typeErrors, rangeErrors, name, required, type, range, enabledBy, null);
    }

    private void validateSingleParameter(List<String> requiredErrors, List<String> typeErrors, List<String> rangeErrors, String name, boolean required, ParameterKind type, ParameterRange range, EnabledBy enabledBy, ParameterValue defaultValue) {
        boolean defValueExists;
        String value = configuration.getString(name, null);
        boolean bl = defValueExists = defaultValue != null && defaultValue.getPrimitiveValues() != null && !defaultValue.getPrimitiveValues().isEmpty();
        if (value == null && defValueExists) {
            value = ((PrimitiveValue)defaultValue.getPrimitiveValues().get(0)).getValue();
            configuration.setProperty(name, (Object)value);
        }
        if (value == null) {
            if (required) {
                if (enabledBy != null) {
                    List primitiveValues;
                    String enabledByName = enabledBy.getParameterName();
                    Operator operator = enabledBy.getOperator();
                    if (Operator.E.equals((Object)operator) && (primitiveValues = enabledBy.getValue().getPrimitiveValues()) != null) {
                        String enabledByValue = ((PrimitiveValue)primitiveValues.get(0)).getValue();
                        String enabledByValue2 = configuration.getString(enabledByName, null);
                        if (enabledByValue != null && enabledByValue2 != null && enabledByValue.equals(enabledByValue2)) {
                            requiredErrors.add(name);
                        }
                    }
                } else {
                    requiredErrors.add(name);
                }
            }
        } else {
            switch (type) {
                case INTEGER: {
                    try {
                        int max;
                        int intVal = Integer.parseInt(value);
                        if (range == null || range.getValueRange() == null) break;
                        ValueRange valueRange = range.getValueRange();
                        String minStr = valueRange.getMin();
                        String maxStr = valueRange.getMax();
                        int min = minStr != null ? Integer.parseInt(minStr) : Integer.MIN_VALUE;
                        int n = max = maxStr != null ? Integer.parseInt(maxStr) : Integer.MAX_VALUE;
                        if (intVal >= min && intVal <= max) break;
                        rangeErrors.add(name + ": expected range is ([min-max]): [" + min + "-" + max + "]");
                    }
                    catch (NumberFormatException e) {
                        typeErrors.add(name + ": expecting Integer");
                    }
                    break;
                }
                case BOOLEAN: {
                    String upValue = value.toUpperCase();
                    if ("FALSE".equals(upValue) || "TRUE".equals(upValue)) break;
                    typeErrors.add(name + ": expecting Boolean");
                    break;
                }
                case FLOAT: {
                    try {
                        Float.parseFloat(value);
                    }
                    catch (NumberFormatException e) {
                        typeErrors.add(name + ": expecting Float");
                    }
                    break;
                }
                case STRING: {
                    if (range == null || range.getStringEna() == null) break;
                    List stringEnumeration = range.getStringEna();
                    ArrayList<String> stringEnums = new ArrayList<String>(stringEnumeration.size());
                    boolean found = false;
                    for (StringEnum stringEnum : stringEnumeration) {
                        String strValue = stringEnum.getValue();
                        stringEnums.add(strValue);
                        if (!strValue.equals(value)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                    rangeErrors.add(name + ": expected range is " + stringEnums);
                    break;
                }
            }
        }
    }

    private String buildErrorMultiLineMessage(List<String> requiredErrors, List<String> typeErrors, List<String> rangeErrors) {
        StringBuilder builder = new StringBuilder();
        builder.append("Configuration errors:\n");
        if (!requiredErrors.isEmpty()) {
            builder.append("\nRequired configuration parameters without values:\n");
            for (String error : requiredErrors) {
                builder.append(error);
                builder.append("\n");
            }
        }
        if (!typeErrors.isEmpty()) {
            builder.append("\nType mismatch:\n");
            for (String error : typeErrors) {
                builder.append(error);
                builder.append("\n");
            }
        }
        if (!rangeErrors.isEmpty()) {
            builder.append("\nOut of range:\n");
            for (String error : rangeErrors) {
                builder.append(error);
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public void setResourcesList(List<Resource> resourcesList) {
        this.resourcesList = resourcesList;
    }

    public Configuration getObject() throws Exception {
        return configuration;
    }

    private void createFallBackFile(CompositeConfiguration configuration) {
        String backupDir = CentralConfigurationUtil.getCcpBackupFileName();
        File backupDirFile = new File(backupDir);
        if (!backupDirFile.exists()) {
            backupDirFile.mkdirs();
        }
        this.cleanup(backupDirFile);
        File fallbackFile = new File(backupDir + CentralConfigurationUtil.CCP_BACKUP_FILE_NAME);
        try {
            String tempFileName = backupDir + CentralConfigurationUtil.CCP_BACKUP_FILE_NAME + "_temp";
            File tempFile = new File(tempFileName);
            this.writeConfigurationToFile(configuration, tempFile);
            if (fallbackFile.exists()) {
                String fallBackFilePath = fallbackFile.getPath();
                boolean renamed = fallbackFile.renameTo(new File(fallBackFilePath + "_" + ROLLING_TIME_STAMP.format(new Date())));
                if (!renamed) {
                    LOGGER.error("could not rename the file: " + fallBackFilePath);
                } else {
                    fallbackFile.createNewFile();
                }
            } else {
                fallbackFile.createNewFile();
            }
            boolean renamed = tempFile.renameTo(fallbackFile);
            if (!renamed) {
                LOGGER.error("could not rename the file: " + tempFileName);
            }
        }
        catch (IOException e) {
            LOGGER.error("cannot fallback to property file!", (Throwable)e);
            throw new IllegalArgumentException("cannot fallback to property file!", e);
        }
    }

    private void writeConfigurationToFile(CompositeConfiguration configuration, File fallbackFile) throws IOException {
        Iterator keys = configuration.getKeys();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fallbackFile));
        while (keys.hasNext()) {
            int indexOfDot;
            String key = (String)keys.next();
            if (configuration.getString(key) == null) continue;
            String description = this.descriptionMap.get(key);
            String value = configuration.getString(key);
            if (description == null && (indexOfDot = key.indexOf(".")) > 0) {
                String tempKey = key.substring(0, indexOfDot);
                description = this.descriptionMap.get(tempKey);
            }
            if (description != null) {
                bufferedWriter.write("#" + description + "\n");
            }
            bufferedWriter.write(key + "=" + value + "\n");
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private void cleanup(File backupDirFile) {
        File[] files = backupDirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ccp.backup.properties");
            }
        });
        if (files != null && files.length > 50) {
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
            files[files.length - 1].delete();
        }
    }

    private void loadNonCentralConfiguration(CompositeConfiguration configuration, boolean includeCustomerConfig) throws IOException, ConfigurationException {
        HashMap<String, ParameterType> baseMap = new HashMap<String, ParameterType>();
        HashMap<String, Parameter> childMap = new HashMap<String, Parameter>();
        for (int i = this.resourcesList.size() - 1; i >= 0; --i) {
            Resource resource = this.resourcesList.get(i);
            Configuration config = null;
            if (resource.getFilename().endsWith(".xml")) {
                HashMap<String, String> properties = new HashMap<String, String>();
                CentralConfigurationUtil.INSTANCE.loadPropertiesFromXml(properties, resource.getInputStream(), baseMap, childMap, configuration);
                config = new MapConfiguration(properties);
            } else {
                URL resourceUrl = resource.getURL();
                if (resourceUrl != null && resourceUrl.getPath().endsWith("config.properties")) {
                    if (includeCustomerConfig) {
                        config = this.createPropertiesConfiguration(resourceUrl);
                    }
                } else {
                    config = this.createPropertiesConfiguration(resourceUrl);
                }
            }
            if (config == null) continue;
            configuration.addConfiguration(config);
        }
        Set childEntries = childMap.entrySet();
        for (Map.Entry childEntry : childEntries) {
            String key = (String)childEntry.getKey();
            Parameter parameter = (Parameter)childEntry.getValue();
            CentralConfigurationUtil.parameterMap.remove(parameter);
            String base = parameter.getBase();
            ParameterType parameterType = (ParameterType)baseMap.get(base);
            if (parameterType != null) {
                StructureDefinition baseStructureDefinition = parameterType.getStructureDefinition();
                StructureDefinition childStructureDefinition = parameter.getStructureDefinition();
                if (childStructureDefinition == null) {
                    parameter.setStructureDefinition((StructureDefinition)baseStructureDefinition.clone());
                } else {
                    List baseStructureMemberDefinitions = baseStructureDefinition.getStructureMemberDefinitions();
                    List childStructureMemberDefinitions = childStructureDefinition.getStructureMemberDefinitions();
                    childStructureMemberDefinitions.addAll(baseStructureMemberDefinitions);
                }
                parameter.setRequired(Boolean.valueOf(parameterType.isRequired()));
                parameter.setRequiresRestart(Boolean.valueOf(parameterType.isRequiresRestart()));
                parameter.setAdvanced(Boolean.valueOf(parameterType.isAdvanced()));
                parameter.setHidden(Boolean.valueOf(parameterType.isHidden()));
            }
            if (parameter.getDefaultValue() != null && parameter.getDefaultValue().getStructureValues() != null) {
                List structureValues = parameter.getDefaultValue().getStructureValues();
                for (StructureValue structureValue : structureValues) {
                    if (structureValue == null) continue;
                    List structureMemberValues = structureValue.getStructureMemberValues();
                    for (StructureMemberValue structureMemberValue : structureMemberValues) {
                        if (structureMemberValue == null || parameter.getStructureDefinition() == null) continue;
                        String name = structureMemberValue.getName();
                        List structureMemberDefinitions = parameter.getStructureDefinition().getStructureMemberDefinitions();
                        for (StructureMemberDefinition structureMemberDefinition : structureMemberDefinitions) {
                            if (!name.equals(structureMemberDefinition.getName())) continue;
                            ParameterValue defaultValue = structureMemberDefinition.getDefaultValue();
                            ArrayList<PrimitiveValue> primitiveValues = new ArrayList<PrimitiveValue>();
                            PrimitiveValue primitiveValue = new PrimitiveValue();
                            primitiveValue.setValue(structureMemberValue.getValue());
                            primitiveValue.setIndex(structureMemberValue.getIndex());
                            primitiveValues.add(primitiveValue);
                            if (defaultValue == null) {
                                defaultValue = new ParameterValue();
                                structureMemberDefinition.setDefaultValue(defaultValue);
                                defaultValue.setPrimitiveValues(primitiveValues);
                                continue;
                            }
                            if (defaultValue.getPrimitiveValues() != null && defaultValue.getPrimitiveValues().size() > 0) {
                                if (structureMemberDefinition.isIsArray()) {
                                    defaultValue.getPrimitiveValues().add(primitiveValue);
                                    continue;
                                }
                                ((PrimitiveValue)defaultValue.getPrimitiveValues().get(0)).setValue(structureMemberValue.getValue());
                                continue;
                            }
                            defaultValue.setPrimitiveValues(primitiveValues);
                        }
                    }
                }
            }
            CentralConfigurationUtil.parameterMap.put(parameter.getName(), parameter);
            HashMap<String, String> properties = new HashMap<String, String>();
            parameter.setBase(null);
            CentralConfigurationUtil.INSTANCE.loadPropsFromParameter(properties, childMap, parameter, configuration);
            configuration.addConfiguration((Configuration)new MapConfiguration(properties));
        }
    }

    private Configuration createPropertiesConfiguration(URL resourceUrl) throws ConfigurationException {
        PropertiesConfiguration config;
        PropertiesConfiguration propertiesConfiguration = config = new PropertiesConfiguration();
        propertiesConfiguration.setDelimiterParsingDisabled(this.delimiterParsingDisabled);
        propertiesConfiguration.load(resourceUrl);
        return config;
    }

    public Class<Configuration> getObjectType() {
        return Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void printPropertiesLoaded(CompositeConfiguration configuration) {
        if (printedToLog) {
            return;
        }
        printedToLog = true;
        Iterator keys = configuration.getKeys();
        StringBuilder logMessage = new StringBuilder("The properties loaded are:\n");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = configuration.getProperty(key);
            if (value == null || value.toString().contains("DUMMY")) continue;
            logMessage.append(key).append("=").append(value).append("\n");
        }
        if (this.applicationState != null) {
            this.applicationState.setState(FoundationLevel.INFO, (Object)logMessage.toString());
        }
    }

    public boolean isDelimiterParsingDisabled() {
        return this.delimiterParsingDisabled;
    }

    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        this.delimiterParsingDisabled = delimiterParsingDisabled;
    }

    public String getDefaultListDelimiter() {
        return this.defaultListDelimiter;
    }

    public void setDefaultListDelimiter(String defaultListDelimiter) {
        this.defaultListDelimiter = defaultListDelimiter;
    }

    private class ServiceDiscoveryPresenceAwarness
    extends Thread {
        private int levelInstanceId = -1;
        private int leaseExpiration = -1;

        public ServiceDiscoveryPresenceAwarness(int levelInstanceId, int leaseExpiration) {
            this.levelInstanceId = levelInstanceId;
            this.leaseExpiration = leaseExpiration;
            this.setName("ServiceDiscoveryPresenceAwarness");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            LOGGER.info("running ServiceDiscoveryPresenceAwarness thread");
            while (true) {
                try {
                    while (true) {
                        long timeToSleep = TimeUnit.SECONDS.toMillis(this.leaseExpiration);
                        Thread.sleep(timeToSleep - 100L);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.trace("interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private class DynamicConfigurationSupport
    extends Thread {
        public DynamicConfigurationSupport() {
            this.setName("DynamicConfigurationSupport");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            LOGGER.info("started re-load thread");
            while (true) {
                long timeInterval = configuration.getLong("configuration.dynamicConfigReload.refreshDelay");
                LOGGER.trace("running re-load thread");
                try {
                    FoundationCompositeConfiguration newConfig = new FoundationCompositeConfiguration();
                    CentralConfigurationUtil.INSTANCE.loadCentralConfiguration(newConfig, CommonConfigurationsLoader.this.descriptionMap, CommonConfigurationsLoader.this.enablesDynamicSupportSet);
                    boolean hasChanged = false;
                    for (String key : CommonConfigurationsLoader.this.enablesDynamicSupportSet) {
                        String newValue = newConfig.getString(key);
                        if (configuration.getString(key) == null || configuration.getString(key).equals(newValue)) continue;
                        LOGGER.info("found a change in the configuration schema for key: {}. new value is: {}", (Object)key, (Object)newValue);
                        hasChanged = true;
                        configuration.setProperty(key, (Object)newValue);
                    }
                    if (hasChanged) {
                        FoundationCompositeConfiguration compositeConfiguration = (FoundationCompositeConfiguration)configuration;
                        compositeConfiguration.clearCache();
                        CommonConfigurationsLoader.this.createFallBackFile(configuration);
                        configuration.getLong("configuration.dynamicConfigReload.refreshDelay");
                        FoundationConfigurationListenerRegistry.fireConfigurationChangedEvent();
                    }
                    Thread.sleep(timeInterval);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Cannot update the dynamic configuration. Message is: " + e.getMessage(), (Throwable)e);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e1) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

