/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import com.cisco.oss.foundation.logging.ApplicationStateInterface;
import com.cisco.oss.foundation.logging.FoundationLevel;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ConfigResourcesLoader
implements FactoryBean<List<Resource>>,
ApplicationContextAware,
InitializingBean {
    private static final String CUSTOMER_CONFIG = "config.properties";
    private static final String CONFIGURATION_TEST_CLASS = "com.cisco.oss.foundation.test.util.ConfigurationForTest";
    private static final String TEST_CONFIG_FILE = "testConfigFile";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigResourcesLoader.class);
    private static boolean LOAD_CONFIG_FROM_WORKING_DIR = Boolean.getBoolean("configuration.loadConfigFromWorkingDir");
    private static boolean printedToLog = false;
    private final List<Resource> resourcesList = new ArrayList<Resource>();
    private ApplicationContext context;
    private String internalPropertyConfig;
    private String internalXmlConfig;
    private List<String> customerPropertyConfig;
    private List<String> deploymentConfig;
    private ApplicationStateInterface applicationState;

    public void setInternalPropertyConfig(String internalPropertyConfig) {
        this.internalPropertyConfig = internalPropertyConfig;
    }

    public void setInternalXmlConfig(String internalXmlConfig) {
        this.internalXmlConfig = internalXmlConfig;
    }

    public void setCustomerConfig(List<String> customerConfig) {
        this.customerPropertyConfig = customerConfig;
    }

    public void setDeploymentConfig(List<String> deploymentConfig) {
        this.deploymentConfig = deploymentConfig;
    }

    public List<Resource> getObject() throws Exception {
        return this.resourcesList;
    }

    public Class<List> getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setApplicationState(ApplicationStateInterface applicationState) {
        this.applicationState = applicationState;
    }

    public void afterPropertiesSet() throws Exception {
        boolean isQCEnabld = this.isQCEnabled();
        Resource customerPropertyResource = null;
        Resource deploymentResource = null;
        Resource qcResource = null;
        if (isQCEnabld) {
            LOGGER.info("Found the ConfigurationTest class indicating that QC config is to be used instead of deployment and customer config files!");
            qcResource = this.validateQCResource();
        } else {
            customerPropertyResource = this.validateCustomerPropertyConfig();
            deploymentResource = this.validateDeploymentConfig();
            if (!printedToLog) {
                StringBuffer logMessageBuffer = new StringBuffer("The customer resources loaded are:");
                this.printResourcesLoaded(logMessageBuffer, customerPropertyResource);
                if (this.applicationState != null) {
                    this.applicationState.setState(FoundationLevel.INFO, (Object)logMessageBuffer.toString());
                }
                if (deploymentResource != null) {
                    logMessageBuffer = new StringBuffer("The deployment resources loaded are:");
                    this.printResourcesLoaded(logMessageBuffer, deploymentResource);
                    if (this.applicationState != null) {
                        this.applicationState.setState(FoundationLevel.INFO, (Object)logMessageBuffer.toString());
                    }
                }
            }
        }
        Resource[] internalPropertyResources = this.context.getResources(this.internalPropertyConfig);
        List<Resource> internalPropertyResourcesList = Arrays.asList(internalPropertyResources);
        Resource[] internalXmlResources = this.context.getResources(this.internalXmlConfig);
        List<Resource> internalXmlResourcesList = Arrays.asList(internalXmlResources);
        if (!printedToLog) {
            StringBuffer logMessageBuffer = new StringBuffer("The default resources loaded are:");
            this.printResourcesLoaded(logMessageBuffer, internalXmlResourcesList);
            this.printResourcesLoaded(logMessageBuffer, internalPropertyResourcesList);
            if (this.applicationState != null) {
                this.applicationState.setState(FoundationLevel.INFO, (Object)logMessageBuffer.toString());
            }
            printedToLog = true;
        }
        this.resourcesList.addAll(internalPropertyResourcesList);
        this.resourcesList.addAll(internalXmlResourcesList);
        if (deploymentResource != null) {
            this.resourcesList.add(deploymentResource);
        }
        if (customerPropertyResource != null) {
            this.resourcesList.add(customerPropertyResource);
        }
        if (qcResource != null) {
            this.resourcesList.add(qcResource);
        }
    }

    private Resource validateQCResource() {
        ClassPathResource qcResource = null;
        String qcFile = System.getProperty(TEST_CONFIG_FILE);
        if (StringUtils.isBlank((String)qcFile)) {
            qcFile = CUSTOMER_CONFIG;
        }
        if (!qcFile.equals(CUSTOMER_CONFIG) && !qcFile.matches(".*(?i)test(?-i).*")) {
            throw new IllegalArgumentException("The test config file name is not valid. it must containt the word 'test' in it, but it does not. the file names processed is: " + qcFile);
        }
        LOGGER.debug("searching for the file name: " + qcFile);
        qcResource = new ClassPathResource(qcFile);
        return qcResource;
    }

    private boolean isQCEnabled() {
        boolean isQCEnabled = true;
        try {
            Class.forName(CONFIGURATION_TEST_CLASS);
        }
        catch (ClassNotFoundException e) {
            isQCEnabled = false;
        }
        return isQCEnabled;
    }

    private Resource validateCustomerPropertyConfig() {
        String resource;
        Resource customerResource = null;
        boolean isValid = false;
        Iterator<String> i$ = this.customerPropertyConfig.iterator();
        while (i$.hasNext() && !(isValid = this.validateResourceIsValid(customerResource = this.context.getResource(resource = i$.next())))) {
        }
        if (Boolean.valueOf(System.getenv("_CCP_ENABLED")).booleanValue()) {
            customerResource = null;
        } else if (!isValid && !customerResource.getFilename().contains("dummyConfig")) {
            if (LOAD_CONFIG_FROM_WORKING_DIR) {
                FileSystemResource fileSystemResource = new FileSystemResource(CUSTOMER_CONFIG);
                isValid = this.validateResourceIsValid((Resource)fileSystemResource);
                if (!isValid) {
                    LOGGER.error("could not find the file: " + fileSystemResource.getFilename());
                    return null;
                }
                customerResource = fileSystemResource;
            } else if (!CUSTOMER_CONFIG.equals(customerResource.getFilename())) {
                customerResource = this.context.getResource("classpath:/config.properties");
                isValid = this.validateResourceIsValid(customerResource);
                if (!isValid) {
                    LOGGER.error("could not find the file: " + customerResource.getFilename());
                    return null;
                }
            } else {
                LOGGER.error("could not find the file: " + customerResource.getFilename());
                return null;
            }
        }
        return customerResource;
    }

    private Resource validateDeploymentConfig() {
        String resource;
        if (this.deploymentConfig == null) {
            return null;
        }
        Resource deploymentResource = null;
        boolean isValid = false;
        Iterator<String> i$ = this.deploymentConfig.iterator();
        while (i$.hasNext() && !(isValid = this.validateResourceIsValid(deploymentResource = this.context.getResource(resource = i$.next())))) {
        }
        if (!isValid) {
            LOGGER.trace("Could not find the file: deploymentConfig.properties in the class path");
            return null;
        }
        return deploymentResource;
    }

    private boolean validateResourceIsValid(Resource externalResource) {
        boolean isValid = true;
        try {
            URL url = externalResource.getURL();
            if (url.getPath() != null && url.getPath().contains(".jar") && !url.getPath().contains("dummyConfig")) {
                throw new IllegalArgumentException("The customer config file: \"config.properties\" was found in a jar file. This is not legal. Offending jar is: " + url.getPath());
            }
        }
        catch (IOException e) {
            isValid = false;
        }
        return isValid;
    }

    private void printResourcesLoaded(StringBuffer logMessageBuffer, Resource resource) throws IOException {
        if (resource == null) {
            LOGGER.debug("Loaded a null resource in the resources list");
        } else {
            logMessageBuffer.append('\n');
            logMessageBuffer.append(resource.getURL()).append(" config file loaded");
        }
    }

    private void printResourcesLoaded(StringBuffer logMessageBuffer, List<Resource> resourcesList) throws IOException {
        for (Resource resource : resourcesList) {
            this.printResourcesLoaded(logMessageBuffer, resource);
        }
    }
}

