/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import com.cisco.oss.foundation.configuration.FoundationCompositeConfiguration;
import com.cisco.oss.foundation.configuration.FoundationFileChangedReloadingStrategy;
import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicReloadSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicReloadSupport.class);
    private final CompositeConfiguration configuration;

    private DynamicReloadSupport(CompositeConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        LOGGER.debug("in DynamicReloadSupport init method");
        boolean isDynamicReLoadEnabled = this.configuration.getBoolean("configuration.dynamicConfigReload.enabled", false);
        boolean isDynamicReloadAutoUpdateEnabled = true;
        long refreshDelay = this.configuration.getLong("configuration.dynamicConfigReload.refreshDelay", 30000L);
        if (isDynamicReLoadEnabled) {
            LOGGER.info("configuration dynamic reload is enabled!");
            int numberOfConfigurations = this.configuration.getNumberOfConfigurations();
            for (int index = 0; index < numberOfConfigurations; ++index) {
                Configuration config = this.configuration.getConfiguration(index);
                if (!(config instanceof PropertiesConfiguration)) continue;
                PropertiesConfiguration propertiesConfiguration = (PropertiesConfiguration)config;
                String fileName = propertiesConfiguration.getFileName();
                if (fileName == null) {
                    fileName = propertiesConfiguration.getBasePath();
                }
                if (fileName.startsWith("default")) continue;
                LOGGER.debug("Setting reload strategy on: " + propertiesConfiguration.getPath());
                FoundationFileChangedReloadingStrategy strategy = new FoundationFileChangedReloadingStrategy();
                strategy.setRefreshDelay(refreshDelay);
                propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)strategy);
            }
            if (isDynamicReloadAutoUpdateEnabled) {
                this.startDynamicReloadAutoUpdateDeamon((Configuration)this.configuration, refreshDelay);
            }
        }
    }

    private void startDynamicReloadAutoUpdateDeamon(final Configuration configuration, long refreshDelay) {
        Timer timer = new Timer("DynamicReloadAutoUpdate", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    Field configCacheField = FoundationCompositeConfiguration.class.getDeclaredField("DISABLE_CACHE");
                    configCacheField.setAccessible(true);
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(configCacheField, configCacheField.getModifiers() & 0xFFFFFFEF);
                    boolean disableCahce = (Boolean)configCacheField.get(configuration);
                    if (!disableCahce) {
                        configCacheField.set(configuration, Boolean.TRUE);
                        configuration.getProperty("configuration.dynamicConfigReload.enabled");
                        configCacheField.set(configuration, Boolean.FALSE);
                    } else {
                        configuration.getProperty("configuration.dynamicConfigReload.enabled");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem reloading the configuration", (Throwable)e);
                }
            }
        }, refreshDelay, refreshDelay);
    }
}

