/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.CompositeConfiguration;

public class FoundationCompositeConfiguration
extends CompositeConfiguration {
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private static final boolean DISABLE_CACHE = Boolean.getBoolean("configuration.disableCache");

    public Iterator<String> getKeys() {
        Iterator tempKeysIter = super.getKeys();
        List<String> keys = this.sortKeys(tempKeysIter);
        return keys.iterator();
    }

    private List<String> sortKeys(Iterator<String> tempKeysIter) {
        ArrayList<String> keys = new ArrayList<String>();
        while (tempKeysIter.hasNext()) {
            String key = tempKeysIter.next();
            keys.add(key);
        }
        Collections.sort(keys);
        return keys;
    }

    public boolean containsKey(String key) {
        if (DISABLE_CACHE) {
            return super.containsKey(key);
        }
        return this.cache.containsKey(key);
    }

    public Object getProperty(String key) {
        if (DISABLE_CACHE) {
            return super.getProperty(key);
        }
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        Object value = super.getProperty(key);
        if (value != null) {
            this.cache.put(key, value);
        }
        return value;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void updateCache(String key, Object value) {
        if (value == null) {
            this.cache.remove(key);
        } else {
            this.cache.put(key, value);
        }
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
        this.updateCache(key, value);
    }
}

