/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.oss.foundation.configuration;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class FoundationConfigurationFileNameResolver
implements BeanFactoryAware {
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            cbf.setBeanExpressionResolver((BeanExpressionResolver)new StandardBeanExpressionResolver(){

                protected void customizeEvaluationContext(StandardEvaluationContext evalContext) {
                    evalContext.addMethodResolver((MethodResolver)new CabConfigurationReflectiveMethodResolver());
                }
            });
        }
    }

    public static String resolveConfigFileName() {
        String processName = System.getProperty("app.instance.name");
        if (StringUtils.isNotBlank((String)processName)) {
            return "classpath:config." + processName + ".properties";
        }
        return "classpath:config.properties";
    }

    private class CabConfigurationMethodExecutor
    implements MethodExecutor {
        private CabConfigurationMethodExecutor() {
        }

        public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
            try {
                return new TypedValue((Object)FoundationConfigurationFileNameResolver.resolveConfigFileName(), new TypeDescriptor(new MethodParameter(FoundationConfigurationFileNameResolver.class.getDeclaredMethod("resolveConfigFileName", new Class[0]), -1)));
            }
            catch (Exception ex) {
                throw new AccessException("Problem invoking method: resolveConfigFileName", ex);
            }
        }
    }

    private class CabConfigurationReflectiveMethodResolver
    extends ReflectiveMethodResolver {
        private CabConfigurationReflectiveMethodResolver() {
        }

        public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
            if ("resolveConfigFileName".equals(name)) {
                return new CabConfigurationMethodExecutor();
            }
            return super.resolve(context, targetObject, name, argumentTypes);
        }
    }
}

