/*
 * Copyright 2014 Cisco Systems, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.cisco.oss.foundation.monitoring;

import javax.xml.bind.annotation.XmlType;

/**
 * Base interface that needs to be extended and implemented by applications that
 * needs to be monitored.
 *
 * @author manojc
 * @see com.cisco.oss.foundation.monitoring.MonitoringAgent
 */
@XmlType
public interface MonitoringMXBean {
    /**
     * Name of the component.Name can be Acronym.
     */
    String getName();

    /**
     * Full name of the component.
     */
    String getFullName();

    /**
     * Instance Name format must be
     */
    String getInstance();

    /**
     * Component version
     */
    String getVersion();


}
