/*
 * Decompiled with CFR 0.152.
 */
package me.helloworld.utils;

public class Chars {
    private static final byte[] toUpper = new byte[256];
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isAlpha = new boolean[256];
    private static final boolean[] isUpper = new boolean[256];
    private static final boolean[] isLower = new boolean[256];
    private static final boolean[] isWhite = new boolean[256];
    private static final boolean[] isDigit = new boolean[256];
    private static final String TOKEN = "-.!%*_+`'~";
    private static final String LWS = " \r\n\t";
    private static final String LB = "\r\n";
    private static final String MARK = "-_.!~*'()";
    private static final String USERUNRES = "&=+$,;?/";
    private static final String PASSUNRES = "&=+$,";
    private static final String PARAMUNRES = "[]/:&+$";
    private static final String HNVUNRES = "[]/?:+$";

    public static int toUpper(int c) {
        return toUpper[c & 0xFF] & 0xFF;
    }

    public static int toLower(int c) {
        return toLower[c & 0xFF] & 0xFF;
    }

    public static boolean isUpper(int c) {
        return isUpper[c & 0xFF];
    }

    public static boolean isLower(int c) {
        return isLower[c & 0xFF];
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isControl(int c) {
        return c >= 0 && c < 32 || c == 127;
    }

    public static boolean isAlpha(int c) {
        return isAlpha[c & 0xFF];
    }

    public static boolean isDigit(int c) {
        return isDigit[c & 0xFF];
    }

    public static boolean isAlphaNum(int c) {
        return Chars.isAlpha(c) || Chars.isDigit(c);
    }

    public static boolean isWhitespace(int c) {
        return isWhite[c & 0xFF];
    }

    public static boolean isToken(int c) {
        return Chars.isAlphaNum(c) || TOKEN.indexOf(c) > -1;
    }

    public static boolean isLWS(int c) {
        return LWS.indexOf(c) > -1;
    }

    public static boolean isLB(int c) {
        return LB.indexOf(c) > -1;
    }

    public static boolean isMark(int c) {
        return MARK.indexOf(c) > -1;
    }

    public static boolean isUnreserved(int c) {
        return Chars.isAlphaNum(c) || c == 45 || c == 46 || c == 95 || c == 126;
    }

    public static boolean isReserved(char c) {
        return Chars.isGenericDelimiter(c) || Chars.isSubDelimiter(c);
    }

    public static boolean isGenericDelimiter(int c) {
        switch (c) {
            case 35: 
            case 47: 
            case 58: 
            case 63: 
            case 64: 
            case 91: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSubDelimiter(int c) {
        switch (c) {
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 59: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPchar(char c) {
        return Chars.isUnreserved(c) || Chars.isSubDelimiter(c) || c == ':' || c == '@';
    }

    public static boolean isUserUnreserved(int c) {
        return USERUNRES.indexOf(c) > -1;
    }

    public static boolean isPassUnreserved(int c) {
        return PASSUNRES.indexOf(c) > -1;
    }

    public static boolean isParamUnreserved(int c) {
        return PARAMUNRES.indexOf(c) > -1;
    }

    public static boolean isHNVUnreserved(int c) {
        return HNVUNRES.indexOf(c) > -1;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Chars.toUpper[i] = (byte)i;
            Chars.toLower[i] = (byte)i;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            int uc = lc + 65 - 97;
            Chars.toUpper[lc] = (byte)uc;
            Chars.toLower[uc] = (byte)lc;
            Chars.isAlpha[lc] = true;
            Chars.isAlpha[uc] = true;
            Chars.isLower[lc] = true;
            Chars.isUpper[uc] = true;
        }
        Chars.isWhite[32] = true;
        Chars.isWhite[9] = true;
        Chars.isWhite[13] = true;
        Chars.isWhite[10] = true;
        Chars.isWhite[12] = true;
        Chars.isWhite[8] = true;
        for (int d = 48; d <= 57; ++d) {
            Chars.isDigit[d] = true;
        }
    }
}

